/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.objects;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;

public class NavigationGraphSynchronized
extends DirectedSparseGraph<MyVertice, MyEdge> {
    private double learningTime;
    private long stucksCount;
    private long respawnCount;
    private Map<String, String> additionalProperties = null;
    public static final String PROPERTY_LearningTime = "LearningTime";
    public static final String PROPERTY_StucksCount = "StucksCount";
    public static final String PROPERTY_RespawnCount = "RespawnCount";

    public NavigationGraphSynchronized() {
        this.vertices = Collections.synchronizedMap(this.vertices);
        this.edges = Collections.synchronizedMap(this.edges);
    }

    public NavigationGraphSynchronized(double learningTime, long stucksCount, long respawnCount) {
        this();
        this.learningTime = learningTime;
        this.stucksCount = stucksCount;
        this.respawnCount = respawnCount;
    }

    public NavigationGraphSynchronized(double learningTime, long stucksCount, long respawnCount, Map<String, String> additionalProperties) {
        this(learningTime, stucksCount, respawnCount);
        this.additionalProperties = additionalProperties;
    }

    public MyVertice getVerticeFromLocation(Location navPoint) {
        for (MyVertice vert : this.getVertices()) {
            if (!vert.getLocation().equals(navPoint)) continue;
            return vert;
        }
        throw new RuntimeException("Vertice not found. Given location:" + navPoint);
    }

    public double getLearningTime() {
        double tmp = (double)Math.round(this.learningTime * 100.0) / 100.0;
        return tmp;
    }

    public long getStucksCount() {
        return this.stucksCount;
    }

    public long getRespawnCount() {
        return this.respawnCount;
    }

    public void increaseStucksCount() {
        ++this.stucksCount;
    }

    public void increaseRespawnCount() {
        ++this.respawnCount;
    }

    public void addLearningTime(double time) {
        this.learningTime += time;
    }

    public MyEdge getEdgeBetweenVertices(MyVertice from, MyVertice to) {
        MyEdge navrat = (MyEdge)this.findEdge(from, to);
        if (navrat != null) {
            return navrat;
        }
        throw new RuntimeException("No edge found between vertice " + from + " and vertice " + to + "!");
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, String>();
        }
        return this.additionalProperties;
    }

    public void addAdditionalParameter(String key, String value) {
        this.getAdditionalProperties().put(key, value);
    }

    public String getAdditionalParameter(String key) {
        return this.getAdditionalProperties().get(key);
    }
}

