/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.pathPlanners;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import sk.stuba.fiit.pogamut.jungigation.objects.MyVertice;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;

public class MapExpert {
    private final NavigationGraphSynchronized navGraph;
    private final Random rnd = new Random();

    public MapExpert(NavigationGraphSynchronized navGraph) {
        this.navGraph = navGraph;
    }

    public Location getRandomPointWithinTime(Location loc, double maxTime) {
        DijkstraDistance a = new DijkstraDistance((Graph)this.navGraph);
        MyVertice source = this.navGraph.getVerticeFromLocation(loc);
        Map distances = a.getDistanceMap((Object)source);
        ArrayList possibleTargets = new ArrayList(distances.size() / 10);
        for (Map.Entry dist : distances.entrySet()) {
            if (!(((Number)dist.getValue()).doubleValue() <= maxTime)) continue;
            possibleTargets.add(dist.getKey());
        }
        int max = possibleTargets.size();
        int randomIndex = this.rnd.nextInt(max);
        return ((MyVertice)possibleTargets.get(randomIndex)).getLocation();
    }

    public Location getEnemyFlagHome(int myTeam) {
        switch (myTeam) {
            case 1: {
                myTeam = 0;
                break;
            }
            case 0: {
                myTeam = 1;
                break;
            }
            default: {
                throw new RuntimeException("Unknown team!");
            }
        }
        String team = this.getTeamString(myTeam);
        for (MyVertice vert : this.navGraph.getVertices()) {
            String lowercasename = vert.getId().getStringId().toLowerCase();
            if (!lowercasename.contains("flag") || !lowercasename.contains(team)) continue;
            return vert.getLocation();
        }
        throw new RuntimeException("Enemy flag home could not be found. Searching for navpoint which have \"" + team + "\" and \"flag\" in name.");
    }

    public Location getMyFlagHome(int myTeam) {
        String team = this.getTeamString(myTeam);
        for (MyVertice vert : this.navGraph.getVertices()) {
            String lowercasename = vert.getId().getStringId().toLowerCase();
            if (!lowercasename.contains("flag") || !lowercasename.contains(team)) continue;
            return vert.getLocation();
        }
        throw new RuntimeException("Enemy flag home could not be found. Searching for navpoint which have \"" + team + "\" and \"flag\" in name.");
    }

    private String getTeamString(int team) {
        String color;
        switch (team) {
            case 1: {
                color = "blue";
                break;
            }
            case 0: {
                color = "red";
                break;
            }
            default: {
                throw new RuntimeException("Unknown team!");
            }
        }
        return color;
    }

    public List<MyVertice> getAllSpawnsForTeam(int team) {
        ArrayList<MyVertice> navrat = new ArrayList<MyVertice>();
        for (MyVertice v : this.navGraph.getVertices().toArray(new MyVertice[this.navGraph.getVertexCount()])) {
            if (v.getSpawnFor() != team) continue;
            navrat.add(v);
        }
        return navrat;
    }
}

