/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.objects;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.ProphetObjectVision;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.UpdateAndDeleteListener;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.UpdateListener;

public class NotifiableMap<CONCRETECONTAINEDCLASS extends ProphetObjectVision<CONCRETECONTAINEDCLASS>>
implements UpdateAndDeleteListener<CONCRETECONTAINEDCLASS> {
    private List<UpdateAndDeleteListener<CONCRETECONTAINEDCLASS>> listeners = Collections.synchronizedList(new ArrayList());
    private Map<UnrealId, CONCRETECONTAINEDCLASS> mapData = Collections.synchronizedMap(new HashMap());

    public void addChangeListener(UpdateAndDeleteListener<CONCRETECONTAINEDCLASS> listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(UpdateAndDeleteListener<CONCRETECONTAINEDCLASS> listener) {
        this.listeners.remove(listener);
    }

    protected void notifyOfChangeAllListeners(CONCRETECONTAINEDCLASS changedOrAddedObject) {
        for (UpdateListener listener : this.listeners.toArray(new UpdateListener[this.listeners.size()])) {
            try {
                listener.notifyOfChange(changedOrAddedObject);
            }
            catch (Exception ex) {
                System.err.println("Problem while notifiing some of listener! Continuing. Error:" + ex);
            }
        }
    }

    protected void notifyOfDeleteAllListeners(CONCRETECONTAINEDCLASS deletedInstance) {
        for (UpdateListener listener : this.listeners.toArray(new UpdateListener[this.listeners.size()])) {
            try {
                listener.notifyOfChange(deletedInstance);
            }
            catch (Exception ex) {
                System.err.println("Problem while notifiing some of listener! Continuing. Error:" + ex);
            }
        }
    }

    @Override
    public void notifyOfChange(CONCRETECONTAINEDCLASS changedOrAddedObject) {
        this.notifyOfChangeAllListeners(changedOrAddedObject);
    }

    @Override
    public void notifyOfDelete(CONCRETECONTAINEDCLASS deletedInstance) {
        this.notifyOfDeleteAllListeners(deletedInstance);
    }

    public void addObject(UnrealId id, CONCRETECONTAINEDCLASS object) {
        this.mapData.put(id, object);
        ((ProphetObjectVision)object).addChangeListener(this);
        this.notifyOfChange(object);
    }

    public void removeObject(UnrealId id, CONCRETECONTAINEDCLASS object) {
        this.mapData.remove(id);
        ((ProphetObjectVision)object).removeChangeListener(this);
        this.notifyOfDelete(object);
    }

    public Map<UnrealId, CONCRETECONTAINEDCLASS> getMap() {
        return this.mapData;
    }
}

