/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.NotifiableMap;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objects.SimpleGamerInfo;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.GamersCache;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.objectsCache.misc.LocationValhalla;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.snapshoot.PlayerSnapshot;

public class GamersProphet
extends GamersCache {
    private static final Logger log = Logger.getLogger(GamersProphet.class);
    private final NotifiableMap<SimpleGamerInfo> allGamers = new NotifiableMap();
    private final NotifiableMap<SimpleGamerInfo> enemyGamers = new NotifiableMap();
    private final int team;

    public GamersProphet(IWorldView worldView, int team) {
        super(worldView);
        this.team = team;
    }

    public NotifiableMap<SimpleGamerInfo> getGamers() {
        return this.allGamers;
    }

    public NotifiableMap<SimpleGamerInfo> getEnemyGamers() {
        return this.enemyGamers;
    }

    @Override
    protected void notifyOfPlayerChange(Player event) {
        super.notify(event);
        Map<UnrealId, SimpleGamerInfo> map = this.allGamers.getMap();
        SimpleGamerInfo smi = map.get(event.getId());
        List<PlayerSnapshot> history = this.getPlayerHistory(event.getId());
        boolean isEnemy = this.team != event.getTeam();
        smi = new SimpleGamerInfo(event.getId(), GamersProphet.getEstimatedLocation(history), isEnemy, false);
        smi.setLastSeenTime(event.getSimTime());
        map.put(event.getId(), smi);
        this.allGamers.notifyOfChange(smi);
        if (isEnemy) {
            this.enemyGamers.getMap().put(event.getId(), smi);
            this.enemyGamers.notifyOfChange(smi);
        }
    }

    @Override
    protected void notifyOfSelfChange(Self event) {
        super.notify(event);
        Map<UnrealId, SimpleGamerInfo> map = this.allGamers.getMap();
        SimpleGamerInfo smi = map.get(event.getId());
        boolean isEnemy = this.team != event.getTeam();
        HashSet<Map.Entry<Location, Double>> loc = new HashSet<Map.Entry<Location, Double>>();
        loc.add(new AbstractMap.SimpleImmutableEntry<Location, Double>(event.getLocation(), 0.99));
        smi = new SimpleGamerInfo(event.getId(), loc, isEnemy, true);
        smi.setLastSeenTime(event.getSimTime());
        map.put(event.getId(), smi);
        this.allGamers.notifyOfChange(smi);
        if (isEnemy) {
            log.warn((Object)("Enemy is sending us self messages! I am team " + this.team + " and enemy team and is is " + event.getTeam() + ", " + event.getId()));
            this.enemyGamers.getMap().put(event.getId(), smi);
            this.enemyGamers.notifyOfChange(smi);
        }
    }

    protected static Set<Map.Entry<Location, Double>> getEstimatedLocation(List<PlayerSnapshot> history) {
        Location loc;
        double probability;
        HashSet<Map.Entry<Location, Double>> navrat = new HashSet<Map.Entry<Location, Double>>();
        PlayerSnapshot last = history.get(0);
        if (last.getLocation() instanceof LocationValhalla) {
            probability = 0.01;
            loc = last.getLocation();
        } else {
            probability = last.getAge();
            if (probability < 1.0) {
                probability = 0.9;
            } else {
                probability = 0.2;
                Location tip = last.getLocation().add(last.getVelocity().scale(last.getAge()));
                double tipProb = 0.2 - last.getAge() / 100.0;
                double d = tipProb = tipProb < 0.0 ? 0.001 : tipProb;
                if (tipProb > 0.07) {
                    AbstractMap.SimpleImmutableEntry<Location, Double> generatedPosition = new AbstractMap.SimpleImmutableEntry<Location, Double>(tip, tipProb);
                    navrat.add(generatedPosition);
                }
            }
            loc = last.getLocation();
        }
        AbstractMap.SimpleImmutableEntry<Location, Double> lastPosition = new AbstractMap.SimpleImmutableEntry<Location, Double>(loc, probability);
        navrat.add(lastPosition);
        return navrat;
    }

    public void reestimateAllPlayers() {
        Map<UnrealId, SimpleGamerInfo> map = this.allGamers.getMap();
        for (SimpleGamerInfo gamer : map.values()) {
            SimpleGamerInfo smi = map.get(gamer.getId());
            boolean isSelf = gamer.isSelf();
            boolean isEnemy = gamer.isEnemy();
            Set<Map.Entry<Location, Double>> loc = null;
            if (isSelf) continue;
            List<PlayerSnapshot> history = this.getPlayerHistory(gamer.getId());
            loc = GamersProphet.getEstimatedLocation(history);
            smi = new SimpleGamerInfo(gamer.getId(), loc, isEnemy, isSelf);
            smi.setLastSeenTime(gamer.getLastSeenTime());
            map.put(smi.getId(), smi);
        }
    }
}

