/*
 * Decompiled with CFR 0.152.
 */
package sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.Box;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphProviderForMap;
import sk.stuba.fiit.pogamut.jungigation.objects.NavigationGraphSynchronized;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.GameTime;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets.FlagsProphet;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets.GamersProphet;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets.ItemsProphet;
import sk.stuba.fiit.pogamut.jungigation.worldInfo.prophets.WorldProphetFrame;

public class WorldProphet {
    private static final Map<Integer, WorldProphet> mapForTeamGame = Collections.synchronizedMap(new HashMap());
    private final GamersProphet gamersProphet;
    private final ItemsProphet itemsProphet;
    private final FlagsProphet flagsProphet;
    private final int team;
    private final GameInfo gameInfo;
    private final Box mapBox;
    private final WorldProphetFrame frame;
    private final NavigationGraphSynchronized navigationMap;

    public WorldProphet(IWorldView worldView, GameInfo gameInfo) {
        this(worldView, 255, gameInfo, true);
    }

    public WorldProphet(IWorldView worldView, GameInfo gameInfo, boolean shouldBeProphetWindowOpenned) {
        this(worldView, 255, gameInfo, shouldBeProphetWindowOpenned);
    }

    private WorldProphet(IWorldView worldView, int team, GameInfo gameInfo, boolean shouldBeProphetWindowOpenned) {
        this.team = team;
        this.gameInfo = gameInfo;
        this.gamersProphet = new GamersProphet(worldView, this.team);
        this.itemsProphet = new ItemsProphet(worldView, this.gamersProphet);
        this.flagsProphet = new FlagsProphet(worldView, this.team, this.gameInfo, this.gamersProphet);
        this.navigationMap = NavigationGraphProviderForMap.getInstance().getNavigationDataForMap(this.gameInfo.getLevel());
        Collection<NavPoint> navpoints = worldView.getAll(NavPoint.class).values();
        this.mapBox = WorldProphet.calculateBox(navpoints);
        if (shouldBeProphetWindowOpenned) {
            this.frame = new WorldProphetFrame();
            this.frame.getWorldProphetPanel().setWorldProphet(this);
            this.frame.setVisible(true);
        } else {
            this.frame = null;
        }
    }

    public FlagsProphet getFlagsProphet() {
        return this.flagsProphet;
    }

    public GamersProphet getGamersProphet() {
        return this.gamersProphet;
    }

    public ItemsProphet getItemsProphet() {
        return this.itemsProphet;
    }

    private static Box calculateBox(Collection<NavPoint> navpoints) {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (NavPoint navPoint : navpoints) {
            double x = navPoint.getLocation().x;
            if (minX > x) {
                minX = x;
            } else if (maxX < x) {
                maxX = x;
            }
            double y = navPoint.getLocation().y;
            if (minY > y) {
                minY = y;
            } else if (maxY < y) {
                maxY = y;
            }
            double z = navPoint.getLocation().z;
            if (minZ > z) {
                minZ = z;
                continue;
            }
            if (!(maxZ < z)) continue;
            maxZ = z;
        }
        return new Box(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static WorldProphet getInstance(IWorldView worldView, int team, GameInfo info, boolean shouldBeProphetWindowOpenned) {
        WorldProphet navrat = mapForTeamGame.get(team);
        if (navrat == null) {
            GameTime.forceStartUpdatingTime(worldView);
            navrat = new WorldProphet(worldView, team, info, shouldBeProphetWindowOpenned);
            mapForTeamGame.put(team, navrat);
        }
        navrat.addMoreWorldView(worldView);
        return navrat;
    }

    public static WorldProphet getInstance(IWorldView worldView, int team, GameInfo info) {
        return WorldProphet.getInstance(worldView, team, info, false);
    }

    protected void addMoreWorldView(IWorldView worldView) {
        this.itemsProphet.addAnotherViewer(worldView);
        this.gamersProphet.addAnotherViewer(worldView);
        this.flagsProphet.addAnotherViewer(worldView);
    }

    public void removeViewer(IWorldView worldView) {
        this.itemsProphet.removeViewer(worldView);
        this.gamersProphet.removeViewer(worldView);
        this.flagsProphet.removeViewer(worldView);
    }

    public Box getMapBox() {
        return this.mapBox;
    }

    public int getTeam() {
        return this.team;
    }
}

