/**
 * 
 */
package jung.myalghoritm.AStar;

import java.util.Comparator;

/**
 * <p>
 * Compares two objects based only on {@link VerticeForAStar#f_score} values.
 * </p>
 * 
 * @author LuVar
 *
 */
public class VerticeForAStarComparator<V> implements Comparator<VerticeForAStar<V>> {
    @Override
    public int compare(VerticeForAStar<V> o1, VerticeForAStar<V> o2) {
	if(o1 == null && o2 == null) {
	    return 0;
	}
	if(o1 == null) {
	    return 1;
	}
	if(o2 == null) {
	    return -1;
	}
	int navrat = Double.compare(o1.f_score, o2.f_score);
	if(navrat == 0) {
	    navrat = Double.compare(o1.vertice.hashCode(), o2.vertice.hashCode());
	}
	return navrat;
    }
}
