package sk.stuba.fiit.pogamut.jungigation.objects;

import java.util.Map;

import sk.stuba.fiit.pogamut.jungigation.transformers.MetadataNodeTransformer;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

/**
 * <p>
 * This class is used as "alternative" for {@link NavPoint} class. It has {@link UnrealId} and {@link Location} stored in it.
 * Class is used in jungigation for any navigation purposes and represents vertex in navigation graph. 
 * </p>
 * 
 * @author LuVar
 * 
 * @see MetadataNodeTransformer
 */
public class MyVertice implements Comparable<MyVertice>, ILocated {
	private UnrealId id;
	private Location location;
	private String itemType;

	public double valueAdded = 0;

	/**
	 * <p>
	 * Uses constants from {@link AgentInfo} class. Default for non spawn point vertex is -1.
	 * </p>
	 */
	private int spawnFor = -1;
	private int itemAmount;

	public MyVertice(NavPoint navPoint) {
		this.id = navPoint.getId();
		this.location = navPoint.getLocation();
		ItemType it = navPoint.getItemClass();
		if (it != null) {
			this.itemType = it.getName();
		} else {
			this.itemType = null;
		}

		if (navPoint.isPlayerStart()) {
			this.spawnFor = navPoint.getTeamNumber();
		}

		Item i = navPoint.getItemInstance();
		if (i != null) {
			this.itemAmount = i.getAmount();
		} else {
			this.itemAmount = -1;
		}
	}// end of constructor

	public MyVertice(String serializedID, Map<String, String> map) {
		String locX = map.get("x");
		String locY = map.get("y");
		String locZ = map.get("z");
		String itemTypeS = map.get("ItemType");
		String itemAmountS = map.get("ItemAmount");
		String spawnForS = map.get("SpawnFor");
		double y, x, z;
		int amount, spawnFor;
		try {
			x = Double.parseDouble(locX);
			y = Double.parseDouble(locY);
			z = Double.parseDouble(locZ);
			if (itemAmountS == null) {
				amount = -1;
			} else {
				amount = Integer.parseInt(itemAmountS);
			}
			if (spawnForS == null) {
				spawnFor = -1;
			} else {
				spawnFor = Integer.parseInt(spawnForS);
			}
		} catch (Exception ex) {
			throw new RuntimeException("Error while parsing stored location from text (itemTypeS=" + itemTypeS + ",itemAmountS=" + itemAmountS + ",locX=" + locX + ",locY=" + locY + ",locZ=" + locZ + ") to double! Error:" + ex.getMessage(), ex);
		}
		this.id = UnrealId.get(serializedID);
		this.location = new Location(x, y, z);
		if (itemTypeS == null) {
			this.itemType = null;
		} else {
			this.itemType = itemTypeS;
		}
		this.itemAmount = amount;
		this.spawnFor = spawnFor;
	}// end of constructor

	/**
	 * <p>
	 * Constructor for testing purposes.
	 * </p>
	 * 
	 * @param serializedID
	 * @param location
	 */
	public MyVertice(String serializedID, Location location) {
		this.id = UnrealId.get(serializedID);
		this.location = location;
	}

	public final String getItemType() {
		return this.itemType;
	}

	/**
	 * <p>
	 * Returns if this vertice is spawn point. If yes, it has appropriate code for red and for blue team. If no, it has
	 * code {@link AgentInfo#TEAM_NONE} set.
	 * </p>
	 * 
	 * @return
	 */
	public int getSpawnFor() {
		return this.spawnFor;
	}

	public final int getItemAmount() {
		return this.itemAmount;
	}

	public UnrealId getId() {
		return this.id;
	}

	public Location getLocation() {
		return this.location;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof MyVertice) {
			MyVertice objVer = (MyVertice) obj;
			// TODO problem with case when map name in cmdline differs in case
			if (objVer.getId().getStringId().toLowerCase().equals(this.getId().getStringId().toLowerCase())) {
				if (objVer.getLocation().equals(this.getLocation())) {
					return true;
				}
			}
		}
		return false;
	}// end of method equals

	@Override
	public String toString() {
		return "MyVertice:" + this.getId() + ",loc:" + this.location + ",ItemType:" + this.itemType + ",ItemAmount:" + this.itemAmount + ",valueAdded:" + this.valueAdded;
	}

	@Override
	public int hashCode() {
		return this.id.getStringId().toLowerCase().hashCode();
	}

	@Override
	public int compareTo(MyVertice arg0) {
		if (this.equals(arg0)) {
			return 0;
		}
		int comp = this.id.getStringId().compareTo(arg0.id.getStringId());
		if (comp == 0) {
			System.err.println("TODO Probably ERROR!!! this=" + this.toString() + ";arg0=" + arg0);
		}
		return comp;
	}
}
