package sk.stuba.fiit.pogamut.jungigation.transformers;

import java.util.ArrayList;

import org.apache.commons.collections15.Transformer;

import sk.stuba.fiit.pogamut.jungigation.objects.MyEdge;
import sk.stuba.fiit.pogamut.jungigation.pathPlanners.PathPlannerForDataAcquisition;

/**
 * <p>
 * Transformer used in {@link PathPlanerForDataAcquisition} class for planing
 * path thru edges with less data acquired. It will try not to plan path thru
 * edges with more than 3 unsuccessful runs.  Some constants are configurable
 * thru constructor.
 * </p>
 * <p>
 * http://www.grotto-networking.com/JUNG/JUNG2-Tutorial.pdf chapter 3.2
 * </p>
 *
 * @author LuVar
 * 
 * @see	PathPlannerForDataAcquisition
 */
public class EdgeToDataCountNumberTransformer implements Transformer<MyEdge, Number> {
    private final double badTime;

    private final int badPenalizeCount;
    private final int badPenalizeScale;

    /**
     * <p>
     * Default constructor, which calls this code: <code>this(100,3,2);</code>
     * </p>
     */
    public EdgeToDataCountNumberTransformer() {
	this(100,3,2);
    }

    public EdgeToDataCountNumberTransformer(double badTime, int badPenalizeCount, int badPenalizeScale) {
	this.badTime = badTime;
	this.badPenalizeCount = badPenalizeCount;
	this.badPenalizeScale = badPenalizeScale;
    }

    @Override
    public Number transform(MyEdge i) {
	ArrayList<Double> times = i.getAllTravelTimes();
	int bad = 0;
	for (Double time : times) {
	    if(time > this.badTime) {
		bad++;
	    }
	}
	long vysledok = 0;
	if(bad > this.badPenalizeCount) {
	    vysledok = this.badPenalizeScale*bad;
	}
	vysledok += i.getNumberOfTravelsInArray();
	Number navrat = vysledok;
	return navrat;
    }
}
