/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import servlet.ApplyXSLTProperties;

public class DefaultApplyXSLTProperties
extends ApplyXSLTProperties {
    private final String DEFAULT_catalog;
    protected transient String localHost = null;
    protected static int port = 0;

    public DefaultApplyXSLTProperties() {
        this.DEFAULT_catalog = null;
        this.setLocalHost();
    }

    public DefaultApplyXSLTProperties(ServletConfig config) {
        super(config);
        String cat = config.getInitParameter("catalog");
        this.DEFAULT_catalog = cat != null ? cat : null;
        this.setLocalHost();
        this.setSystemProperties();
    }

    protected void setLocalHost() {
        try {
            this.localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception uhe) {
            this.localHost = null;
        }
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public URL toSafeURL(String xURL, HttpServletRequest request) throws MalformedURLException {
        if (port == 0) {
            port = request.getServerPort();
        }
        if (xURL == null) {
            return null;
        }
        if (xURL.startsWith("/")) {
            try {
                return new URL("http", this.localHost, port, xURL);
            }
            catch (MalformedURLException mue) {
                throw new MalformedURLException("toSafeURL(): " + xURL + " did not map to local");
            }
        }
        URL tempURL = null;
        try {
            tempURL = new URL(xURL);
        }
        catch (MalformedURLException mue) {
            throw new MalformedURLException("toSafeURL(): " + xURL + " not a valid URL");
        }
        try {
            return new URL(tempURL.getProtocol(), this.localHost, port, tempURL.getFile());
        }
        catch (MalformedURLException mue) {
            throw new MalformedURLException("toSafeURL(): " + xURL + " could not be converted to local host");
        }
    }

    public String getXMLurl(HttpServletRequest request) throws MalformedURLException {
        URL url = this.toSafeURL(this.getRequestParmString(request, "URL"), request);
        if (url == null) {
            return super.getXMLurl(null);
        }
        return url.toExternalForm();
    }

    public String getXSLRequestURL(HttpServletRequest request) throws MalformedURLException {
        URL url = this.toSafeURL(this.getRequestParmString(request, "xslURL"), request);
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    public String getXSLurl(HttpServletRequest request) throws MalformedURLException {
        String reqURL = this.getXSLRequestURL(request);
        if (reqURL != null) {
            return reqURL;
        }
        URL url = this.toSafeURL(super.getXSLurl(null), request);
        return url.toExternalForm();
    }

    public String[] getCatalog(HttpServletRequest request) {
        String[] temp = request.getParameterValues("catalog");
        if (this.DEFAULT_catalog == null) {
            return temp;
        }
        if (temp == null) {
            String[] defaultArray = new String[]{this.DEFAULT_catalog};
            return defaultArray;
        }
        int len = temp.length + 1;
        String[] newCatalogs = new String[len];
        newCatalogs[0] = this.DEFAULT_catalog;
        int i = 1;
        while (i < len) {
            newCatalogs[i] = temp[i - 1];
            ++i;
        }
        return newCatalogs;
    }

    protected void setSystemProperties() {
        Properties props = new Properties();
        ((Hashtable)props).put("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        ((Hashtable)props).put("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        ((Hashtable)props).put("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        Properties systemProps = System.getProperties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String prop = (String)propEnum.nextElement();
            if (((Hashtable)systemProps).containsKey(prop)) continue;
            ((Hashtable)systemProps).put(prop, props.getProperty(prop));
        }
        System.setProperties(systemProps);
    }
}

