/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.codehaus.plexus.util.FileUtils;

public class ScmFileSet {
    private static final String DEFAULT_EXCLUDES = "**/CVS/**,**/.svn/**";
    private File basedir;
    private File[] files;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];

    public ScmFileSet(File basedir) {
        this(basedir, EMPTY_FILE_ARRAY);
    }

    public ScmFileSet(File basedir, File file) {
        this(basedir, new File[]{file});
    }

    public ScmFileSet(File basedir, String includes, String excludes) throws IOException {
        this.basedir = basedir;
        excludes = excludes != null && excludes.length() > 0 ? excludes + ",**/CVS/**,**/.svn/**" : DEFAULT_EXCLUDES;
        this.files = FileUtils.getFiles((File)basedir, (String)includes, (String)excludes, (boolean)false).toArray(EMPTY_FILE_ARRAY);
    }

    public ScmFileSet(File basedir, File[] files) {
        if (basedir == null) {
            throw new NullPointerException("basedir must not be null");
        }
        if (files == null) {
            throw new NullPointerException("files must not be null");
        }
        this.basedir = basedir;
        this.files = files;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File[] getFiles() {
        return this.files;
    }

    public String toString() {
        return "basedir = " + this.basedir + "; files = " + Arrays.asList(this.files);
    }
}

