/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.SVNConsoleAuthenticationProvider;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svn.SVNAddCommand;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNCommandLineConflictHandler;
import org.tmatesoft.svn.cli.svn.SVNCommitCommand;
import org.tmatesoft.svn.cli.svn.SVNConflictAcceptPolicy;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNRevertCommand;
import org.tmatesoft.svn.cli.svn.SVNShowRevisionType;
import org.tmatesoft.svn.cli.svn.SVNStatusCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommandEnvironment
extends AbstractSVNCommandEnvironment
implements ISVNCommitHandler {
    private static final String DEFAULT_LOG_MESSAGE_HEADER = "--This line, and those below, will be ignored--";
    private SVNDepth myDepth;
    private SVNDepth mySetDepth;
    private boolean myIsVerbose;
    private boolean myIsUpdate;
    private boolean myIsQuiet;
    private boolean myIsIncremental;
    private boolean myIsHelp;
    private boolean myIsIgnoreExternals;
    private boolean myIsXML;
    private boolean myIsVersion;
    private String myChangelist;
    private boolean myIsNonInteractive;
    private boolean myIsNoAuthCache;
    private String myUserName;
    private String myPassword;
    private String myConfigDir;
    private boolean myIsDescend = true;
    private boolean myIsNoIgnore;
    private boolean myIsRevprop;
    private boolean myIsStrict;
    private SVNRevision myStartRevision;
    private SVNRevision myEndRevision;
    private boolean myIsForce;
    private String myFilePath;
    private byte[] myFileData;
    private List myTargets;
    private String myEncoding;
    private String myMessage;
    private boolean myIsForceLog;
    private String myEditorCommand;
    private String myDiffCommand;
    private SVNProperties myRevisionProperties;
    private boolean myIsNoUnlock;
    private boolean myIsDryRun;
    private boolean myIsRecordOnly;
    private boolean myIsUseMergeHistory;
    private Collection myExtensions;
    private boolean myIsIgnoreAncestry;
    private String myNativeEOL;
    private boolean myIsRelocate;
    private boolean myIsNoAutoProps;
    private boolean myIsAutoProps;
    private boolean myIsKeepChangelist;
    private boolean myIsParents;
    private boolean myIsKeepLocal;
    private SVNConflictAcceptPolicy myResolveAccept = SVNConflictAcceptPolicy.UNSPECIFIED;
    private boolean myIsRemove;
    private String myNewTarget;
    private String myOldTarget;
    private boolean myIsNoticeAncestry;
    private boolean myIsSummarize;
    private boolean myIsNoDiffDeleted;
    private long myLimit = -1L;
    private boolean myIsStopOnCopy;
    private boolean myIsChangeOptionUsed;
    private boolean myIsRevisionOptionUsed;
    private boolean myIsWithAllRevprops;
    private boolean myIsReIntegrate;
    private boolean myIsTrustServerCertificate;
    private List myRevisionRanges;
    private SVNShowRevisionType myShowRevsType;
    private Collection myChangelists;
    private String myAuthorOfInterest;
    private String myRegularExpression;
    private Map myConfigOptions;
    private Map myServersOptions;
    static /* synthetic */ Class class$org$tmatesoft$svn$cli$svn$SVNMergeCommand;
    static /* synthetic */ Class class$org$tmatesoft$svn$cli$svn$SVNLogCommand;

    public SVNCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
        this.myDepth = SVNDepth.UNKNOWN;
        this.mySetDepth = SVNDepth.UNKNOWN;
        this.myStartRevision = SVNRevision.UNDEFINED;
        this.myEndRevision = SVNRevision.UNDEFINED;
        this.myShowRevsType = SVNShowRevisionType.MERGED;
        this.myRevisionRanges = new LinkedList();
        this.myChangelists = new SVNHashSet();
    }

    public void initClientManager() throws SVNException {
        super.initClientManager();
        this.getClientManager().setIgnoreExternals(this.myIsIgnoreExternals);
    }

    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNOption.HELP || option == SVNOption.QUESTION) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (commandName == null) {
            if (this.isVersion()) {
                SVNCommand versionCommand = new SVNCommand("--version", null){

                    protected Collection createSupportedOptions() {
                        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
                        options.add(SVNOption.VERSION);
                        options.add(SVNOption.CONFIG_DIR);
                        options.add(SVNOption.QUIET);
                        return options;
                    }

                    public void run() throws SVNException {
                        AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                        helpCommand.init(SVNCommandEnvironment.this);
                        helpCommand.run();
                    }
                };
                AbstractSVNCommand.registerCommand(versionCommand);
                return "--version";
            }
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Subcommand argument required");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return commandName;
    }

    protected DefaultSVNOptions createClientOptions() throws SVNException {
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir) : SVNWCUtil.getDefaultConfigurationDirectory();
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((File)configDir, (boolean)true);
        options.setAuthStorageEnabled(!this.myIsNoAuthCache);
        if (this.myIsAutoProps) {
            options.setUseAutoProperties(true);
        }
        if (this.myIsNoAutoProps) {
            options.setUseAutoProperties(false);
        }
        if (this.myIsNoUnlock) {
            options.setKeepLocks(true);
        }
        if (this.myResolveAccept == SVNConflictAcceptPolicy.UNSPECIFIED && (!options.isInteractiveConflictResolution() || this.myIsNonInteractive) || this.myResolveAccept == SVNConflictAcceptPolicy.POSTPONE) {
            options.setConflictHandler(null);
        } else {
            if (this.myIsNonInteractive) {
                SVNErrorMessage err;
                if (this.myResolveAccept == SVNConflictAcceptPolicy.EDIT) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--accept={0} incompatible with --non-interactive", (Object)SVNConflictAcceptPolicy.EDIT);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                if (this.myResolveAccept == SVNConflictAcceptPolicy.LAUNCH) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--accept={0} incompatible with --non-interactive", (Object)SVNConflictAcceptPolicy.LAUNCH);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
            }
            options.setConflictHandler((ISVNConflictHandler)new SVNCommandLineConflictHandler(this.myResolveAccept, this));
        }
        options.setInMemoryConfigOptions(this.myConfigOptions);
        return options;
    }

    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        SVNConsoleAuthenticationProvider authStoreHandler;
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir) : SVNWCUtil.getDefaultConfigurationDirectory();
        DefaultSVNAuthenticationManager authManager = (DefaultSVNAuthenticationManager)SVNWCUtil.createDefaultAuthenticationManager((File)configDir, (String)this.myUserName, (String)this.myPassword, (!this.myIsNoAuthCache ? 1 : 0) != 0);
        if (!this.myIsNonInteractive) {
            SVNConsoleAuthenticationProvider consoleAuthProvider = new SVNConsoleAuthenticationProvider(this.myIsTrustServerCertificate);
            authManager.setAuthenticationProvider((ISVNAuthenticationProvider)consoleAuthProvider);
            authStoreHandler = consoleAuthProvider;
        } else {
            authStoreHandler = null;
        }
        ISVNAuthenticationStorageOptions authOpts = new ISVNAuthenticationStorageOptions(){

            public boolean isNonInteractive() throws SVNException {
                return SVNCommandEnvironment.this.myIsNonInteractive;
            }

            public ISVNAuthStoreHandler getAuthStoreHandler() throws SVNException {
                return authStoreHandler;
            }
        };
        authManager.setAuthenticationStorageOptions(authOpts);
        authManager.setInMemoryConfigOptions(this.myConfigOptions);
        authManager.setInMemoryServersOptions(this.myServersOptions);
        return authManager;
    }

    protected void initOptions(SVNCommandLine commandLine) throws SVNException {
        SVNErrorMessage err;
        SVNRevisionRange range;
        SVNErrorMessage err2;
        super.initOptions(commandLine);
        if (this.getCommand().getClass() != (class$org$tmatesoft$svn$cli$svn$SVNMergeCommand == null ? (class$org$tmatesoft$svn$cli$svn$SVNMergeCommand = SVNCommandEnvironment.class$("org.tmatesoft.svn.cli.svn.SVNMergeCommand")) : class$org$tmatesoft$svn$cli$svn$SVNMergeCommand) && this.getCommand().getClass() != (class$org$tmatesoft$svn$cli$svn$SVNLogCommand == null ? (class$org$tmatesoft$svn$cli$svn$SVNLogCommand = SVNCommandEnvironment.class$("org.tmatesoft.svn.cli.svn.SVNLogCommand")) : class$org$tmatesoft$svn$cli$svn$SVNLogCommand)) {
            if (this.myRevisionRanges.size() > 1) {
                err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Multiple revision argument encountered; can't specify -c twice, or both -c and -r");
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (!this.myRevisionRanges.isEmpty() && this.myIsReIntegrate) {
            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"-r and -c can't be used with --reintegrate");
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.myRevisionRanges.isEmpty()) {
            range = new SVNRevisionRange(SVNRevision.UNDEFINED, SVNRevision.UNDEFINED);
            this.myRevisionRanges.add(range);
        }
        range = (SVNRevisionRange)this.myRevisionRanges.get(0);
        this.myStartRevision = range.getStartRevision();
        this.myEndRevision = range.getEndRevision();
        if (this.myIsReIntegrate) {
            if (this.myIsIgnoreAncestry) {
                if (this.myIsRecordOnly) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--reintegrate cannot be used with --ignore-ancestry or --record-only");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                } else {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--reintegrate cannot be used with --ignore-ancestry");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
            } else if (this.myIsRecordOnly) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--reintegrate cannot be used with --record-only");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        }
        if (this.myIsTrustServerCertificate && !this.myIsNonInteractive) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"--trust-server-cert requires --non-interactive");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }

    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        AbstractSVNOption option = optionValue.getOption();
        if (option == SVNOption.LIMIT) {
            String limitStr = optionValue.getValue();
            try {
                long limit = Long.parseLong(limitStr);
                if (limit <= 0L) {
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.INCORRECT_PARAMS, (String)"Argument to --limit must be positive");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                this.myLimit = limit;
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Non-numeric limit argument given");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (option == SVNOption.MESSAGE) {
            this.myMessage = optionValue.getValue();
        } else if (option == SVNOption.CHANGE) {
            if (this.myOldTarget != null) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Can't specify -c with --old");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            String chValue = optionValue.getValue();
            StringTokenizer tokens = new StringTokenizer(chValue, ", \n\r\t");
            while (tokens.hasMoreTokens()) {
                SVNErrorMessage err;
                String token = tokens.nextToken();
                while (token.startsWith("r")) {
                    token = token.substring(1);
                }
                long change = 0L;
                try {
                    change = Long.parseLong(token);
                }
                catch (NumberFormatException nfe) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Non-numeric change argument ({0}) given to -c", (Object)token);
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                SVNRevisionRange range = null;
                if (change == 0L) {
                    err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"There is no change 0");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                } else if (change > 0L) {
                    range = new SVNRevisionRange(SVNRevision.create((long)(change - 1L)), SVNRevision.create((long)change));
                } else {
                    change = -change;
                    range = new SVNRevisionRange(SVNRevision.create((long)change), SVNRevision.create((long)(change - 1L)));
                }
                this.myRevisionRanges.add(range);
                this.myIsChangeOptionUsed = true;
            }
        } else if (option == SVNOption.REVISION) {
            String revStr = optionValue.getValue();
            SVNRevision[] revisions = this.parseRevision(revStr);
            if (revisions == null) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Syntax error in revision argument ''{0}''", (Object)revStr);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            SVNRevisionRange range = new SVNRevisionRange(revisions[0], revisions[1]);
            this.myRevisionRanges.add(range);
            this.myIsRevisionOptionUsed = true;
        } else if (option == SVNOption.VERBOSE) {
            this.myIsVerbose = true;
        } else if (option == SVNOption.UPDATE) {
            this.myIsUpdate = true;
        } else if (option == SVNOption.HELP || option == SVNOption.QUESTION) {
            this.myIsHelp = true;
        } else if (option == SVNOption.QUIET) {
            this.myIsQuiet = true;
        } else if (option == SVNOption.INCREMENTAL) {
            this.myIsIncremental = true;
        } else if (option == SVNOption.FILE) {
            String fileName;
            this.myFilePath = fileName = optionValue.getValue();
            this.myFileData = this.readFromFile(new File(fileName));
        } else if (option == SVNOption.TARGETS) {
            String fileName = optionValue.getValue();
            byte[] data = this.readFromFile(new File(fileName));
            try {
                String[] targets = new String(data, "UTF-8").split("[\n\r]");
                this.myTargets = new LinkedList();
                for (int i = 0; i < targets.length; ++i) {
                    if (targets[i].trim().length() <= 0) continue;
                    this.myTargets.add(targets[i].trim());
                }
            }
            catch (UnsupportedEncodingException e) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getMessage());
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (option == SVNOption.FORCE) {
            this.myIsForce = true;
        } else if (option == SVNOption.FORCE_LOG) {
            this.myIsForceLog = true;
        } else if (option == SVNOption.DRY_RUN) {
            this.myIsDryRun = true;
        } else if (option == SVNOption.REVPROP) {
            this.myIsRevprop = true;
        } else if (option == SVNOption.RECURSIVE) {
            this.myDepth = SVNDepth.fromRecurse((boolean)true);
        } else if (option == SVNOption.NON_RECURSIVE) {
            this.myIsDescend = false;
        } else if (option == SVNOption.DEPTH) {
            String depth = optionValue.getValue();
            if (SVNDepth.EMPTY.getName().equals(depth)) {
                this.myDepth = SVNDepth.EMPTY;
            } else if (SVNDepth.FILES.getName().equals(depth)) {
                this.myDepth = SVNDepth.FILES;
            } else if (SVNDepth.IMMEDIATES.getName().equals(depth)) {
                this.myDepth = SVNDepth.IMMEDIATES;
            } else if (SVNDepth.INFINITY.getName().equals(depth)) {
                this.myDepth = SVNDepth.INFINITY;
            } else {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid depth; try ''empty'', ''files'', ''immediates'', or ''infinity''", (Object)depth);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (option == SVNOption.SET_DEPTH) {
            String depth = optionValue.getValue();
            if (SVNDepth.EMPTY.getName().equals(depth)) {
                this.mySetDepth = SVNDepth.EMPTY;
            } else if (SVNDepth.FILES.getName().equals(depth)) {
                this.mySetDepth = SVNDepth.FILES;
            } else if (SVNDepth.IMMEDIATES.getName().equals(depth)) {
                this.mySetDepth = SVNDepth.IMMEDIATES;
            } else if (SVNDepth.INFINITY.getName().equals(depth)) {
                this.mySetDepth = SVNDepth.INFINITY;
            } else if (SVNDepth.EXCLUDE.getName().equals(depth)) {
                this.mySetDepth = SVNDepth.EXCLUDE;
            } else {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid depth; try ''exclude'', ''empty'', ''files'', ''immediates'', or ''infinity''", (Object)depth);
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (option == SVNOption.VERSION) {
            this.myIsVersion = true;
        } else if (option == SVNOption.USERNAME) {
            this.myUserName = optionValue.getValue();
        } else if (option == SVNOption.PASSWORD) {
            this.myPassword = optionValue.getValue();
        } else if (option == SVNOption.ENCODING) {
            this.myEncoding = optionValue.getValue();
        } else if (option == SVNOption.XML) {
            this.myIsXML = true;
        } else if (option == SVNOption.STOP_ON_COPY) {
            this.myIsStopOnCopy = true;
        } else if (option == SVNOption.STRICT) {
            this.myIsStrict = true;
        } else if (option == SVNOption.NO_AUTH_CACHE) {
            this.myIsNoAuthCache = true;
        } else if (option == SVNOption.NON_INTERACTIVE) {
            this.myIsNonInteractive = true;
        } else if (option == SVNOption.NO_DIFF_DELETED) {
            this.myIsNoDiffDeleted = true;
        } else if (option == SVNOption.NOTICE_ANCESTRY) {
            this.myIsNoticeAncestry = true;
        } else if (option == SVNOption.IGNORE_ANCESTRY) {
            this.myIsIgnoreAncestry = true;
        } else if (option == SVNOption.IGNORE_EXTERNALS) {
            this.myIsIgnoreExternals = true;
        } else if (option == SVNOption.RELOCATE) {
            if (this.myDepth != SVNDepth.UNKNOWN) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--depth and --relocate are mutually exclusive"), (SVNLogType)SVNLogType.CLIENT);
            }
            this.myIsRelocate = true;
        } else if (option == SVNOption.EXTENSIONS) {
            String extensionsString = optionValue.getValue();
            String[] extensions = extensionsString.trim().split("\\s+");
            if (this.myExtensions == null) {
                this.myExtensions = new SVNHashSet();
            }
            this.myExtensions.addAll(Arrays.asList(extensions));
        } else if (option == SVNOption.RECORD_ONLY) {
            this.myIsRecordOnly = true;
        } else if (option == SVNOption.DIFF_CMD) {
            this.myDiffCommand = optionValue.getValue();
        } else if (option == SVNOption.EDITOR_CMD) {
            this.myEditorCommand = optionValue.getValue();
        } else if (option == SVNOption.OLD) {
            if (this.myIsChangeOptionUsed) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Can't specify -c with --old"), (SVNLogType)SVNLogType.CLIENT);
            }
            this.myOldTarget = optionValue.getValue();
        } else if (option == SVNOption.NEW) {
            this.myNewTarget = optionValue.getValue();
        } else if (option == SVNOption.CONFIG_DIR) {
            this.myConfigDir = optionValue.getValue();
        } else if (option == SVNOption.CONFIG_OPTION) {
            if (this.myConfigOptions == null) {
                this.myConfigOptions = new HashMap();
            }
            if (this.myServersOptions == null) {
                this.myServersOptions = new HashMap();
            }
            SVNCommandUtil.parseConfigOption(optionValue.getValue(), this.myConfigOptions, this.myServersOptions);
        } else if (option == SVNOption.AUTOPROPS) {
            if (this.myIsNoAutoProps) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--auto-props and --no-auto-props are mutually exclusive"), (SVNLogType)SVNLogType.CLIENT);
            }
            this.myIsAutoProps = true;
        } else if (option == SVNOption.NO_AUTOPROPS) {
            if (this.myIsAutoProps) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, (String)"--auto-props and --no-auto-props are mutually exclusive"), (SVNLogType)SVNLogType.CLIENT);
            }
            this.myIsNoAutoProps = true;
        } else if (option == SVNOption.NATIVE_EOL) {
            this.myNativeEOL = optionValue.getValue();
        } else if (option == SVNOption.NO_UNLOCK) {
            this.myIsNoUnlock = true;
        } else if (option == SVNOption.SUMMARIZE) {
            this.myIsSummarize = true;
        } else if (option == SVNOption.REMOVE) {
            this.myIsRemove = true;
        } else if (option == SVNOption.CHANGELIST) {
            this.myChangelist = optionValue.getValue();
            if (this.myChangelist == null) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Changelist names must not be empty");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            this.myChangelists.add(this.myChangelist);
        } else if (option == SVNOption.KEEP_CHANGELISTS) {
            this.myIsKeepChangelist = true;
        } else if (option == SVNOption.KEEP_LOCAL) {
            this.myIsKeepLocal = true;
        } else if (option == SVNOption.NO_IGNORE) {
            this.myIsNoIgnore = true;
        } else if (option == SVNOption.WITH_ALL_REVPROPS) {
            this.myIsWithAllRevprops = true;
        } else if (option == SVNOption.WITH_REVPROP) {
            this.parseRevisionProperty(optionValue);
        } else if (option == SVNOption.PARENTS) {
            this.myIsParents = true;
        } else if (option == SVNOption.USE_MERGE_HISTORY) {
            this.myIsUseMergeHistory = true;
        } else if (option == SVNOption.ACCEPT) {
            SVNConflictAcceptPolicy accept = SVNConflictAcceptPolicy.fromString(optionValue.getValue());
            if (accept == SVNConflictAcceptPolicy.INVALID) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid --accept value;", (Object)optionValue.getValue());
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            this.myResolveAccept = accept;
        } else if (option == SVNOption.SHOW_REVS) {
            this.myShowRevsType = SVNShowRevisionType.fromString(optionValue.getValue());
            if (this.myShowRevsType == SVNShowRevisionType.INVALID) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"''{0}'' is not a valid --show-revs value", (Object)optionValue.getValue());
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (option == SVNOption.REINTEGRATE) {
            this.myIsReIntegrate = true;
        } else if (option == SVNOption.AUTHOR_OF_INTEREST) {
            this.myAuthorOfInterest = optionValue.getValue();
        } else if (option == SVNOption.REGULAR_EXPRESSION) {
            this.myRegularExpression = optionValue.getValue();
        } else if (option == SVNOption.TRUST_SERVER_CERT) {
            this.myIsTrustServerCertificate = true;
        }
    }

    protected SVNCommand getSVNCommand() {
        return (SVNCommand)this.getCommand();
    }

    protected void validateOptions(SVNCommandLine commandLine) throws SVNException {
        SVNErrorMessage err;
        super.validateOptions(commandLine);
        if (!this.isForceLog() && this.getSVNCommand().isCommitter()) {
            File file;
            if (this.myFilePath != null && this.isVersioned(this.myFilePath)) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_LOG_MESSAGE_IS_VERSIONED_FILE, (String)this.getSVNCommand().getFileAmbigousErrorMessage());
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if (this.myMessage != null && !"".equals(this.myMessage) && SVNFileType.getType((File)(file = new File(this.myMessage).getAbsoluteFile())) != SVNFileType.NONE) {
                SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_LOG_MESSAGE_IS_PATHNAME, (String)this.getSVNCommand().getMessageAmbigousErrorMessage());
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
        }
        if (!this.getSVNCommand().acceptsRevisionRange() && this.getEndRevision() != SVNRevision.UNDEFINED) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_REVISION_RANGE);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (!this.myIsDescend) {
            this.myDepth = this.getCommand() instanceof SVNStatusCommand ? SVNDepth.IMMEDIATES : (this.getCommand() instanceof SVNRevertCommand || this.getCommand() instanceof SVNAddCommand || this.getCommand() instanceof SVNCommitCommand ? SVNDepth.EMPTY : SVNDepth.FILES);
        }
    }

    protected String getCommandLineClientName() {
        return "svn";
    }

    public boolean isReIntegrate() {
        return this.myIsReIntegrate;
    }

    public SVNShowRevisionType getShowRevisionType() {
        return this.myShowRevsType;
    }

    public boolean isChangeOptionUsed() {
        return this.myIsChangeOptionUsed;
    }

    public boolean isRevisionOptionUsed() {
        return this.myIsRevisionOptionUsed;
    }

    public String getChangelist() {
        return this.myChangelist;
    }

    public String[] getChangelists() {
        if (this.myChangelists != null && !this.myChangelists.isEmpty()) {
            return this.myChangelists.toArray(new String[this.myChangelists.size()]);
        }
        return null;
    }

    public Collection getChangelistsCollection() {
        return this.myChangelists;
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    public SVNDepth getSetDepth() {
        return this.mySetDepth;
    }

    public boolean isVerbose() {
        return this.myIsVerbose;
    }

    public boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    public boolean isUpdate() {
        return this.myIsUpdate;
    }

    public boolean isQuiet() {
        return this.myIsQuiet;
    }

    public boolean isIncremental() {
        return this.myIsIncremental;
    }

    public boolean isRevprop() {
        return this.myIsRevprop;
    }

    public boolean isStrict() {
        return this.myIsStrict;
    }

    public List getRevisionRanges() {
        return this.myRevisionRanges;
    }

    public SVNRevision getStartRevision() {
        return this.myStartRevision;
    }

    public SVNRevision getEndRevision() {
        return this.myEndRevision;
    }

    public boolean isXML() {
        return this.myIsXML;
    }

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public boolean isForce() {
        return this.myIsForce;
    }

    public String getEncoding() {
        return this.myEncoding;
    }

    public byte[] getFileData() {
        return this.myFileData;
    }

    public List getTargets() {
        return this.myTargets;
    }

    public boolean isForceLog() {
        return this.myIsForceLog;
    }

    public String getEditorCommand() {
        return this.myEditorCommand;
    }

    public String getDiffCommand() {
        return this.myDiffCommand;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public SVNProperties getRevisionProperties() {
        return this.myRevisionProperties;
    }

    public boolean isDryRun() {
        return this.myIsDryRun;
    }

    public boolean isIgnoreAncestry() {
        return this.myIsIgnoreAncestry;
    }

    public boolean isUseMergeHistory() {
        return this.myIsUseMergeHistory;
    }

    public boolean isRecordOnly() {
        return this.myIsRecordOnly;
    }

    public Collection getExtensions() {
        return this.myExtensions;
    }

    public String getNativeEOL() {
        return this.myNativeEOL;
    }

    public boolean isRelocate() {
        return this.myIsRelocate;
    }

    public boolean isNoUnlock() {
        return this.myIsNoUnlock;
    }

    public boolean isKeepChangelist() {
        return this.myIsKeepChangelist;
    }

    public boolean isParents() {
        return this.myIsParents;
    }

    public boolean isKeepLocal() {
        return this.myIsKeepLocal;
    }

    public SVNConflictAcceptPolicy getResolveAccept() {
        return this.myResolveAccept;
    }

    public boolean isRemove() {
        return this.myIsRemove;
    }

    public boolean isSummarize() {
        return this.myIsSummarize;
    }

    public boolean isNoticeAncestry() {
        return this.myIsNoticeAncestry;
    }

    public boolean isNoDiffDeleted() {
        return this.myIsNoDiffDeleted;
    }

    public String getOldTarget() {
        return this.myOldTarget;
    }

    public String getNewTarget() {
        return this.myNewTarget;
    }

    public String getAuthorOfInterest() {
        return this.myAuthorOfInterest;
    }

    public String getRegularExpression() {
        return this.myRegularExpression;
    }

    public long getLimit() {
        return this.myLimit;
    }

    public boolean isStopOnCopy() {
        return this.myIsStopOnCopy;
    }

    public boolean isAllRevisionProperties() {
        return this.myIsWithAllRevprops;
    }

    public SVNDiffOptions getDiffOptions() throws SVNException {
        boolean ignoreEOLStyle;
        boolean ignoreAmountOfWS;
        boolean ignoreAllWS;
        if (this.myExtensions == null) {
            return null;
        }
        LinkedList extensions = new LinkedList(this.myExtensions);
        boolean bl = ignoreAllWS = this.myExtensions.contains("-w") || this.myExtensions.contains("--ignore-all-space");
        if (ignoreAllWS) {
            extensions.remove("-w");
            extensions.remove("--ignore-all-space");
        }
        boolean bl2 = ignoreAmountOfWS = this.myExtensions.contains("-b") || this.myExtensions.contains("--ignore-space-change");
        if (ignoreAmountOfWS) {
            extensions.remove("-b");
            extensions.remove("--ignore-space-change");
        }
        if (ignoreEOLStyle = this.myExtensions.contains("--ignore-eol-style")) {
            extensions.remove("--ignore-eol-style");
        }
        if (!extensions.isEmpty()) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.INVALID_DIFF_OPTION, (String)"Invalid argument ''{0}'' in diff options", extensions.get(0));
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        return new SVNDiffOptions(ignoreAllWS, ignoreAmountOfWS, ignoreEOLStyle);
    }

    public SVNProperties getRevisionProperties(String message, SVNCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
        return revisionProperties == null ? new SVNProperties() : revisionProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommitMessage(String message, SVNCommitItem[] commitables) throws SVNException {
        if (this.getFileData() != null) {
            byte[] data = this.getFileData();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 0) continue;
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_BAD_LOG_MESSAGE, (String)"Log message contains a zero byte"), (SVNLogType)SVNLogType.CLIENT);
            }
            String charset = this.getEncoding();
            if (charset == null) {
                charset = this.getOptions().getLogEncoding();
            }
            if (charset == null) {
                charset = this.getOptions().getNativeCharset();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream os = SVNTranslator.getTranslatingOutputStream((OutputStream)bos, (String)charset, (byte[])new byte[]{10}, (boolean)false, null, (boolean)false);
            try {
                os.write(this.getFileData());
                os.close();
                os = null;
                String string = new String(bos.toByteArray(), "UTF-8");
                return string;
            }
            catch (UnsupportedEncodingException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getMessage()), (SVNLogType)SVNLogType.CLIENT);
            }
            catch (IOException e) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)"Error normalizing log message to internal format"), (SVNLogType)SVNLogType.CLIENT);
            }
            finally {
                SVNFileUtil.closeFile((OutputStream)os);
            }
        } else if (this.getMessage() != null) {
            return this.getMessage();
        }
        if (commitables == null || commitables.length == 0) {
            return "";
        }
        if (this.myIsNonInteractive) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Cannot invoke editor to get log message when non-interactive");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        message = null;
        while (message == null) {
            message = this.createCommitMessageTemplate(commitables);
            byte[] messageData = null;
            try {
                try {
                    messageData = message.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    messageData = message.getBytes();
                }
                messageData = SVNCommandUtil.runEditor(this, this.getEditorCommand(), messageData, "svn-commit");
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_EDITOR) {
                    SVNErrorMessage err = e.getErrorMessage().wrap("Could not use external editor to fetch log message; consider setting the $SVN_EDITOR environment variable or using the --message (-m) or --file (-F) options");
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                throw e;
            }
            if (messageData != null) {
                String editedMessage = null;
                try {
                    editedMessage = this.getEncoding() != null ? new String(messageData, this.getEncoding()) : new String(messageData);
                }
                catch (UnsupportedEncodingException e) {
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getMessage());
                    SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
                }
                if (editedMessage.indexOf(DEFAULT_LOG_MESSAGE_HEADER) >= 0) {
                    editedMessage = editedMessage.substring(0, editedMessage.indexOf(DEFAULT_LOG_MESSAGE_HEADER));
                }
                if (!"a".equals(editedMessage.trim())) {
                    return editedMessage;
                }
            }
            message = null;
            this.getOut().println("\nLog message unchanged or not specified\na)bort, c)ontinue, e)dit");
            try {
                char c = (char)this.getIn().read();
                if (c == 'a') {
                    SVNErrorManager.cancel((String)"", (SVNLogType)SVNLogType.CLIENT);
                    continue;
                }
                if (c == 'c') {
                    return "";
                }
                if (c != 'e') continue;
            }
            catch (IOException e) {}
        }
        SVNErrorManager.cancel((String)"", (SVNLogType)SVNLogType.CLIENT);
        return null;
    }

    private void parseRevisionProperty(SVNOptionValue optionValue) throws SVNException {
        String revProp;
        if (this.myRevisionProperties == null) {
            this.myRevisionProperties = new SVNProperties();
        }
        if ((revProp = optionValue.getValue()) == null || "".equals(revProp)) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Revision property pair is empty");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        int index = revProp.indexOf(61);
        String revPropName = null;
        String revPropValue = null;
        if (index >= 0) {
            revPropName = revProp.substring(0, index);
            revPropValue = revProp.substring(index + 1);
        } else {
            revPropName = revProp;
            revPropValue = "";
        }
        if (!SVNPropertiesManager.isValidPropertyName((String)revPropName)) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_PROPERTY_NAME, (String)"''{0}'' is not a valid Subversion property name", (Object)revPropName);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        this.myRevisionProperties.put(revPropName, revPropValue);
    }

    private String createCommitMessageTemplate(SVNCommitItem[] items) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(System.getProperty("line.separator"));
        buffer.append(DEFAULT_LOG_MESSAGE_HEADER);
        buffer.append(System.getProperty("line.separator"));
        buffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < items.length; ++i) {
            String path;
            SVNCommitItem item = items[i];
            String string = path = item.getPath() != null ? item.getPath() : item.getURL().toString();
            if ("".equals(path) || path == null) {
                path = ".";
            }
            if (item.isDeleted() && item.isAdded()) {
                buffer.append('R');
            } else if (item.isDeleted()) {
                buffer.append('D');
            } else if (item.isAdded()) {
                buffer.append('A');
            } else if (item.isContentsModified()) {
                buffer.append('M');
            } else {
                buffer.append('_');
            }
            if (item.isPropertiesModified()) {
                buffer.append('M');
            } else {
                buffer.append(' ');
            }
            if (!this.myIsNoUnlock && item.isLocked()) {
                buffer.append('L');
            } else {
                buffer.append(' ');
            }
            if (item.isCopied()) {
                buffer.append("+ ");
            } else {
                buffer.append("  ");
            }
            buffer.append(path);
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

