/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.DirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedNIPaths<V, E>
extends AbstractRanker<V, E> {
    public static final String WEIGHTED_NIPATHS_KEY = "jung.algorithms.importance.WEIGHTED_NIPATHS_KEY";
    private double mAlpha;
    private int mMaxDepth;
    private Set<V> mPriors;
    private Map<E, Number> pathIndices = new HashMap<E, Number>();
    private Map<Object, V> roots = new HashMap<Object, V>();
    private Map<V, Set<Number>> pathsSeenMap = new HashMap<V, Set<Number>>();
    private Factory<V> vertexFactory;
    private Factory<E> edgeFactory;

    public WeightedNIPaths(DirectedGraph<V, E> graph, Factory<V> vertexFactory, Factory<E> edgeFactory, double alpha, int maxDepth, Set<V> priors) {
        super.initialize(graph, true, false);
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.mAlpha = alpha;
        this.mMaxDepth = maxDepth;
        this.mPriors = priors;
        for (Object v : graph.getVertices()) {
            super.setVertexRankScore(v, 0.0);
        }
    }

    protected void incrementRankScore(V v, double rankValue) {
        this.setVertexRankScore(v, this.getVertexRankScore(v) + rankValue);
    }

    protected void computeWeightedPathsFromSource(V root, int depth) {
        int pathIdx = 1;
        for (Object e : this.getGraph().getOutEdges(root)) {
            this.pathIndices.put(e, pathIdx);
            this.roots.put(e, root);
            this.newVertexEncountered(pathIdx, this.getGraph().getEndpoints(e).getSecond(), root);
            ++pathIdx;
        }
        ArrayList<Object> edges = new ArrayList<Object>();
        Object virtualNode = this.vertexFactory.create();
        this.getGraph().addVertex(virtualNode);
        Object virtualSinkEdge = this.edgeFactory.create();
        this.getGraph().addEdge(virtualSinkEdge, virtualNode, root);
        edges.add(virtualSinkEdge);
        for (int currentDepth = 0; currentDepth <= depth; ++currentDepth) {
            double currentWeight = Math.pow(this.mAlpha, -1.0 * (double)currentDepth);
            for (Object e : edges) {
                this.incrementRankScore(this.getGraph().getEndpoints(e).getSecond(), currentWeight);
            }
            if (currentDepth == depth || edges.size() == 0) break;
            ArrayList newEdges = new ArrayList();
            for (Object e : edges) {
                Number sourcePathIndex = this.pathIndices.get(e);
                Object newDestVertex = this.getGraph().getEndpoints(e).getSecond();
                Collection outs = this.getGraph().getOutEdges(newDestVertex);
                for (Object currentDestEdge : outs) {
                    V destEdgeRoot = this.roots.get(currentDestEdge);
                    Object destEdgeDest = this.getGraph().getEndpoints(currentDestEdge).getSecond();
                    if (e == virtualSinkEdge) {
                        newEdges.add(currentDestEdge);
                        continue;
                    }
                    if (destEdgeRoot == root || destEdgeDest == this.getGraph().getEndpoints(e).getFirst()) continue;
                    Set<Number> pathsSeen = this.pathsSeenMap.get(destEdgeDest);
                    if (pathsSeen == null) {
                        this.newVertexEncountered(sourcePathIndex.intValue(), destEdgeDest, root);
                    } else if (this.roots.get(destEdgeDest) != root) {
                        this.roots.put(destEdgeDest, root);
                        pathsSeen.clear();
                        pathsSeen.add(sourcePathIndex);
                    } else {
                        if (pathsSeen.contains(sourcePathIndex)) continue;
                        pathsSeen.add(sourcePathIndex);
                    }
                    this.pathIndices.put(currentDestEdge, sourcePathIndex);
                    this.roots.put(currentDestEdge, root);
                    newEdges.add(currentDestEdge);
                }
            }
            edges = newEdges;
        }
        this.getGraph().removeVertex(virtualNode);
    }

    private void newVertexEncountered(int sourcePathIndex, V dest, V root) {
        HashSet<Integer> pathsSeen = new HashSet<Integer>();
        pathsSeen.add(sourcePathIndex);
        this.pathsSeenMap.put(dest, (Set<Number>)pathsSeen);
        this.roots.put(dest, root);
    }

    @Override
    public void step() {
        for (V v : this.mPriors) {
            this.computeWeightedPathsFromSource(v, this.mMaxDepth);
        }
        this.normalizeRankings();
    }

    @Override
    public String getRankScoreKey() {
        return WEIGHTED_NIPATHS_KEY;
    }

    @Override
    protected void onFinalize(Object udc) {
        this.pathIndices.remove(udc);
        this.roots.remove(udc);
        this.pathsSeenMap.remove(udc);
    }
}

