/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldingTransformer<V, E> {
    public static <V, E> Graph<V, E> foldKPartiteGraph(KPartiteGraph<V, E> g, Predicate<V> p, Factory<Graph<V, E>> graph_factory, Factory<E> edge_factory) {
        Graph newGraph = (Graph)graph_factory.create();
        Collection vertices = g.getVertices(p);
        for (Object v : vertices) {
            newGraph.addVertex(v);
            for (Object s : g.getSuccessors(v)) {
                for (Object t : g.getSuccessors(s)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    newGraph.addEdge(edge_factory.create(), v, t);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> Graph<V, Collection<V>> foldKPartiteGraph(KPartiteGraph<V, E> g, Predicate<V> p, Factory<Graph<V, Collection<V>>> graph_factory) {
        Graph newGraph = (Graph)graph_factory.create();
        Collection vertices = g.getVertices(p);
        for (Object v : vertices) {
            newGraph.addVertex(v);
            for (Object s : g.getSuccessors(v)) {
                for (Object t : g.getSuccessors(s)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    ArrayList v_coll = (ArrayList)newGraph.findEdge(v, t);
                    if (v_coll == null) {
                        v_coll = new ArrayList();
                        newGraph.addEdge(v_coll, v, t);
                    }
                    v_coll.add(s);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> Graph<V, Collection<E>> foldHypergraphEdges(Hypergraph<V, E> h, Factory<Graph<V, Collection<E>>> graph_factory) {
        Graph target = (Graph)graph_factory.create();
        for (Object v : h.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h.getEdges()) {
            ArrayList incident = new ArrayList(h.getIncidentVertices(e));
            FoldingTransformer.populateTarget(target, e, incident);
        }
        return target;
    }

    public static <V, E> Graph<V, E> foldHypergraphEdges(Hypergraph<V, E> h, Factory<Graph<V, E>> graph_factory, Factory<E> edge_factory) {
        Graph target = (Graph)graph_factory.create();
        for (Object v : h.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h.getEdges()) {
            ArrayList incident = new ArrayList(h.getIncidentVertices(e));
            for (int i = 0; i < incident.size(); ++i) {
                for (int j = i + 1; j < incident.size(); ++j) {
                    target.addEdge(edge_factory.create(), incident.get(i), incident.get(j));
                }
            }
        }
        return target;
    }

    public static <V, E, F> Graph<E, F> foldHypergraphVertices(Hypergraph<V, E> h, Factory<Graph<E, F>> graph_factory, Factory<F> edge_factory) {
        Graph target = (Graph)graph_factory.create();
        for (Object e : h.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h.getVertices()) {
            ArrayList incident = new ArrayList(h.getIncidentEdges(v));
            for (int i = 0; i < incident.size(); ++i) {
                for (int j = i + 1; j < incident.size(); ++j) {
                    target.addEdge(edge_factory.create(), incident.get(i), incident.get(j));
                }
            }
        }
        return target;
    }

    public Graph<E, Collection<V>> foldHypergraphVertices(Hypergraph<V, E> h, Factory<Graph<E, Collection<V>>> graph_factory) {
        Graph target = (Graph)graph_factory.create();
        for (Object e : h.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h.getVertices()) {
            ArrayList incident = new ArrayList(h.getIncidentEdges(v));
            FoldingTransformer.populateTarget(target, v, incident);
        }
        return target;
    }

    private static <S, T> void populateTarget(Graph<S, Collection<T>> target, T e, ArrayList<S> incident) {
        for (int i = 0; i < incident.size(); ++i) {
            S v1 = incident.get(i);
            for (int j = i + 1; j < incident.size(); ++j) {
                S v2 = incident.get(j);
                ArrayList<T> e_coll = (ArrayList<T>)target.findEdge(v1, v2);
                if (e_coll == null) {
                    e_coll = new ArrayList<T>();
                    target.addEdge(e_coll, v1, v2);
                }
                e_coll.add(e);
            }
        }
    }
}

