/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.apache.felix.shell.Command;
import org.apache.felix.shell.impl.LogOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;

public class LogCommandImpl
implements Command {
    private final BundleContext m_bundleContext;
    static /* synthetic */ Class class$org$osgi$service$log$LogReaderService;

    public LogCommandImpl(BundleContext context) {
        this.m_bundleContext = context;
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        LogOptions options = new LogOptions(line);
        ServiceReference ref = this.m_bundleContext.getServiceReference((class$org$osgi$service$log$LogReaderService == null ? (class$org$osgi$service$log$LogReaderService = LogCommandImpl.class$("org.osgi.service.log.LogReaderService")) : class$org$osgi$service$log$LogReaderService).getName());
        if (ref != null) {
            LogReaderService service = (LogReaderService)this.m_bundleContext.getService(ref);
            Enumeration entries = service.getLog();
            int index = 0;
            while (entries.hasMoreElements() && options.getMaxNumberOfLogs() < 0 | index < options.getMaxNumberOfLogs()) {
                LogEntry entry = (LogEntry)entries.nextElement();
                if (entry.getLevel() > options.getMinLevel()) continue;
                this.display(entry, out);
                ++index;
            }
        } else {
            out.println("No LogReaderService available");
        }
    }

    private void display(LogEntry entry, PrintStream out) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        StringBuffer buffer = new StringBuffer();
        buffer.append(sdf.format(new Date(entry.getTime()))).append(" ");
        buffer.append(this.levelAsAString(entry.getLevel())).append(" - ");
        buffer.append("Bundle:").append(entry.getBundle().getSymbolicName()).append(" ");
        if (entry.getServiceReference() != null) {
            buffer.append(entry.getServiceReference().toString()).append(" ");
        }
        buffer.append("- ").append(entry.getMessage()).append(" - ");
        if (entry.getException() != null) {
            buffer.append(entry.getException().getClass().getName()).append(": ").append(entry.getException().getMessage());
        }
        out.println(buffer.toString());
    }

    private String levelAsAString(int level) {
        switch (level) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "INFO";
            }
        }
        return "DEBUG";
    }

    public String getName() {
        return "log";
    }

    public String getShortDescription() {
        return "list the most recent log entries.";
    }

    public String getUsage() {
        return "log [<max log entries>] [error | warn | info | debug]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

