/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.checkout;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.bazaar.BazaarUtils;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;
import org.apache.maven.scm.provider.bazaar.command.checkout.BazaarCheckOutConsumer;
import org.apache.maven.scm.provider.bazaar.repository.BazaarScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class BazaarCheckOutCommand
extends AbstractCheckOutCommand
implements Command {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            throw new ScmException("This provider can't handle tags.");
        }
        BazaarScmProviderRepository repository = (BazaarScmProviderRepository)repo;
        String url = repository.getURI();
        File checkoutDir = fileSet.getBasedir();
        try {
            this.getLogger().info("Removing " + checkoutDir);
            FileUtils.deleteDirectory((File)checkoutDir);
        }
        catch (IOException e) {
            throw new ScmException("Cannot remove " + checkoutDir);
        }
        String[] checkoutCmd = new String[]{"branch", url, checkoutDir.getAbsolutePath()};
        BazaarConsumer checkoutConsumer = new BazaarConsumer(this.getLogger());
        BazaarUtils.execute(checkoutConsumer, this.getLogger(), checkoutDir.getParentFile(), checkoutCmd);
        String[] inventoryCmd = new String[]{"inventory"};
        BazaarCheckOutConsumer consumer = new BazaarCheckOutConsumer(this.getLogger(), checkoutDir);
        ScmResult result = BazaarUtils.execute(consumer, this.getLogger(), checkoutDir, inventoryCmd);
        return new CheckOutScmResult(consumer.getCheckedOutFiles(), result);
    }
}

