/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredGraph {
    private DirectedGraph originalGraph;
    private List<List<DirectedGraph.Vertex>> layers;

    protected LayeredGraph(DirectedGraph directedGraph) {
        this.originalGraph = directedGraph;
        this.layers = new ArrayList<List<DirectedGraph.Vertex>>();
    }

    public static LayeredGraph createGraph(DirectedGraph directedGraph) {
        LayeredGraph layeredGraph = new LayeredGraph(directedGraph);
        layeredGraph.createGraph();
        return layeredGraph;
    }

    protected void createGraph() {
        Collection<DirectedGraph.Vertex> collection = this.originalGraph.getRootVertices();
        for (DirectedGraph.Vertex vertex : collection) {
            this.assignLayers(vertex, 0);
        }
    }

    public DirectedGraph getOriginalGraph() {
        return this.originalGraph;
    }

    private void assignLayers(DirectedGraph.Vertex vertex, int n) {
        this.assignLayer(vertex, n);
        Collection<DirectedGraph.Vertex> collection = vertex.getLowerNeighbors();
        for (DirectedGraph.Vertex vertex2 : collection) {
            int n2 = vertex2.getNumber();
            if (n2 > n) continue;
            this.assignLayers(vertex2, n + 1);
        }
    }

    public void assignLayer(DirectedGraph.Vertex vertex, int n) {
        List<DirectedGraph.Vertex> list;
        int n2 = vertex.getNumber();
        if (n2 != -1) {
            list = this.getLayer(n2);
            list.remove(vertex);
        }
        list = this.getLayer(n);
        list.add(vertex);
        vertex.setNumber(n);
        vertex.setY(n);
        vertex.setX(list.size());
    }

    public List<List<DirectedGraph.Vertex>> getLayers() {
        return this.layers;
    }

    public List<DirectedGraph.Vertex> getLayer(int n) {
        int n2 = this.layers.size();
        if (n >= n2) {
            for (int i = n2; i <= n; ++i) {
                this.layers.add(new ArrayList());
            }
        }
        return this.layers.get(n);
    }

    public boolean[][] computeAdjacencyMatrix(int n) {
        List<DirectedGraph.Vertex> list = this.layers.get(n);
        List<DirectedGraph.Vertex> list2 = this.layers.get(n + 1);
        int n2 = list.size();
        int n3 = list2.size();
        boolean[][] blArray = new boolean[n2][n3];
        for (int i = 0; i < n2; ++i) {
            DirectedGraph.Vertex vertex = list.get(i);
            if (vertex == null) continue;
            Collection<DirectedGraph.Vertex> collection = vertex.getLowerNeighbors();
            for (DirectedGraph.Vertex vertex2 : collection) {
                int n4 = list2.indexOf(vertex2);
                if (n4 <= -1) continue;
                blArray[i][n4] = true;
            }
        }
        return blArray;
    }

    public float[] computeLowerBarycenters(int n) {
        boolean[][] blArray = this.computeAdjacencyMatrix(n);
        List<DirectedGraph.Vertex> list = this.layers.get(n);
        List<DirectedGraph.Vertex> list2 = this.layers.get(n + 1);
        int n2 = list.size();
        int n3 = list2.size();
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int j = 0; j < n2; ++j) {
                if (!blArray[j][i]) continue;
                DirectedGraph.Vertex vertex = list.get(j);
                f += (float)vertex.getX();
                f2 += 1.0f;
            }
            DirectedGraph.Vertex vertex = list2.get(i);
            fArray[i] = f / f2;
        }
        return fArray;
    }

    public float[] computeUpperBarycenters(int n) {
        boolean[][] blArray = this.computeAdjacencyMatrix(n);
        List<DirectedGraph.Vertex> list = this.layers.get(n);
        List<DirectedGraph.Vertex> list2 = this.layers.get(n + 1);
        int n2 = list.size();
        int n3 = list2.size();
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                if (!blArray[i][j]) continue;
                DirectedGraph.Vertex vertex = list2.get(j);
                f += (float)vertex.getX();
                f2 += 1.0f;
            }
            DirectedGraph.Vertex vertex = list.get(i);
            fArray[i] = f / f2;
        }
        return fArray;
    }
}

