/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualGraph {
    private EmbeddedPlanarGraph originalGraph;
    private Map<Face, FaceVertex> vertexMap;
    private Collection<FaceVertex> vertices;
    private Map<MGraph.Edge, FaceEdge> edgeMap;
    private Collection<FaceEdge> edges;
    private Collection<MGraph.Edge> edgesToIgnore;
    private Collection<Face> facesToIgnore;

    public static DualGraph createGraph(EmbeddedPlanarGraph embeddedPlanarGraph, Collection<Face> collection, Collection<MGraph.Edge> collection2) {
        DualGraph dualGraph = new DualGraph(embeddedPlanarGraph, collection, collection2);
        dualGraph.createGraph();
        return dualGraph;
    }

    private DualGraph(EmbeddedPlanarGraph embeddedPlanarGraph, Collection<Face> collection, Collection<MGraph.Edge> collection2) {
        this.originalGraph = embeddedPlanarGraph;
        this.facesToIgnore = collection;
        this.edgesToIgnore = collection2;
        this.vertexMap = new HashMap<Face, FaceVertex>();
        this.vertices = new ArrayList<FaceVertex>();
        this.edgeMap = new HashMap<MGraph.Edge, FaceEdge>();
        this.edges = new ArrayList<FaceEdge>();
    }

    private void createGraph() {
        this.createFaces();
        this.createEdges();
    }

    private void createFaces() {
        for (Face face : this.originalGraph.getFaces()) {
            if (this.facesToIgnore.contains(face) && !face.isOuterFace()) continue;
            this.getVertex(face);
        }
    }

    private void createEdges() {
        for (FaceVertex faceVertex : this.getVertices()) {
            for (FaceVertex faceVertex2 : this.getVertices()) {
                if (faceVertex == faceVertex2) continue;
                for (MGraph.Edge edge : faceVertex.getFace().getEdges()) {
                    if (this.edgesToIgnore.contains(edge) || !faceVertex2.getFace().containsEdge(edge)) continue;
                    FaceEdge faceEdge = this.getEdge(faceVertex, faceVertex2, edge);
                    faceVertex.addEdge(faceEdge);
                }
            }
        }
    }

    public void updateFaces() {
        int n;
        int n2 = this.originalGraph.getFaces().size();
        if (n2 > (n = this.vertices.size())) {
            this.createFaces();
        } else if (n2 < n) {
            this.vertices.clear();
            this.vertexMap.clear();
            this.createFaces();
        }
    }

    public void updateEdges() {
        this.edges.clear();
        this.edgeMap.clear();
        for (FaceVertex faceVertex : this.getVertices()) {
            faceVertex.getEdges().clear();
        }
        this.createEdges();
    }

    public EmbeddedPlanarGraph getOriginalGraph() {
        return this.originalGraph;
    }

    public Collection<FaceVertex> getVertices() {
        return this.vertices;
    }

    public Collection<FaceEdge> getEdges() {
        return this.edges;
    }

    private FaceVertex getVertex(Face face) {
        FaceVertex faceVertex = this.vertexMap.get(face);
        if (faceVertex == null) {
            faceVertex = new FaceVertex(face);
            this.vertexMap.put(face, faceVertex);
            this.vertices.add(faceVertex);
        }
        return faceVertex;
    }

    private FaceEdge getEdge(FaceVertex faceVertex, FaceVertex faceVertex2, MGraph.Edge edge) {
        FaceEdge faceEdge = this.edgeMap.get(edge);
        if (faceEdge == null) {
            faceEdge = new FaceEdge(faceVertex, faceVertex2, edge);
            this.edgeMap.put(edge, faceEdge);
            this.edges.add(faceEdge);
        }
        return faceEdge;
    }

    public Collection<FaceVertex> getVerticesBorderingEdge(MGraph.Edge edge) {
        ArrayList<FaceVertex> arrayList = new ArrayList<FaceVertex>();
        for (FaceVertex faceVertex : this.getVertices()) {
            if (!faceVertex.getFace().containsEdge(edge)) continue;
            arrayList.add(faceVertex);
        }
        return arrayList;
    }

    public String toString() {
        String string = "DualGraph:\n";
        string = string + "vertices:\n";
        for (FaceVertex object : this.vertices) {
            string = string + "\t" + object + "\n";
        }
        string = string + "edges\n";
        for (FaceEdge faceEdge : this.edges) {
            string = string + "\t" + faceEdge + "\n";
        }
        return string;
    }

    public class FaceEdge {
        private FaceVertex f;
        private FaceVertex g;
        private MGraph.Edge edge;

        public FaceEdge(FaceVertex faceVertex, FaceVertex faceVertex2, MGraph.Edge edge) {
            this.f = faceVertex;
            this.g = faceVertex2;
            this.edge = edge;
        }

        public FaceVertex getF() {
            return this.f;
        }

        public FaceVertex getG() {
            return this.g;
        }

        public MGraph.Edge getEdge() {
            return this.edge;
        }

        public boolean contains(FaceVertex faceVertex) {
            return this.f == faceVertex || this.g == faceVertex;
        }

        public FaceVertex getOppositeVertex(FaceVertex faceVertex) {
            if (faceVertex == this.f) {
                return this.g;
            }
            if (faceVertex == this.g) {
                return this.f;
            }
            return null;
        }

        public FaceVertex getVertex(MGraph.Vertex vertex) {
            if (this.f.face.containsVertex(vertex)) {
                return this.f;
            }
            if (this.g.face.containsVertex(vertex)) {
                return this.g;
            }
            return null;
        }

        public String toString() {
            String string = "FaceEdge:\n";
            string = string + "\t" + this.f + "\n";
            string = string + "\t" + this.g + "\n";
            string = string + "\t" + this.edge + "\n";
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FaceVertex {
        private Face face;
        private Collection<FaceEdge> edges;

        public FaceVertex(Face face) {
            this.face = face;
            this.edges = new LinkedHashSet<FaceEdge>();
        }

        public Face getFace() {
            return this.face;
        }

        public Collection<FaceEdge> getEdges() {
            return this.edges;
        }

        public void addEdge(FaceEdge faceEdge) {
            if (!this.edges.contains(faceEdge)) {
                this.edges.add(faceEdge);
            }
        }

        public String toString() {
            return "FaceVertex: " + this.face.toString();
        }
    }
}

