/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaIndexerPlugin;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.indexing.CheckSums;
import org.netbeans.modules.java.source.indexing.FQN2Files;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class JavaParsingContext {
    final ClasspathInfo cpInfo;
    final String sourceLevel;
    final JavaFileFilterImplementation filter;
    final Charset encoding;
    final ClassIndexImpl uq;
    final CheckSums checkSums;
    final FQN2Files fqn2Files;
    final SourceAnalyser sa;
    private final Iterable<? extends JavaIndexerPlugin> pluginsCache;

    public JavaParsingContext(Context context) throws IOException, NoSuchAlgorithmException {
        this(context, false);
    }

    JavaParsingContext(Context context, boolean allowNonExistentRoot) throws IOException, NoSuchAlgorithmException {
        FileObject root = context.getRoot();
        URL rootURL = context.getRootURI();
        boolean rootNotNeeded = allowNonExistentRoot && root == null;
        this.cpInfo = rootNotNeeded ? null : ClasspathInfo.create(root);
        this.sourceLevel = rootNotNeeded ? null : SourceLevelQuery.getSourceLevel((FileObject)root);
        this.filter = rootNotNeeded ? null : JavaFileFilterQuery.getFilter(root);
        this.encoding = rootNotNeeded ? null : FileEncodingQuery.getEncoding((FileObject)root);
        this.uq = ClassIndexManager.getDefault().createUsagesQuery(rootURL, true);
        this.sa = this.uq != null ? this.uq.getSourceAnalyser() : null;
        this.checkSums = CheckSums.forContext(context);
        this.fqn2Files = FQN2Files.forRoot(rootURL);
        this.pluginsCache = JavaParsingContext.createPlugins(rootURL, context.getIndexFolder());
    }

    public JavaParsingContext(Context context, ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, Collection<? extends JavaCustomIndexer.CompileTuple> virtualSources) throws IOException, NoSuchAlgorithmException {
        FileObject root = context.getRoot();
        URL rootURL = context.getRootURI();
        this.filter = JavaFileFilterQuery.getFilter(root);
        this.cpInfo = ClasspathInfoAccessor.getINSTANCE().create(bootPath, compilePath, sourcePath, this.filter, true, context.isSourceForBinaryRootIndexing(), !virtualSources.isEmpty(), context.checkForEditorModifications());
        JavaParsingContext.registerVirtualSources(this.cpInfo, virtualSources);
        this.sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)root);
        this.encoding = FileEncodingQuery.getEncoding((FileObject)root);
        this.uq = ClassIndexManager.getDefault().createUsagesQuery(rootURL, true);
        this.sa = this.uq != null ? this.uq.getSourceAnalyser() : null;
        this.checkSums = CheckSums.forContext(context);
        this.fqn2Files = FQN2Files.forRoot(rootURL);
        this.pluginsCache = JavaParsingContext.createPlugins(rootURL, context.getIndexFolder());
    }

    void analyze(@NonNull Iterable<? extends CompilationUnitTree> trees, @NonNull JavacTaskImpl jt, @NonNull JavaFileManager fileManager, @NonNull JavaCustomIndexer.CompileTuple active, @NonNull Set<? super ElementHandle<TypeElement>> newTypes, @NonNull boolean[] mainMethod) throws IOException {
        this.sa.analyse(trees, jt, fileManager, active, newTypes, mainMethod);
        Lookup pluginServices = this.getPluginServices(jt);
        for (CompilationUnitTree compilationUnitTree : trees) {
            for (JavaIndexerPlugin javaIndexerPlugin : this.getPlugins()) {
                javaIndexerPlugin.process(compilationUnitTree, active.indexable, pluginServices);
            }
        }
    }

    void delete(@NonNull Indexable indexable, @NonNull List<Pair<String, String>> toDelete) throws IOException {
        for (Pair<String, String> pair : toDelete) {
            this.sa.delete(pair);
        }
        for (JavaIndexerPlugin javaIndexerPlugin : this.getPlugins()) {
            javaIndexerPlugin.delete(indexable);
        }
    }

    void finish() {
        for (JavaIndexerPlugin javaIndexerPlugin : this.getPlugins()) {
            javaIndexerPlugin.finish();
        }
    }

    @NonNull
    private Iterable<? extends JavaIndexerPlugin> getPlugins() {
        return this.pluginsCache;
    }

    private static Iterable<? extends JavaIndexerPlugin> createPlugins(@NonNull URL root, @NonNull FileObject cacheFolder) {
        ArrayList<JavaIndexerPlugin> plugins = new ArrayList<JavaIndexerPlugin>();
        for (JavaIndexerPlugin.Factory factory : MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/x-java")).lookupAll(JavaIndexerPlugin.Factory.class)) {
            JavaIndexerPlugin plugin = factory.create(root, cacheFolder);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    @NonNull
    private Lookup getPluginServices(JavacTaskImpl jt) {
        return Lookups.fixed((Object[])new Object[]{jt.getElements(), jt.getTypes(), JavacTrees.instance(jt.getContext()), JavaSourceAccessor.getINSTANCE().createElementUtilities(jt)});
    }

    private static void registerVirtualSources(ClasspathInfo cpInfo, Collection<? extends JavaCustomIndexer.CompileTuple> virtualSources) {
        for (JavaCustomIndexer.CompileTuple compileTuple : virtualSources) {
            ClasspathInfoAccessor.getINSTANCE().registerVirtualSource(cpInfo, compileTuple.jfo);
        }
    }
}

