/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.awt.EventQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Mutex;
import org.openide.util.Task;

public final class AWTTask
extends Task {
    static final LinkedBlockingQueue<AWTTask> PENDING = new LinkedBlockingQueue();
    private static final EDT WAKE_UP = new EDT();
    private static final Runnable PROCESSOR = new Processor();
    private boolean executed;

    public AWTTask(Runnable r) {
        super(r);
        PENDING.add(this);
        Mutex.EVENT.readAccess(PROCESSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.executed) {
            try {
                super.run();
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                Logger.getLogger("org.openide.awt.Toolbar").log(Level.WARNING, "Error in AWT task", t);
            }
            finally {
                this.executed = true;
            }
        }
    }

    public void waitFinished() {
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else {
            WAKE_UP.wakeUp();
            super.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFinished(long milliseconds) throws InterruptedException {
        if (EventQueue.isDispatchThread()) {
            this.run();
            return true;
        }
        WAKE_UP.wakeUp();
        AWTTask aWTTask = this;
        synchronized (aWTTask) {
            if (this.isFinished()) {
                return true;
            }
            ((Object)((Object)this)).wait(milliseconds);
            return this.isFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(Task t) {
        assert (EventQueue.isDispatchThread());
        if (!PENDING.isEmpty()) {
            PROCESSOR.run();
            return false;
        }
        Thread previous = null;
        try {
            previous = WAKE_UP.enter();
            if (!t.waitFinished(10000L)) {
                AWTTask.flush();
                boolean bl = false;
                return bl;
            }
        }
        catch (InterruptedException ex) {
            AWTTask.flush();
            boolean bl = false;
            return bl;
        }
        finally {
            WAKE_UP.exit(previous);
        }
        return true;
    }

    private static void flush() {
        PROCESSOR.run();
    }

    private static final class EDT {
        private Thread awt;

        private EDT() {
        }

        public synchronized Thread enter() {
            assert (EventQueue.isDispatchThread());
            Thread p = this.awt;
            this.awt = Thread.currentThread();
            return p;
        }

        public synchronized void exit(Thread previous) {
            assert (EventQueue.isDispatchThread());
            assert (this.awt == Thread.currentThread()) : "awt = " + this.awt;
            this.awt = previous;
            Thread.interrupted();
        }

        public synchronized void wakeUp() {
            if (this.awt != null) {
                this.awt.interrupt();
            }
        }
    }

    private static final class Processor
    implements Runnable {
        private Processor() {
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            AWTTask t;
            while ((t = PENDING.poll()) != null) {
                t.run();
            }
            return;
        }
    }
}

