/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class ImageUtilities {
    static final String TOOLTIP_SEPAR = "<br>";
    private static final ActiveRef<String> NO_ICON = new ActiveRef<Object>(null, null, null);
    private static final Map<String, ActiveRef<String>> cache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<String, ActiveRef<String>> localizedCache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<CompositeImageKey, ActiveRef<CompositeImageKey>> compositeCache = new HashMap<CompositeImageKey, ActiveRef<CompositeImageKey>>(128);
    private static final Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> imageToolTipCache = new HashMap<ToolTipImageKey, ActiveRef<ToolTipImageKey>>(128);
    private static final Set<String> extraInitialSlashes = new HashSet<String>();
    private static volatile Object currentLoader;
    private static Lookup.Result<ClassLoader> loaderQuery;
    private static boolean noLoaderWarned;
    private static final Component component;
    private static final MediaTracker tracker;
    private static int mediaTrackerID;
    private static ImageReader PNG_READER;
    private static final Logger ERR;

    private ImageUtilities() {
    }

    public static final Image loadImage(String resourceID) {
        return ImageUtilities.getIcon(resourceID, false);
    }

    public static final Image loadImage(String resource, boolean localized) {
        return ImageUtilities.getIcon(resource, localized);
    }

    public static final ImageIcon loadImageIcon(String resource, boolean localized) {
        Image image = ImageUtilities.getIcon(resource, localized);
        return image == null ? null : (ImageIcon)ImageUtilities.image2Icon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image mergeImages(Image image1, Image image2, int x, int y) {
        if (image1 == null || image2 == null) {
            throw new NullPointerException();
        }
        CompositeImageKey k = new CompositeImageKey(image1, image2, x, y);
        Map<CompositeImageKey, ActiveRef<CompositeImageKey>> map = compositeCache;
        synchronized (map) {
            Image cached;
            ActiveRef<CompositeImageKey> r = compositeCache.get(k);
            if (r != null && (cached = (Image)r.get()) != null) {
                return cached;
            }
            cached = ImageUtilities.doMergeImages(image1, image2, x, y);
            compositeCache.put(k, new ActiveRef<CompositeImageKey>(cached, compositeCache, k));
            return cached;
        }
    }

    public static final Icon image2Icon(Image image) {
        if (image instanceof ToolTipImage) {
            return ((ToolTipImage)image).getIcon();
        }
        return new ImageIcon(image);
    }

    public static final Image icon2Image(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        ToolTipImage image = new ToolTipImage("", icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = image.getGraphics();
        icon.paintIcon(new JLabel(), g, 0, 0);
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image assignToolTipToImage(Image image, String text) {
        Parameters.notNull("image", image);
        Parameters.notNull("text", text);
        ToolTipImageKey key = new ToolTipImageKey(image, text);
        Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> map = imageToolTipCache;
        synchronized (map) {
            Image cached;
            ActiveRef<ToolTipImageKey> r = imageToolTipCache.get(key);
            if (r != null && (cached = (Image)r.get()) != null) {
                return cached;
            }
            cached = ToolTipImage.createNew(text, image);
            imageToolTipCache.put(key, new ActiveRef<ToolTipImageKey>(cached, imageToolTipCache, key));
            return cached;
        }
    }

    public static final String getImageToolTip(Image image) {
        if (image instanceof ToolTipImage) {
            return ((ToolTipImage)image).toolTipText;
        }
        return "";
    }

    public static final Image addToolTipToImage(Image image, String text) {
        if (image instanceof ToolTipImage) {
            ToolTipImage tti = (ToolTipImage)image;
            StringBuilder str = new StringBuilder(tti.toolTipText);
            if (str.length() > 0 && text.length() > 0) {
                str.append(TOOLTIP_SEPAR);
            }
            str.append(text);
            return ImageUtilities.assignToolTipToImage(image, str.toString());
        }
        return ImageUtilities.assignToolTipToImage(image, text);
    }

    public static Icon createDisabledIcon(Icon icon) {
        Parameters.notNull("icon", icon);
        return new LazyDisabledIcon(ImageUtilities.icon2Image(icon));
    }

    public static Image createDisabledImage(Image image) {
        Parameters.notNull("image", image);
        return LazyDisabledIcon.createDisabledImage(image);
    }

    static ClassLoader getLoader() {
        Iterator it;
        Object is = currentLoader;
        if (is instanceof ClassLoader) {
            return (ClassLoader)is;
        }
        currentLoader = Thread.currentThread();
        if (loaderQuery == null) {
            loaderQuery = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
            loaderQuery.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    ERR.fine("Loader cleared");
                    currentLoader = null;
                }
            });
        }
        if ((it = loaderQuery.allInstances().iterator()).hasNext()) {
            ClassLoader toReturn = (ClassLoader)it.next();
            if (currentLoader == Thread.currentThread()) {
                currentLoader = toReturn;
            }
            ERR.fine("Loader computed: " + currentLoader);
            return toReturn;
        }
        if (!noLoaderWarned) {
            noLoaderWarned = true;
            ERR.warning("No ClassLoader instance found in " + Lookup.getDefault());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getIcon(String resource, boolean localized) {
        if (localized) {
            Map<String, ActiveRef<String>> map = localizedCache;
            synchronized (map) {
                String ext;
                String base;
                ActiveRef<String> ref = localizedCache.get(resource);
                Image img = null;
                if (ref == NO_ICON) {
                    return null;
                }
                if (ref != null) {
                    img = (Image)ref.get();
                }
                if (img != null) {
                    return img;
                }
                ClassLoader loader = ImageUtilities.getLoader();
                int idx = (resource = new String(resource).intern()).lastIndexOf(46);
                if (idx != -1 && idx > resource.lastIndexOf(47)) {
                    base = resource.substring(0, idx);
                    ext = resource.substring(idx);
                } else {
                    base = resource;
                    ext = "";
                }
                URL baseurl = loader != null ? loader.getResource(resource) : ImageUtilities.class.getClassLoader().getResource(resource);
                Iterator<String> it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    String suffix = it.next();
                    Image i = suffix.length() == 0 ? ImageUtilities.getIcon(resource, loader, false) : ImageUtilities.getIcon(base + suffix + ext, loader, true);
                    if (i == null) continue;
                    localizedCache.put(resource, new ActiveRef<String>(i, localizedCache, resource));
                    return i;
                }
                localizedCache.put(resource, NO_ICON);
                return null;
            }
        }
        return ImageUtilities.getIcon(resource, ImageUtilities.getLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getIcon(String name, ClassLoader loader, boolean localizedQuery) {
        ActiveRef<String> ref = cache.get(name);
        Image img = null;
        if (ref == NO_ICON) {
            return null;
        }
        if (ref != null) {
            img = (Image)ref.get();
        }
        if (img != null) {
            return img;
        }
        Map<String, ActiveRef<String>> map = cache;
        synchronized (map) {
            BufferedImage result;
            String n;
            boolean warn;
            block20: {
                ref = cache.get(name);
                if (ref == NO_ICON) {
                    return null;
                }
                if (ref != null) {
                    img = (Image)ref.get();
                }
                if (img != null) {
                    return img;
                }
                if (name.startsWith("/")) {
                    warn = true;
                    n = name.substring(1);
                } else {
                    warn = false;
                    n = name;
                }
                URL url = loader != null ? loader.getResource(n) : ImageUtilities.class.getClassLoader().getResource(n);
                result = null;
                try {
                    if (url == null) break block20;
                    if (name.endsWith(".png")) {
                        ImageInputStream stream = ImageIO.createImageInputStream(url.openStream());
                        ImageReadParam param = PNG_READER.getDefaultReadParam();
                        try {
                            PNG_READER.setInput(stream, true, true);
                            result = PNG_READER.read(0, param);
                        }
                        catch (IOException ioe1) {
                            ERR.log(Level.INFO, "Image " + name + " is not PNG", ioe1);
                        }
                        stream.close();
                    }
                    if (result == null) {
                        result = ImageIO.read(url);
                    }
                }
                catch (IOException ioe) {
                    ERR.log(Level.WARNING, "Cannot load " + name + " image", ioe);
                }
            }
            if (result != null) {
                if (warn && extraInitialSlashes.add(name)) {
                    ERR.warning("Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
                }
                ERR.log(Level.FINE, "loading icon {0} = {1}", new Object[]{n, result});
                name = new String(name).intern();
                result = ToolTipImage.createNew("", result);
                cache.put(name, new ActiveRef<String>(result, cache, name));
                return result;
            }
            if (!localizedQuery) {
                cache.put(name, NO_ICON);
            }
            return null;
        }
    }

    static final Image toBufferedImage(Image img) {
        new ImageIcon(img, "");
        if (img.getHeight(null) * img.getWidth(null) > 576) {
            return img;
        }
        BufferedImage rep = ImageUtilities.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            assert (tracker.statusID(id, false) == 8) : "Image loaded";
            tracker.removeImage(image, id);
        }
    }

    private static final Image doMergeImages(Image image1, Image image2, int x, int y) {
        ImageUtilities.ensureLoaded(image1);
        ImageUtilities.ensureLoaded(image2);
        int w = Math.max(image1.getWidth(null), x + image2.getWidth(null));
        int h = Math.max(image1.getHeight(null), y + image2.getHeight(null));
        boolean bitmask = image1 instanceof Transparency && ((Transparency)((Object)image1)).getTransparency() != 3 && image2 instanceof Transparency && ((Transparency)((Object)image2)).getTransparency() != 3;
        StringBuilder str = new StringBuilder(image1 instanceof ToolTipImage ? ((ToolTipImage)image1).toolTipText : "");
        if (image2 instanceof ToolTipImage) {
            String toolTip = ((ToolTipImage)image2).toolTipText;
            if (str.length() > 0 && toolTip.length() > 0) {
                str.append(TOOLTIP_SEPAR);
            }
            str.append(toolTip);
        }
        ColorModel model = ImageUtilities.colorModel(bitmask ? 2 : 3);
        ToolTipImage buffImage = new ToolTipImage(str.toString(), model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
        Graphics2D g = buffImage.createGraphics();
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, x, y, null);
        g.dispose();
        return buffImage;
    }

    static final BufferedImage createBufferedImage(int width, int height) {
        if (Utilities.isMac()) {
            return new BufferedImage(width, height, 3);
        }
        ColorModel model = ImageUtilities.colorModel(3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    private static ColorModel colorModel(int transparency) {
        ColorModel model;
        try {
            model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(transparency);
        }
        catch (HeadlessException he) {
            model = ColorModel.getRGBdefault();
        }
        return model;
    }

    static {
        loaderQuery = null;
        noLoaderWarned = false;
        component = new Component(){};
        tracker = new MediaTracker(component);
        ERR = Logger.getLogger(ImageUtilities.class.getName());
        ImageIO.setUseCache(false);
        PNG_READER = ImageIO.getImageReadersByMIMEType("image/png").next();
    }

    private static class DisabledButtonFilter
    extends RGBImageFilter {
        DisabledButtonFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return (rgb & 0xFF000000) + 0x888888 + ((rgb >> 16 & 0xFF) >> 2 << 16) + ((rgb >> 8 & 0xFF) >> 2 << 8) + ((rgb & 0xFF) >> 2);
        }

        public void setProperties(Hashtable props) {
            props = (Hashtable)props.clone();
            this.consumer.setProperties(props);
        }
    }

    private static class LazyDisabledIcon
    implements Icon {
        private static final RGBImageFilter DISABLED_BUTTON_FILTER = new DisabledButtonFilter();
        private Image img;
        private Icon disabledIcon;

        public LazyDisabledIcon(Image img) {
            assert (null != img);
            this.img = img;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getDisabledIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getDisabledIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getDisabledIcon().getIconHeight();
        }

        private synchronized Icon getDisabledIcon() {
            if (null == this.disabledIcon) {
                this.disabledIcon = new ImageIcon(LazyDisabledIcon.createDisabledImage(this.img));
            }
            return this.disabledIcon;
        }

        static Image createDisabledImage(Image img) {
            FilteredImageSource prod = new FilteredImageSource(img.getSource(), DISABLED_BUTTON_FILTER);
            return Toolkit.getDefaultToolkit().createImage(prod);
        }
    }

    private static class ToolTipImage
    extends BufferedImage
    implements Icon {
        final String toolTipText;
        ImageIcon imageIcon;

        public static ToolTipImage createNew(String toolTipText, Image image) {
            ImageUtilities.ensureLoaded(image);
            boolean bitmask = image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() != 3;
            ColorModel model = ImageUtilities.colorModel(bitmask ? 2 : 3);
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            ToolTipImage newImage = new ToolTipImage(toolTipText, model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
            Graphics2D g = newImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return newImage;
        }

        public ToolTipImage(String toolTipText, ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
            super(cm, raster, isRasterPremultiplied, properties);
            this.toolTipText = toolTipText;
        }

        public ToolTipImage(String toolTipText, int width, int height, int imageType, IndexColorModel cm) {
            super(width, height, imageType, cm);
            this.toolTipText = toolTipText;
        }

        public ToolTipImage(String toolTipText, int width, int height, int imageType) {
            super(width, height, imageType);
            this.toolTipText = toolTipText;
        }

        public ToolTipImage(String toolTipText, BufferedImage image) {
            super(image.getWidth(), image.getHeight(), image.getType());
            this.toolTipText = toolTipText;
        }

        synchronized ImageIcon getIcon() {
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(this);
            }
            return this.imageIcon;
        }

        @Override
        public int getIconHeight() {
            return super.getHeight();
        }

        @Override
        public int getIconWidth() {
            return super.getWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this, x, y, null);
        }
    }

    private static final class ActiveRef<T>
    extends SoftReference<Image>
    implements Runnable {
        private final Map<T, ActiveRef<T>> holder;
        private final T key;

        public ActiveRef(Image o, Map<T, ActiveRef<T>> holder, T key) {
            super(o, Utilities.activeReferenceQueue());
            this.holder = holder;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<T, ActiveRef<T>> map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static class ToolTipImageKey {
        Image image;
        String str;

        ToolTipImageKey(Image image, String str) {
            this.image = image;
            this.str = str;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ToolTipImageKey)) {
                return false;
            }
            ToolTipImageKey k = (ToolTipImageKey)other;
            return this.str.equals(k.str) && this.image == k.image;
        }

        public int hashCode() {
            int hash = this.image.hashCode() ^ this.str.hashCode();
            return hash;
        }

        public String toString() {
            return "ImageStringKey for " + this.image + " + " + this.str;
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image base, Image overlay, int x, int y) {
            this.x = x;
            this.y = y;
            this.baseImage = base;
            this.overlayImage = overlay;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey k = (CompositeImageKey)other;
            return this.x == k.x && this.y == k.y && this.baseImage == k.baseImage && this.overlayImage == k.overlayImage;
        }

        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            hash = hash ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return hash;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

