/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.process;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="process")
public class ProcessExecutionConfig {
    @XStreamAlias(value="id")
    private String id;
    @XStreamAlias(value="program")
    private File pathToProgram;
    @XStreamImplicit(itemFieldName="arg")
    private List<String> args;
    @XStreamAlias(value="dir")
    private File executionDir;
    @XStreamAlias(value="redirectStdErr")
    private Boolean redirectStdErr;
    @XStreamAlias(value="redirectStdOut")
    private Boolean redirectStdOut;
    @XStreamAlias(value="timeoutMillis")
    private Long timeout;

    private ProcessExecutionConfig readResolve() {
        if (this.redirectStdErr == null) {
            this.redirectStdErr = false;
        }
        if (this.redirectStdOut == null) {
            this.redirectStdOut = false;
        }
        if (this.executionDir == null && this.pathToProgram != null) {
            this.executionDir = this.pathToProgram.getParentFile();
            if (this.executionDir == null) {
                this.executionDir = new File(".");
            }
        }
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (this.id == null) {
            this.id = this.pathToProgram != null ? this.pathToProgram.getName() : "exec";
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getRedirectStdErr() {
        return this.redirectStdErr;
    }

    public void setRedirectStdErr(Boolean redirectStdErr) {
        this.redirectStdErr = redirectStdErr;
    }

    public Boolean getRedirectStdOut() {
        return this.redirectStdOut;
    }

    public void setRedirectStdOut(Boolean redirectStdOut) {
        this.redirectStdOut = redirectStdOut;
    }

    public boolean isRedirectStdErr() {
        if (this.redirectStdErr == null) {
            return false;
        }
        return this.redirectStdErr;
    }

    public boolean isRedirectStdOut() {
        if (this.redirectStdOut == null) {
            return false;
        }
        return this.redirectStdOut;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeoutMillis) {
        this.timeout = timeoutMillis;
    }

    public File getPathToProgram() {
        return this.pathToProgram;
    }

    public void setPathToProgram(String pathToProgram) {
        this.pathToProgram = new File(pathToProgram);
    }

    public void setPathToProgram(File pathToProgram) {
        this.pathToProgram = pathToProgram;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public File getExecutionDir() {
        return this.executionDir;
    }

    public void setExecutionDir(String executionDir) {
        this.executionDir = new File(executionDir);
    }

    public void setExecutionDir(File executionDir) {
        this.executionDir = executionDir;
    }

    public void setRedirectStdErr(boolean redirectStdErr) {
        this.redirectStdErr = redirectStdErr;
    }

    public void setRedirectStdOut(boolean redirectStdOut) {
        this.redirectStdOut = redirectStdOut;
    }
}

