/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.process;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import cz.cuni.amis.utils.Const;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="process")
public class ProcessExecutionConfig {
    @XStreamAlias(value="id")
    private String id;
    @XStreamAlias(value="run")
    private String pathToProgram;
    @XStreamImplicit(itemFieldName="arg")
    private List<String> args;
    @XStreamAlias(value="dir")
    private String executionDir;
    @XStreamAlias(value="redirectStdErr")
    private Boolean redirectStdErr;
    @XStreamAlias(value="redirectStdOut")
    private Boolean redirectStdOut;
    @XStreamAlias(value="timeoutMillis")
    private Long timeout;

    private ProcessExecutionConfig readResolve() {
        if (this.redirectStdErr == null) {
            this.redirectStdErr = false;
        }
        if (this.redirectStdOut == null) {
            this.redirectStdOut = false;
        }
        if (this.executionDir == null) {
            this.executionDir = ".";
        }
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (this.id == null) {
            this.id = this.pathToProgram != null ? this.pathToProgram : "exec";
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getRedirectStdErr() {
        return this.redirectStdErr;
    }

    public void setRedirectStdErr(Boolean redirectStdErr) {
        this.redirectStdErr = redirectStdErr;
    }

    public Boolean getRedirectStdOut() {
        return this.redirectStdOut;
    }

    public void setRedirectStdOut(Boolean redirectStdOut) {
        this.redirectStdOut = redirectStdOut;
    }

    public boolean isRedirectStdErr() {
        if (this.redirectStdErr == null) {
            return false;
        }
        return this.redirectStdErr;
    }

    public boolean isRedirectStdOut() {
        if (this.redirectStdOut == null) {
            return false;
        }
        return this.redirectStdOut;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public ProcessExecutionConfig setTimeout(Long timeoutMillis) {
        this.timeout = timeoutMillis;
        return this;
    }

    public ProcessExecutionConfig setTimeout(long timeoutMillis) {
        this.timeout = timeoutMillis;
        return this;
    }

    public String getPathToProgram() {
        return this.pathToProgram;
    }

    public ProcessExecutionConfig setPathToProgram(String pathToProgram) {
        this.pathToProgram = pathToProgram;
        return this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public ProcessExecutionConfig addArg(String arg) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(arg);
        return this;
    }

    public ProcessExecutionConfig setArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public String getExecutionDir() {
        return this.executionDir;
    }

    public ProcessExecutionConfig setExecutionDir(String executionDir) {
        this.executionDir = executionDir;
        return this;
    }

    public ProcessExecutionConfig setRedirectStdErr(boolean redirectStdErr) {
        this.redirectStdErr = redirectStdErr;
        return this;
    }

    public ProcessExecutionConfig setRedirectStdOut(boolean redirectStdOut) {
        this.redirectStdOut = redirectStdOut;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ProcessExecutionConfig[");
        sb.append(Const.NEW_LINE + "  pathToProgram     = " + this.pathToProgram);
        sb.append(Const.NEW_LINE + "  executionDir      = " + this.executionDir);
        sb.append(Const.NEW_LINE + "  args = ");
        if (this.args != null) {
            for (String arg : this.args) {
                sb.append(Const.NEW_LINE + "    " + arg);
            }
        }
        sb.append(Const.NEW_LINE + "  redirectStdOut   = " + this.redirectStdOut);
        sb.append(Const.NEW_LINE + "  redirectStdErr   = " + this.redirectStdErr);
        sb.append("]");
        return sb.toString();
    }
}

