/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes;

import cz.dd4j.agents.HeroAgentBase;
import cz.dd4j.agents.commands.Command;
import cz.dd4j.domain.EFeature;
import cz.dd4j.domain.EItem;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class HeroSemiRandom
extends HeroAgentBase {
    public HeroSemiRandom() {
        this.random = new Random();
    }

    public Command act() {
        List<Command> actions = this.generateActions(this.hero);
        if (actions.size() == 0) {
            return null;
        }
        return this.getRandomAction(actions, true);
    }

    private List<Command> generateActions(Hero hero) {
        ArrayList<Command> result = new ArrayList<Command>();
        for (Corridor corridor : hero.atRoom.corridors) {
            Room otherRoom = corridor.getOtherRoom(hero.atRoom);
            if (otherRoom.monster != null && (hero.hand == null || hero.hand.type != EItem.SWORD) || otherRoom.feature != null && otherRoom.feature.type == EFeature.TRAP && hero.hand != null) continue;
            result.add(this.actions.move(corridor.getOtherRoom(hero.atRoom)));
        }
        if (hero.atRoom.monster != null && hero.hand != null && hero.hand.type == EItem.SWORD) {
            result.add(this.actions.attack());
        }
        if (hero.hand == null && hero.atRoom.feature != null && hero.atRoom.feature.type == EFeature.TRAP) {
            result.add(this.actions.disarm());
        }
        if (hero.hand != null) {
            result.add(this.actions.drop());
        }
        if (hero.atRoom.item != null) {
            result.add(this.actions.pickup());
        }
        return result;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

