/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.pddl;

import cz.dd4j.agents.commands.Command;
import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.pddl.PDDLAgentBase;
import cz.dd4j.simulation.actions.EAction;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import cz.dd4j.utils.csv.CSV;
import java.util.List;

@AutoConfig
public class Clever03Agent
extends PDDLAgentBase {
    @Configurable
    protected int dangerThreshold = 2;
    @Configurable
    protected int safeThreshold = 3;
    protected List<PDDLAction> currentPlan;
    private boolean reactiveActionTaken;
    private boolean reactiveEscape = false;
    protected int reactiveActions = 0;
    protected Monster dangerousMonster = null;

    @Override
    public void prepareAgent() {
        super.prepareAgent();
    }

    protected boolean shouldReplan() {
        if (this.reactiveActionTaken) {
            return true;
        }
        if (this.currentPlan == null || this.currentPlan.isEmpty()) {
            return true;
        }
        PDDLAction action = this.currentPlan.get(0);
        return !this.actionValidator.isValid((Entity)this.hero, this.translateAction(action));
    }

    private Command getBestReactiveAction() {
        ++this.reactiveActions;
        this.reactiveActionTaken = true;
        List availableActions = this.actionsGenerator.generateFor((Entity)this.hero);
        System.out.println("Reactive action");
        Command selectedAction = null;
        int bestVal = Integer.MIN_VALUE;
        for (Command c : availableActions) {
            int val = this.evaluateCommand(c);
            if (val <= bestVal) continue;
            selectedAction = c;
            bestVal = val;
        }
        return selectedAction;
    }

    @Override
    public Command act() {
        int dng = this.dang(this.hero.atRoom);
        if (dng == 0) {
            return null;
        }
        if (this.reactiveEscape && dng >= this.safeThreshold) {
            this.reactiveEscape = false;
            this.currentPlan = this.plan(String.format("(and (alive)(has_sword)(not(monster_at %s)))", this.dangerousMonster.atRoom.id.name));
            this.dangerousMonster = null;
            if (this.currentPlan != null && !this.currentPlan.isEmpty()) {
                this.reactiveActionTaken = false;
                return this.translateAction(this.currentPlan.remove(0));
            }
        }
        if (this.reactiveEscape) {
            return this.getBestReactiveAction();
        }
        if (this.shouldReplan()) {
            this.currentPlan = this.plan();
        }
        if (this.currentPlan == null) {
            return this.getBestReactiveAction();
        }
        Command cmd = this.translateAction(this.currentPlan.remove(0));
        if (!(this.evaluateCommand(cmd) > this.dangerThreshold || cmd.isType(EAction.MOVE) && ((Room)cmd.target).feature != null)) {
            this.reactiveEscape = true;
            this.dangerousMonster = cmd.isType(EAction.MOVE) ? this.getClosestMonster((Room)cmd.target) : this.getClosestMonster(this.hero.atRoom);
            System.out.println("Planned action would be: " + cmd.toString() + " dang: " + this.evaluateCommand(cmd));
            return this.getBestReactiveAction();
        }
        this.reactiveActionTaken = false;
        return cmd;
    }

    private int evaluateCommand(Command cmd) {
        return this.dangAfterAction(cmd);
    }

    @Override
    public List<String> getCSVHeaders() {
        List<String> headers = super.getCSVHeaders();
        headers.add("reactive_steps");
        return headers;
    }

    @Override
    public CSV.CSVRow getCSVRow() {
        CSV.CSVRow row = super.getCSVRow();
        row.add("reactive_steps", (Object)this.reactiveActions);
        return row;
    }
}

