/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.pddl;

import cz.dd4j.agents.commands.Command;
import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.pddl.PDDLAgentBase;
import cz.dd4j.simulation.data.dungeon.Dungeon;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.config.AutoConfig;
import java.util.ArrayList;
import java.util.List;

@AutoConfig
public class NaivePlanning01Agent
extends PDDLAgentBase {
    protected List<PDDLAction> currentPlan;
    private boolean stateChanged = false;
    private List<Room> monsterRooms;
    private List<Room> oldMonsterRooms;

    @Override
    public void prepareAgent() {
        super.prepareAgent();
    }

    public boolean shouldReplan() {
        if (this.currentPlan == null || this.currentPlan.isEmpty()) {
            return true;
        }
        PDDLAction action = this.currentPlan.get(0);
        if (!this.actionValidator.isValid((Entity)this.hero, this.translateAction(action))) {
            return true;
        }
        return this.stateChanged;
    }

    @Override
    public Command act() {
        if (this.hero.atRoom.monster != null && this.hero.hand == null) {
            return null;
        }
        if (this.shouldReplan()) {
            this.currentPlan = this.plan();
        }
        if (this.currentPlan == null) {
            return null;
        }
        PDDLAction currentAction = this.currentPlan.remove(0);
        return this.translateAction(currentAction);
    }

    @Override
    protected void processDungeonFull(Dungeon dungeon) {
        super.processDungeonFull(dungeon);
        this.monsterRooms = new ArrayList<Room>();
        for (Room r : dungeon.rooms.values()) {
            if (r.monster == null) continue;
            this.monsterRooms.add(r);
        }
    }

    @Override
    protected void processDungeonUpdate(Dungeon dungeon) {
        this.oldMonsterRooms = new ArrayList<Room>(this.monsterRooms);
        super.processDungeonUpdate(dungeon);
        this.monsterRooms = new ArrayList<Room>();
        for (Room r : dungeon.rooms.values()) {
            if (r.monster == null) continue;
            this.monsterRooms.add(r);
        }
        this.stateChanged = this.monsterRooms.size() != this.oldMonsterRooms.size() && this.monsterRooms.size() != this.oldMonsterRooms.size() - 1 || !this.oldMonsterRooms.containsAll(this.monsterRooms);
    }
}

