/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.planners;

import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.planners.AbstractPlannerExecutor;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.io.FileUtils;

@AutoConfig
public class NPlanCygwinExecutor
extends AbstractPlannerExecutor {
    @Configurable
    protected File nplanFolder = new File("./nplan");
    @Configurable
    protected String nplanBatchFile = "nplan.bat";
    File problemFile;
    File nplanWorkingDir;
    File domainFile;

    @Override
    public List<PDDLAction> execPlanner(File domainFile, File problemFile) throws IOException {
        File resultFile = new File(this.nplanWorkingDir, "plan.SOL");
        FileUtils.copyFile((File)domainFile, (File)new File(this.nplanWorkingDir, "domain.pddl"));
        File workingProblemFile = new File(this.nplanWorkingDir, "problem.pddl");
        if (!problemFile.getCanonicalPath().equals(workingProblemFile.getCanonicalPath())) {
            FileUtils.copyFile((File)problemFile, (File)workingProblemFile);
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("domain", "domain.pddl");
        config.put("problem", "problem.pddl");
        config.put("result", "plan.SOL");
        CommandLine commandLine = new CommandLine("cmd.exe");
        commandLine.addArgument("/C");
        commandLine.addArgument(this.nplanBatchFile);
        commandLine.addArgument("${domain}");
        commandLine.addArgument("${problem}");
        commandLine.addArgument("${result}");
        commandLine.setSubstitutionMap(config);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.nplanWorkingDir);
        executor.setExitValue(0);
        try {
            executor.execute(commandLine);
        }
        catch (Exception e) {
            return null;
        }
        if (!resultFile.exists()) {
            return null;
        }
        String resultLines = FileUtils.readFileToString((File)resultFile);
        resultFile.delete();
        return this.parseLines(resultLines);
    }

    @Override
    public void prepareEnvironment(File agentWorkingDir) {
        this.problemFile = new File(agentWorkingDir, "nplan/problem.pddl");
        this.nplanWorkingDir = new File(agentWorkingDir, "nplan");
        this.nplanWorkingDir.mkdirs();
        this.nplanWorkingDir.deleteOnExit();
        this.copyNPlanFolder(this.nplanFolder, this.nplanWorkingDir);
    }

    private void copyNPlanFolder(File nplanFolder, File nplanWorkingDir) {
        try {
            File[] fileArray = nplanFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    FileUtils.copyFileToDirectory((File)file, (File)nplanWorkingDir);
                } else if (file.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)file, (File)nplanWorkingDir);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy directory '" + nplanFolder.getAbsolutePath() + "' into '" + nplanWorkingDir.getAbsolutePath() + "'.", e);
        }
    }
}

