/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.planners;

import cz.cuni.amis.utils.eh4j.shortcut.EH;
import cz.dd4j.agents.heroes.pddl.InputFiles;
import cz.dd4j.domain.EFeature;
import cz.dd4j.domain.EItem;
import cz.dd4j.simulation.data.dungeon.Dungeon;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.Const;
import cz.dd4j.utils.Id;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

@AutoConfig
public class PDDLInputGenerator {
    @Configurable
    protected File domainFile = new File("./DarkDungeon.pddl");
    @Configurable
    protected String domainName = "DarkDungeon";
    private String pddlNewLine = Const.NEW_LINE;
    private File agentWorkingDir;
    private StringBuffer pddlStaticPartCache = new StringBuffer();

    public void setPddlNewLine(String pddlNewLine) {
        this.pddlNewLine = pddlNewLine;
    }

    public PDDLInputGenerator(File workingDir) {
        this.agentWorkingDir = workingDir;
    }

    public void prepareStaticPart(Dungeon dungeon, String domainName, List<Room> roomsWithSword) {
        this.pddlStaticPartCache.setLength(0);
        StringBuffer sb = this.pddlStaticPartCache;
        sb.append("(define (problem p1)");
        sb.append(this.pddlNewLine);
        sb.append("(:domain " + domainName + ")");
        sb.append(this.pddlNewLine);
        sb.append(this.pddlNewLine);
        sb.append("(:objects");
        for (Room room : dungeon.rooms.values()) {
            sb.append(" ");
            sb.append(room.id.name);
        }
        sb.append(" - room");
        sb.append(this.pddlNewLine);
        sb.append("          ");
        boolean atLeastOneSword = false;
        for (Room room : roomsWithSword) {
            if (room.item == null || !EH.isA((Object)room.item.type, (Object)EItem.SWORD)) continue;
            sb.append(" ");
            sb.append(room.item.id.name);
            atLeastOneSword = true;
        }
        if (atLeastOneSword) {
            sb.append(" - sword)");
        } else {
            sb.append(")");
        }
        sb.append(this.pddlNewLine);
        sb.append(this.pddlNewLine);
        sb.append("(:init");
        sb.append(this.pddlNewLine);
        sb.append(this.pddlNewLine);
        for (Room room : dungeon.rooms.values()) {
            for (Corridor corridor : room.corridors) {
                Room other = corridor.getOtherRoom(room);
                sb.append("    (connected " + room.id.name + " " + other.id.name + ")");
                sb.append(this.pddlNewLine);
            }
        }
    }

    public InputFiles generateFiles(Hero hero, Map<Id, Monster> monsters, Map<Id, Feature> features, List<Room> roomsWithSword, List<Room> goalRooms, File problemFile, File domainFile) {
        if (goalRooms.size() > 0) {
            String goal = "(and (alive)(hero_at " + goalRooms.get((int)0).id.name + "))";
            return this.generateFiles(hero, monsters, features, roomsWithSword, goal, problemFile, domainFile);
        }
        throw new RuntimeException("goalRooms.size() == 0, invalid");
    }

    public InputFiles generateFiles(Hero hero, Map<Id, Monster> monsters, Map<Id, Feature> features, List<Room> roomsWithSword, String goal, File problemFile, File domainFile) {
        InputFiles inputs = new InputFiles();
        inputs.domainFile = domainFile;
        inputs.problemFile = this.generateProblemFile(hero, monsters, features, roomsWithSword, goal, problemFile);
        return inputs;
    }

    protected File generateProblemFile(Hero hero, Map<Id, Monster> monsters, Map<Id, Feature> features, List<Room> roomsWithSword, String goal, File problemFile) {
        if (problemFile == null) {
            problemFile = this.getWorkingDir("problem.pddl");
        }
        FileOutputStream outStream = null;
        PrintWriter print = null;
        try {
            try {
                outStream = new FileOutputStream(problemFile);
                print = new PrintWriter(outStream);
                this.generateProblem(hero, monsters, features, roomsWithSword, goal, print);
            }
            catch (Exception e) {
                if (print != null) {
                    try {
                        print.close();
                    }
                    catch (Exception e1) {
                        print = null;
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception e2) {
                        outStream = null;
                    }
                }
                try {
                    problemFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new RuntimeException("Failed to generate PDDL problem file into: " + problemFile.getAbsolutePath(), e);
            }
        }
        finally {
            if (print != null) {
                try {
                    print.close();
                }
                catch (Exception e) {
                    print = null;
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    outStream = null;
                }
            }
        }
        return problemFile;
    }

    protected File getWorkingDir(String name) {
        return new File(this.agentWorkingDir, name);
    }

    void generateProblem(Hero hero, Map<Id, Monster> monsters, Map<Id, Feature> features, List<Room> roomsWithSword, String goal, PrintWriter print) throws IOException {
        print.print(this.pddlStaticPartCache.toString());
        print.print(this.pddlNewLine);
        if (hero.alive) {
            print.print("    (alive)");
            print.print(this.pddlNewLine);
        }
        if (hero.hand != null && EH.isA((Object)hero.hand.type, (Object)EItem.SWORD)) {
            print.print("    (has_sword)");
            print.print(this.pddlNewLine);
        } else {
            print.print("    (empty_handed)");
            print.print(this.pddlNewLine);
        }
        for (Monster monster : monsters.values()) {
            if (!monster.alive || monster.atRoom == null) continue;
            print.print("    (monster_at " + monster.atRoom.id.name + ")");
            print.print(this.pddlNewLine);
        }
        for (Feature feature : features.values()) {
            if (!feature.alive || !EH.isA((Object)feature.type, (Object)EFeature.TRAP) || feature.atRoom == null) continue;
            print.print("    (trap_at " + feature.atRoom.id.name + ")");
            print.print(this.pddlNewLine);
        }
        for (Room room : roomsWithSword) {
            print.print("    (sword_at " + room.id.name + ")");
            print.print(this.pddlNewLine);
        }
        if (hero.atRoom == null) {
            throw new RuntimeException("hero.atRoom is null, invalid");
        }
        print.print("    (hero_at " + hero.atRoom.id.name + ")");
        print.print(this.pddlNewLine);
        print.print(")");
        print.print(this.pddlNewLine);
        print.print("");
        print.print(this.pddlNewLine);
        if (goal != null) {
            print.print("(:goal " + goal + ")");
        }
        print.print("");
        print.print(this.pddlNewLine);
        print.print(")");
        print.print(this.pddlNewLine);
    }
}

