/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.loader.agents.impl.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import cz.dd4j.agents.IAgent;
import cz.dd4j.loader.LoaderXML;
import cz.dd4j.loader.agents.IAgentsLoaderImpl;
import cz.dd4j.loader.agents.impl.xml.AgentXML;
import cz.dd4j.loader.agents.impl.xml.AgentsXML;
import cz.dd4j.loader.utils.IdTypeConverter;
import cz.dd4j.simulation.data.agents.Agents;
import cz.dd4j.utils.config.Configure;
import java.io.File;

public class AgentsLoaderXML<AGENT extends IAgent>
extends LoaderXML<AgentsXML>
implements IAgentsLoaderImpl<AGENT> {
    public AgentsLoaderXML() {
        super(AgentsXML.class);
        this.xstream.registerConverter((SingleValueConverter)new IdTypeConverter());
    }

    public Agents<AGENT> loadAgents(File xmlFile) {
        AgentsXML agents = (AgentsXML)this.load(xmlFile);
        Agents result = new Agents();
        for (AgentXML agentXML : agents.agents) {
            if (result.agents.containsKey(agentXML.id)) {
                throw new RuntimeException("There are two Feature[id=" + agentXML.id + "] defined within: " + xmlFile.getAbsolutePath());
            }
            AGENT agent = this.createAgent(agentXML);
            result.agents.put(agentXML.id, agent);
        }
        return result;
    }

    protected AGENT createAgent(AgentXML agentXML) {
        AGENT agent = this.createAgentInstance(agentXML.agentFQCN);
        Configure.configure(agent, agentXML.config);
        return agent;
    }

    private AGENT createAgentInstance(String agentFQCN) {
        Object agent = null;
        try {
            Class<?> cls = Class.forName(agentFQCN);
            agent = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate feature " + agentFQCN + ", using parameterless constructor.", e);
        }
        return (AGENT)((IAgent)agent);
    }
}

