/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.utils.astar;

import cz.dd4j.utils.astar.IAStarHeuristic;
import cz.dd4j.utils.astar.IAStarView;
import cz.dd4j.utils.astar.Path;
import cz.dd4j.utils.astar.graph.ILink;
import cz.dd4j.utils.astar.graph.INode;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;

public class AStar<NODE extends INode<NODE>> {
    private IAStarHeuristic<NODE> heuristic;

    public AStar(IAStarHeuristic<NODE> heuristic) {
        this.heuristic = heuristic;
    }

    public Path<NODE> findPath(NODE from, NODE to) {
        return this.findPath(from, to, null);
    }

    public Path<NODE> findPath(NODE from, NODE to, IAStarView view) {
        HashMap<Object, SearchNode> nodes = new HashMap<Object, SearchNode>();
        PriorityQueue<SearchNode> opened = new PriorityQueue<SearchNode>(40, new Comparator<SearchNode>(){

            @Override
            public int compare(SearchNode o1, SearchNode o2) {
                return o1.currentCost - o2.currentCost;
            }
        });
        SearchNode initial = new SearchNode(this, from, 0, null);
        nodes.put(from, initial);
        opened.add(initial);
        while (opened.size() > 0) {
            SearchNode current = (SearchNode)opened.remove();
            if (current.node.equals(to)) {
                return this.reconstructPath(from, current);
            }
            for (ILink link : current.node.getLinks()) {
                int newCost;
                INode nextNode = (INode)link.getOther(current.node);
                if (view != null && !view.isOpened(nextNode)) continue;
                SearchNode next = (SearchNode)nodes.get(nextNode);
                if (next == null) {
                    next = new SearchNode(this, nextNode, Integer.MAX_VALUE, current);
                    nodes.put(nextNode, next);
                }
                if ((newCost = current.currentCost + link.getCost() + this.heuristic.getEstimate(nextNode, (INode)to)) >= next.currentCost) continue;
                if (next.currentCost != Integer.MAX_VALUE) {
                    opened.remove(next);
                }
                next.previous = current;
                next.currentCost = newCost;
                opened.add(next);
            }
        }
        return null;
    }

    private Path<NODE> reconstructPath(NODE from, SearchNode to) {
        Path result = new Path();
        while (to != null && to != from) {
            result.path.add(to.node);
            to = to.previous;
        }
        Collections.reverse(result.path);
        return result;
    }

    private static class SearchNode {
        public NODE node;
        public int currentCost;
        public SearchNode previous;
        final /* synthetic */ AStar this$0;

        public SearchNode(NODE node, int currentCost, SearchNode previous) {
            this.this$0 = var1_1;
            this.node = node;
            this.currentCost = currentCost;
            this.previous = previous;
        }
    }
}

