/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.utils.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CombinationsGenerator<T>
implements Iterable<List<T>> {
    private int count;
    private List<T> items;
    private boolean unique;

    public CombinationsGenerator(int count, List<T> items, boolean unique) {
        this.count = count;
        this.items = items;
        this.unique = unique;
    }

    @Override
    public Iterator<List<T>> iterator() {
        if (this.unique) {
            return new UniqueCombinationsIterator<T>(this.count, this.items);
        }
        return new NonUniqueCombinationsIterator<T>(this.count, this.items);
    }

    public long totalCount() {
        if (this.unique) {
            long a = 1L;
            long b = 1L;
            int i = 0;
            while (i < this.count) {
                a *= (long)(this.items.size() - i);
                b *= (long)(this.count - i);
                ++i;
            }
            return a / b;
        }
        long a = 1L;
        long b = 1L;
        int i = 0;
        while (i < this.count) {
            a *= (long)(this.items.size() + this.count - 1 - i);
            b *= (long)(this.count - i);
            ++i;
        }
        return a / b;
    }

    protected static abstract class CombinationsIteratorBase<T>
    implements Iterator<List<T>> {
        protected int count;
        protected List<T> items;
        protected int[] indices;
        protected boolean hasNext;

        public CombinationsIteratorBase(int count, List<T> items) {
            this.count = count;
            this.items = items;
            this.indices = null;
            this.hasNext = true;
        }

        @Override
        public boolean hasNext() {
            if (this.indices == null) {
                if (this.count > this.items.size()) {
                    return false;
                }
                if (this.count == 0) {
                    this.indices = new int[0];
                    return true;
                }
                this.init();
                return true;
            }
            return this.hasNext;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        protected abstract void init();

        @Override
        public List<T> next() {
            if (this.indices == null) {
                this.hasNext();
            }
            if (!this.hasNext) {
                return null;
            }
            ArrayList<T> result = new ArrayList<T>(this.count);
            if (this.count == 0) {
                this.hasNext = false;
                return result;
            }
            int i = 0;
            while (i < this.indices.length) {
                int index = this.indices[i];
                result.add(this.items.get(index));
                ++i;
            }
            this.computeNextIndices(this.indices, this.count - 1);
            return result;
        }

        protected abstract void computeNextIndices(int[] var1, int var2);
    }

    private static class NonUniqueCombinationsIterator<T>
    extends CombinationsIteratorBase<T> {
        public NonUniqueCombinationsIterator(int count, List<T> items) {
            super(count, items);
        }

        @Override
        protected void init() {
            this.indices = new int[this.count];
            int i = 0;
            while (i < this.indices.length) {
                this.indices[i] = 0;
                ++i;
            }
        }

        @Override
        protected void computeNextIndices(int[] indices, int index) {
            if (index < 0) {
                return;
            }
            int n = index;
            indices[n] = indices[n] + 1;
            if (indices[index] < this.items.size()) {
                return;
            }
            if (index == 0) {
                this.hasNext = false;
                return;
            }
            this.computeNextIndices(indices, index - 1);
            if (!this.hasNext) {
                return;
            }
            indices[index] = indices[index - 1];
            if (indices[index] < this.items.size()) {
                return;
            }
            this.hasNext = false;
        }
    }

    private static class UniqueCombinationsIterator<T>
    extends CombinationsIteratorBase<T> {
        public UniqueCombinationsIterator(int count, List<T> items) {
            super(count, items);
        }

        @Override
        protected void init() {
            this.indices = new int[this.count];
            int i = 0;
            while (i < this.indices.length) {
                this.indices[i] = i;
                ++i;
            }
        }

        @Override
        protected void computeNextIndices(int[] indices, int index) {
            if (index < 0) {
                return;
            }
            int n = index;
            indices[n] = indices[n] + 1;
            if (indices[index] < this.items.size()) {
                return;
            }
            if (index == 0) {
                this.hasNext = false;
                return;
            }
            this.computeNextIndices(indices, index - 1);
            if (!this.hasNext) {
                return;
            }
            indices[index] = indices[index - 1] + 1;
            if (indices[index] < this.items.size()) {
                return;
            }
            this.hasNext = false;
        }
    }
}

