/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.utils.math;

import cz.dd4j.utils.math.CombinationsGenerator;
import java.util.Iterator;
import java.util.List;

public class VariationsGenerator<T>
implements Iterable<List<T>> {
    private int count;
    private List<T> items;
    private boolean unique;

    public VariationsGenerator(int count, List<T> items, boolean unique) {
        this.count = count;
        this.items = items;
        this.unique = unique;
    }

    @Override
    public Iterator<List<T>> iterator() {
        if (this.unique) {
            return new UniqueVariationsIterator<T>(this.count, this.items);
        }
        return new NonUniqueVariationsIterator<T>(this.count, this.items);
    }

    public long totalCount() {
        if (this.unique) {
            long result = 1L;
            int i = 0;
            while (i < this.count) {
                result *= (long)(this.items.size() - i);
                ++i;
            }
            return result;
        }
        return (long)Math.pow(this.items.size(), this.count);
    }

    private static class NonUniqueVariationsIterator<T>
    extends CombinationsGenerator.CombinationsIteratorBase<T> {
        public NonUniqueVariationsIterator(int count, List<T> items) {
            super(count, items);
        }

        @Override
        protected void init() {
            this.indices = new int[this.count];
            int i = 0;
            while (i < this.indices.length) {
                this.indices[i] = 0;
                ++i;
            }
        }

        @Override
        protected void computeNextIndices(int[] indices, int index) {
            if (index < 0) {
                return;
            }
            int n = index;
            indices[n] = indices[n] + 1;
            if (indices[index] < this.items.size()) {
                return;
            }
            if (index == 0) {
                this.hasNext = false;
                return;
            }
            this.computeNextIndices(indices, index - 1);
            if (!this.hasNext) {
                return;
            }
            indices[index] = 0;
        }
    }

    private static class UniqueVariationsIterator<T>
    extends CombinationsGenerator.CombinationsIteratorBase<T> {
        public UniqueVariationsIterator(int count, List<T> items) {
            super(count, items);
        }

        @Override
        protected void init() {
            this.indices = new int[this.count];
            int i = 0;
            while (i < this.indices.length) {
                this.indices[i] = -1;
                this.computeNextIndices(this.indices, i);
                ++i;
            }
        }

        @Override
        protected void computeNextIndices(int[] indices, int index) {
            if (index < 0) {
                this.hasNext = false;
                return;
            }
            do {
                int n = index;
                indices[n] = indices[n] + 1;
            } while (!this.isIndexUniqueToPrevious(indices, index));
            if (indices[index] < this.items.size()) {
                return;
            }
            this.computeNextIndices(indices, index - 1);
            if (!this.hasNext) {
                return;
            }
            indices[index] = -1;
            do {
                int n = index;
                indices[n] = indices[n] + 1;
            } while (!this.isIndexUniqueToPrevious(indices, index));
            if (indices[index] < this.items.size()) {
                return;
            }
            this.hasNext = false;
        }

        private boolean isIndexUniqueToPrevious(int[] indices, int index) {
            int i = index - 1;
            while (i >= 0) {
                if (indices[i] == indices[index]) {
                    return false;
                }
                --i;
            }
            return true;
        }
    }
}

