/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui.view;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.components.CSprite;
import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.prefabs.Entity;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import cz.cuni.amis.clear2d.engine.tween.TweenEase;
import cz.cuni.amis.clear2d.engine.tween.pos.ITweenPosCallback;
import cz.cuni.amis.clear2d.engine.tween.pos.TweenPos;
import cz.cuni.amis.clear2d.engine.tween.pos.TweenPosType;
import cz.dd4j.agents.IHeroAgent;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.ui.gui.c2d.Ctx;
import cz.dd4j.ui.gui.view.CDeath;
import cz.dd4j.ui.gui.view.CMovement;
import cz.dd4j.ui.gui.view.CMovementCtrl;
import cz.dd4j.ui.gui.view.MonsterView;
import cz.dd4j.ui.gui.view.RoomView;
import cz.dd4j.ui.gui.view.RoomsView;

public class HeroView
extends Entity {
    public CSprite sword;
    public AgentMindBody<Hero, IHeroAgent> hero;
    public CMovement movement;
    public CMovementCtrl movementCtrl;
    public CDeath deathAnim;

    public HeroView(AgentMindBody<Hero, IHeroAgent> hero, RoomsView roomsView) {
        this(hero, (IDrawable)Ctx.texHero, (IDrawable)Ctx.texSword, roomsView);
    }

    public HeroView(AgentMindBody<Hero, IHeroAgent> hero, IDrawable texHero, IDrawable texSword, RoomsView roomsView) {
        super(texHero);
        this.hero = hero;
        this.sword = new CSprite((SceneElement)this, texSword);
        this.sword.pos.x = 15.0f;
        this.sword.pos.y = 3.0f;
        this.sword.setEnabled(false);
        this.movement = new CMovement(this);
        this.movementCtrl = new CMovementCtrl(this, hero.body, roomsView, this.movement);
        this.movementCtrl.roomViewX = 8;
        this.movementCtrl.roomViewY = 25;
        this.movementCtrl.corridorViewX = 0;
        this.movementCtrl.corridorViewY = 0;
        this.deathAnim = new CDeath(this);
    }

    public void animateDeath() {
        this.deathAnim.doIt();
        this.sword.setEnabled(false);
    }

    public TweenPos attack(final MonsterView entity) {
        TweenPos tween = new TweenPos(this.pos, entity.pos, TweenPosType.TIME, 0.3f, TweenEase.LINEAR);
        tween.onPlayed = new ITweenPosCallback(){

            public void run(TweenPos tween) {
                entity.animateDeath();
                tween.reverse();
            }
        };
        tween.play();
        return tween;
    }

    public TweenPos pickupSword(final RoomView room) {
        TweenPos tween = new TweenPos(this.pos, room.pos.add(room.sword.pos).add(-8.0f, 5.0f), TweenPosType.TIME, 0.3f, TweenEase.LINEAR);
        tween.onPlayed = new ITweenPosCallback(){

            public void run(TweenPos tween) {
                room.sword.setEnabled(false);
                HeroView.this.sword.setEnabled(true);
                tween.reverse();
            }
        };
        tween.play();
        return tween;
    }

    public TweenPos dropSword(final RoomView room) {
        TweenPos tween = new TweenPos(this.pos, room.pos.add(room.sword.pos).add(-8.0f, 5.0f), TweenPosType.TIME, 0.3f, TweenEase.LINEAR);
        tween.onPlayed = new ITweenPosCallback(){

            public void run(TweenPos tween) {
                room.sword.setEnabled(true);
                HeroView.this.sword.setEnabled(false);
                tween.reverse();
            }
        };
        tween.play();
        return tween;
    }

    public TweenPos attackTrap(final RoomView room) {
        TweenPos tween = new TweenPos(this.pos, room.pos.add(room.trap.pos), TweenPosType.TIME, 0.3f, TweenEase.LINEAR);
        tween.onPlayed = new ITweenPosCallback(){

            public void run(TweenPos tween) {
                room.setTrap(false);
                tween.reverse();
            }
        };
        tween.play();
        return tween;
    }

    public void tick(C2DTime time) {
    }
}

