/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui;

import cz.dd4j.agents.HeroAgentBase;
import cz.dd4j.agents.IHeroAgent;
import cz.dd4j.agents.commands.Command;
import cz.dd4j.domain.EElement;
import cz.dd4j.domain.EItem;
import cz.dd4j.simulation.actions.EAction;
import cz.dd4j.simulation.data.dungeon.Dungeon;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.astar.AStar;
import cz.dd4j.utils.astar.IAStarHeuristic;
import cz.dd4j.utils.astar.IAStarView;
import cz.dd4j.utils.astar.Path;
import cz.dd4j.utils.astar.graph.INode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MockHero2
extends HeroAgentBase
implements IHeroAgent {
    private Command moveIntention;
    private Dungeon myDungeon;
    private Room goalRoom;
    private boolean needSword;
    private long monsterCount;

    int distToClosestSword(Room from, List<Room> swordRooms, AStar<Room> astar) {
        Path p;
        int minDist = Integer.MAX_VALUE;
        for (Room r : swordRooms) {
            p = astar.findPath((INode)from, (INode)r, new IAStarView(){

                public boolean isOpened(Object o) {
                    return ((Room)o).monster == null;
                }
            });
            if (p == null) continue;
            minDist = Math.min(minDist, p.getDistanceNodes());
        }
        if (minDist == Integer.MAX_VALUE) {
            for (Room r : swordRooms) {
                p = astar.findPath((INode)from, (INode)r);
                if (p == null) continue;
                minDist = Math.min(minDist, p.getDistanceNodes());
            }
        }
        return minDist;
    }

    public Command act() {
        if (this.hero.atRoom.monster != null && this.hero.hand != null && this.hero.hand.type == EItem.SWORD) {
            return this.actions.attack();
        }
        if (this.hero.atRoom.feature != null && this.hero.hand == null) {
            return this.actions.disarm();
        }
        if (this.moveIntention == null && this.hero.atRoom.item != null) {
            return this.actions.pickup();
        }
        this.needSword = this.monsterCount > 0L && (this.hero.hand == null || this.hero.hand.type != EItem.SWORD);
        final ArrayList<Room> swordRooms = new ArrayList<Room>();
        for (Room r : this.myDungeon.rooms.values()) {
            if (r.item == null) continue;
            swordRooms.add(r);
        }
        List moveActions = this.actionsGenerator.generateFor((Entity)this.hero, EAction.MOVE);
        final AStar aStar = new AStar((IAStarHeuristic)new IAStarHeuristic<Room>(){

            public int getEstimate(Room n1, Room n2) {
                return 0;
            }
        });
        if (this.needSword) {
            Collections.sort(moveActions, new Comparator<Command>(){

                @Override
                public int compare(Command o1, Command o2) {
                    int d1 = MockHero2.this.distToClosestSword((Room)o1.target, swordRooms, (AStar<Room>)aStar);
                    int d2 = MockHero2.this.distToClosestSword((Room)o2.target, swordRooms, (AStar<Room>)aStar);
                    return Integer.compare(d1, d2);
                }
            });
        } else {
            Collections.sort(moveActions, new Comparator<Command>(){

                @Override
                public int compare(Command o1, Command o2) {
                    Path p1 = aStar.findPath((INode)((Room)o1.target), (INode)MockHero2.this.goalRoom);
                    Path p2 = aStar.findPath((INode)((Room)o2.target), (INode)MockHero2.this.goalRoom);
                    int d1 = p1 != null ? p1.getDistanceNodes() : Integer.MAX_VALUE;
                    int d2 = p2 != null ? p2.getDistanceNodes() : Integer.MAX_VALUE;
                    return Integer.compare(d1, d2);
                }
            });
        }
        while (moveActions.size() > 0) {
            if (this.moveIntention == null) {
                this.moveIntention = (Command)moveActions.remove(0);
            }
            Room target = (Room)this.moveIntention.target;
            if (target.feature != null && this.hero.hand != null) {
                return this.actions.drop();
            }
            if (target.monster != null && this.hero.hand == null) {
                if (this.hero.atRoom.item != null && this.hero.atRoom.item.isA((EElement)EItem.SWORD)) {
                    return this.actions.pickup();
                }
                this.moveIntention = null;
                continue;
            }
            Command moveAction = this.moveIntention;
            this.moveIntention = null;
            return moveAction;
        }
        return null;
    }

    public void observeDungeon(Dungeon dungeon, boolean full, long timestampMillis) {
        this.myDungeon = dungeon;
        this.monsterCount = 0L;
        for (Room r : dungeon.rooms.values()) {
            if (this.goalRoom == null && r.isGoalRoom()) {
                this.goalRoom = r;
            }
            if (r.monster == null) continue;
            ++this.monsterCount;
        }
    }
}

