/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.dd4j.agents.IHeroAgent;
import cz.dd4j.loader.agents.AgentsLoader;
import cz.dd4j.loader.simstate.SimStateLoader;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.agents.Agents;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.ui.gui.DD4JFrame;
import cz.dd4j.ui.gui.c2d.Ctx;
import cz.dd4j.ui.gui.view.HeroView;
import cz.dd4j.ui.gui.view.MonsterView;
import cz.dd4j.ui.gui.view.RoomsView;
import java.io.File;
import java.util.HashMap;
import java.util.Random;

public class Test07_Movement {
    public static final Random random = new Random(1L);

    public static void main(String[] args) {
        SimStateLoader loader = new SimStateLoader();
        SimState simState = loader.loadSimState(new File("./example/Adventure.xml"), true);
        Ctx.init();
        DD4JFrame frame = new DD4JFrame();
        RoomsView roomsView = new RoomsView(simState);
        frame.dungeon.scene.root.addChild((SceneElement)roomsView);
        HashMap<Monster, MonsterView> monsterViews = new HashMap<Monster, MonsterView>();
        for (AgentMindBody monster : simState.monsters.values()) {
            MonsterView monsterView = new MonsterView(monster, roomsView);
            roomsView.addChild((SceneElement)monsterView);
            monsterViews.put((Monster)monster.body, monsterView);
        }
        File heroesFile = new File("./example/hero-test.xml");
        AgentsLoader heroesLoader = new AgentsLoader();
        Agents heroes = heroesLoader.loadAgents(heroesFile);
        for (AgentMindBody hero : simState.heroes.values()) {
            if (!heroes.agents.containsKey(((Hero)hero.body).id)) {
                throw new RuntimeException("Cannot bind mind into hero body for Hero[id=" + ((Hero)hero.body).id + "], " + ((Hero)hero.body).id + " not found in 'heroes'.");
            }
            hero.mind = (IHeroAgent)heroes.agents.get(((Hero)hero.body).id);
        }
        HashMap<Hero, HeroView> heroViews = new HashMap<Hero, HeroView>();
        for (AgentMindBody hero : simState.heroes.values()) {
            HeroView heroView = new HeroView(hero, roomsView);
            roomsView.addChild((SceneElement)heroView);
            heroViews.put((Hero)hero.body, heroView);
        }
        frame.setVisible(true);
        while (true) {
            Hero body;
            int entitiesCount;
            int entityNum;
            if ((entityNum = random.nextInt(entitiesCount = simState.heroes.size() + simState.monsters.size())) == 0) {
                body = (Hero)((AgentMindBody)simState.heroes.values().iterator().next()).body;
                Test07_Movement.makeHeroMove(body, (HeroView)heroViews.get(body));
            } else {
                body = (Monster)((AgentMindBody)simState.monsters.values().toArray()[entityNum - 1]).body;
                Test07_Movement.makeMonsterMove((Monster)body, (MonsterView)monsterViews.get(body));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    private static void makeMonsterMove(Monster body, MonsterView monsterView) {
        Corridor corridor = null;
        int i = 0;
        while (i < 10 && corridor == null) {
            int corridorIndex = random.nextInt(body.atRoom.corridors.size());
            corridor = (Corridor)body.atRoom.corridors.get(corridorIndex);
            if (corridor.monster != null || corridor.getOther((Room)body.atRoom).monster != null) {
                corridor = null;
            }
            ++i;
        }
        if (corridor == null) {
            return;
        }
        Room fromRoom = body.atRoom;
        body.atRoom.monster = null;
        body.atRoom = null;
        body.atCorridor = corridor;
        body.atCorridor.monster = body;
        while (monsterView.movementCtrl.currentCorridor != corridor) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        body.atRoom = corridor.getOther(fromRoom);
        body.atRoom.monster = body;
        body.atCorridor.monster = null;
        body.atCorridor = null;
        while (monsterView.movementCtrl.currentRoom != body.atRoom) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void makeHeroMove(Hero body, HeroView heroView) {
        Corridor corridor = null;
        int i = 0;
        while (i < 10 && corridor == null) {
            int corridorIndex = random.nextInt(body.atRoom.corridors.size());
            corridor = (Corridor)body.atRoom.corridors.get(corridorIndex);
            if (corridor.hero != null || corridor.getOther((Room)body.atRoom).hero != null) {
                corridor = null;
            }
            ++i;
        }
        if (corridor == null) {
            return;
        }
        Room fromRoom = body.atRoom;
        body.atRoom.hero = null;
        body.atRoom = null;
        body.atCorridor = corridor;
        body.atCorridor.hero = body;
        while (heroView.movementCtrl.currentCorridor != corridor) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        body.atRoom = corridor.getOther(fromRoom);
        body.atRoom.hero = body;
        body.atCorridor.hero = null;
        body.atCorridor = null;
        while (heroView.movementCtrl.currentRoom != body.atRoom) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

