/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.tween.pos.TweenPos;
import cz.dd4j.agents.IHeroAgent;
import cz.dd4j.domain.EElement;
import cz.dd4j.domain.EItem;
import cz.dd4j.loader.agents.AgentsLoader;
import cz.dd4j.loader.simstate.SimStateLoader;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.agents.Agents;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.ui.gui.DD4JFrame;
import cz.dd4j.ui.gui.c2d.Ctx;
import cz.dd4j.ui.gui.utils.BusyWait;
import cz.dd4j.ui.gui.utils.IWaiting;
import cz.dd4j.ui.gui.view.HeroView;
import cz.dd4j.ui.gui.view.MonsterView;
import cz.dd4j.ui.gui.view.RoomView;
import cz.dd4j.ui.gui.view.RoomsView;
import java.io.File;
import java.util.HashMap;
import java.util.Random;

public class Test09_SwordPickup {
    public static final Random random = new Random(1L);

    public static void main(String[] args) {
        SimStateLoader loader = new SimStateLoader();
        SimState simState = loader.loadSimState(new File("./example/Adventure.xml"), true);
        Ctx.init();
        DD4JFrame frame = new DD4JFrame();
        RoomsView roomsView = new RoomsView(simState);
        frame.dungeon.scene.root.addChild((SceneElement)roomsView);
        HashMap<Monster, MonsterView> monsterViews = new HashMap<Monster, MonsterView>();
        for (AgentMindBody monster : simState.monsters.values()) {
            MonsterView monsterView = new MonsterView(monster, roomsView);
            roomsView.addChild((SceneElement)monsterView);
            monsterViews.put((Monster)monster.body, monsterView);
        }
        File heroesFile = new File("./example/hero-test.xml");
        AgentsLoader heroesLoader = new AgentsLoader();
        Agents heroes = heroesLoader.loadAgents(heroesFile);
        for (AgentMindBody hero : simState.heroes.values()) {
            if (!heroes.agents.containsKey(((Hero)hero.body).id)) {
                throw new RuntimeException("Cannot bind mind into hero body for Hero[id=" + ((Hero)hero.body).id + "], " + ((Hero)hero.body).id + " not found in 'heroes'.");
            }
            hero.mind = (IHeroAgent)heroes.agents.get(((Hero)hero.body).id);
        }
        HashMap<Hero, HeroView> heroViews = new HashMap<Hero, HeroView>();
        for (AgentMindBody hero : simState.heroes.values()) {
            HeroView heroView = new HeroView(hero, roomsView);
            roomsView.addChild((SceneElement)heroView);
            heroViews.put((Hero)hero.body, heroView);
        }
        frame.setVisible(true);
        while (true) {
            int entitiesCount;
            int entityNum;
            if ((entityNum = random.nextInt(entitiesCount = simState.heroes.size() + simState.monsters.size())) == 0) {
                Hero heroBody = (Hero)((AgentMindBody)simState.heroes.values().iterator().next()).body;
                if (heroBody.atRoom.item != null && heroBody.hand == null && heroBody.atRoom.item.isA((EElement)EItem.SWORD)) {
                    Test09_SwordPickup.makeHeroPickupSword(heroBody, (HeroView)heroViews.get(heroBody), roomsView.getRoomView(heroBody.atRoom.id));
                } else if (heroBody.atRoom.monster != null && heroBody.hand != null && heroBody.hand.isA((EElement)EItem.SWORD)) {
                    Test09_SwordPickup.makeHeroAttack(heroBody, (HeroView)heroViews.get(heroBody), heroBody.atRoom.monster, (MonsterView)monsterViews.get(heroBody.atRoom.monster));
                    simState.monsters.remove(heroBody.atRoom.monster.id);
                    heroBody.atRoom.monster = null;
                } else {
                    Test09_SwordPickup.makeHeroMove(heroBody, (HeroView)heroViews.get(heroBody));
                }
            } else {
                Monster body = (Monster)((AgentMindBody)simState.monsters.values().toArray()[entityNum - 1]).body;
                if (body.atRoom.hero != null) {
                    Hero heroBody = (Hero)((AgentMindBody)simState.heroes.values().iterator().next()).body;
                    if (heroBody.hand != null && heroBody.hand.isA((EElement)EItem.SWORD)) {
                        Test09_SwordPickup.makeHeroAttack(heroBody, (HeroView)heroViews.get(heroBody), heroBody.atRoom.monster, (MonsterView)monsterViews.get(heroBody.atRoom.monster));
                        simState.monsters.remove(heroBody.atRoom.monster.id);
                        heroBody.atRoom.monster = null;
                    } else {
                        Test09_SwordPickup.makeMonsterMove(body, (MonsterView)monsterViews.get(body));
                    }
                } else {
                    Test09_SwordPickup.makeMonsterMove(body, (MonsterView)monsterViews.get(body));
                }
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    private static void makeHeroPickupSword(Hero heroBody, HeroView heroView, RoomView roomView) {
        final TweenPos tween = heroView.pickupSword(roomView);
        new BusyWait(new IWaiting(){

            public boolean isWaiting() {
                return tween.isTweening();
            }
        }).busyWait();
        heroBody.hand = roomView.room.item;
        roomView.room.item = null;
    }

    private static void makeHeroAttack(Hero body, HeroView heroView, Monster monster, MonsterView monsterView) {
        final TweenPos tween = heroView.attack(monsterView);
        new BusyWait(new IWaiting(){

            public boolean isWaiting() {
                return tween.isTweening();
            }
        }).busyWait();
        monster.alive = false;
    }

    private static void makeMonsterMove(Monster body, MonsterView monsterView) {
        Corridor corridor = null;
        int i = 0;
        while (i < 10 && corridor == null) {
            int corridorIndex = random.nextInt(body.atRoom.corridors.size());
            corridor = (Corridor)body.atRoom.corridors.get(corridorIndex);
            if (corridor.monster != null || corridor.getOther((Room)body.atRoom).monster != null) {
                corridor = null;
            }
            ++i;
        }
        if (corridor == null) {
            return;
        }
        Room fromRoom = body.atRoom;
        body.atRoom.monster = null;
        body.atRoom = null;
        body.atCorridor = corridor;
        body.atCorridor.monster = body;
        while (monsterView.movementCtrl.currentCorridor != corridor) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        body.atRoom = corridor.getOther(fromRoom);
        body.atRoom.monster = body;
        body.atCorridor.monster = null;
        body.atCorridor = null;
        while (monsterView.movementCtrl.currentRoom != body.atRoom) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void makeHeroMove(Hero body, HeroView heroView) {
        Corridor corridor = null;
        int i = 0;
        while (i < 10 && corridor == null) {
            int corridorIndex = random.nextInt(body.atRoom.corridors.size());
            corridor = (Corridor)body.atRoom.corridors.get(corridorIndex);
            if (corridor.hero != null || corridor.getOther((Room)body.atRoom).hero != null) {
                corridor = null;
            }
            ++i;
        }
        if (corridor == null) {
            return;
        }
        Room fromRoom = body.atRoom;
        body.atRoom.hero = null;
        body.atRoom = null;
        body.atCorridor = corridor;
        body.atCorridor.hero = body;
        while (heroView.movementCtrl.currentCorridor != corridor) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        body.atRoom = corridor.getOther(fromRoom);
        body.atRoom.hero = body;
        body.atCorridor.hero = null;
        body.atCorridor = null;
        while (heroView.movementCtrl.currentRoom != body.atRoom) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

