/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui;

import cz.cuni.amis.clear2d.engine.tween.pos.TweenPos;
import cz.dd4j.domain.EElement;
import cz.dd4j.domain.EItem;
import cz.dd4j.loader.simstate.SimStateLoader;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.entities.Hero;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.entities.features.Trap;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.ui.gui.DD4JVis;
import cz.dd4j.ui.gui.c2d.Ctx;
import cz.dd4j.ui.gui.utils.BusyWait;
import cz.dd4j.ui.gui.utils.IWaiting;
import cz.dd4j.ui.gui.view.HeroView;
import cz.dd4j.ui.gui.view.MonsterView;
import cz.dd4j.ui.gui.view.RoomView;
import java.io.File;
import java.util.Random;

public class Test13_DD4JVis {
    public static final Random random = new Random(1L);

    public static void main(String[] args) {
        SimStateLoader loader = new SimStateLoader();
        SimState simState = loader.loadSimState(new File("./example/Adventure.xml"), true);
        Ctx.init();
        DD4JVis vis = new DD4JVis(simState, null);
        vis.frame.setVisible(true);
        while (true) {
            int entitiesCount = simState.heroes.size() + simState.monsters.size() + simState.features.size();
            for (AgentMindBody trap : simState.features.values()) {
                if (((Feature)trap.body).alive && ((Feature)trap.body).atRoom.monster != null) continue;
                --entitiesCount;
            }
            int entityNum = random.nextInt(entitiesCount);
            if (entityNum == 0) {
                Hero heroBody = (Hero)((AgentMindBody)simState.heroes.values().iterator().next()).body;
                if (heroBody.atRoom.feature != null && heroBody.atRoom.feature.alive && heroBody.hand != null && heroBody.atRoom.item == null) {
                    Test13_DD4JVis.makeHeroDropSword(heroBody, (HeroView)vis.heroViews.get(heroBody), vis.roomsView.getRoomView(heroBody.atRoom.id));
                } else if (heroBody.atRoom.feature != null && heroBody.atRoom.feature.alive && heroBody.hand == null) {
                    Test13_DD4JVis.makeHeroAttackTrap(heroBody, (HeroView)vis.heroViews.get(heroBody), vis.roomsView.getRoomView(heroBody.atRoom.id));
                } else if (heroBody.atRoom.item != null && heroBody.hand == null && heroBody.atRoom.item.isA((EElement)EItem.SWORD)) {
                    Test13_DD4JVis.makeHeroPickupSword(heroBody, (HeroView)vis.heroViews.get(heroBody), vis.roomsView.getRoomView(heroBody.atRoom.id));
                } else if (heroBody.atRoom.monster != null && heroBody.hand != null && heroBody.hand.isA((EElement)EItem.SWORD)) {
                    Test13_DD4JVis.makeHeroAttack(heroBody, (HeroView)vis.heroViews.get(heroBody), heroBody.atRoom.monster, (MonsterView)vis.monsterViews.get(heroBody.atRoom.monster));
                    simState.monsters.remove(heroBody.atRoom.monster.id);
                    heroBody.atRoom.monster = null;
                } else if (heroBody.atRoom.item == null && heroBody.hand != null && heroBody.hand.isA((EElement)EItem.SWORD) && random.nextDouble() > 0.75) {
                    Test13_DD4JVis.makeHeroDropSword(heroBody, (HeroView)vis.heroViews.get(heroBody), vis.roomsView.getRoomView(heroBody.atRoom.id));
                } else {
                    Test13_DD4JVis.makeHeroMove(heroBody, (HeroView)vis.heroViews.get(heroBody));
                }
            } else if (--entityNum < simState.monsters.size()) {
                Monster body = (Monster)((AgentMindBody)simState.monsters.values().toArray()[entityNum]).body;
                if (body.atRoom.hero != null) {
                    Hero heroBody = (Hero)((AgentMindBody)simState.heroes.values().iterator().next()).body;
                    if (heroBody.hand != null && heroBody.hand.isA((EElement)EItem.SWORD)) {
                        Test13_DD4JVis.makeHeroAttack(heroBody, (HeroView)vis.heroViews.get(heroBody), heroBody.atRoom.monster, (MonsterView)vis.monsterViews.get(heroBody.atRoom.monster));
                        simState.monsters.remove(heroBody.atRoom.monster.id);
                        heroBody.atRoom.monster = null;
                    } else {
                        Test13_DD4JVis.makeMonsterMove(body, (MonsterView)vis.monsterViews.get(body));
                    }
                } else {
                    Test13_DD4JVis.makeMonsterMove(body, (MonsterView)vis.monsterViews.get(body));
                }
            } else if ((entityNum -= simState.monsters.size()) < simState.features.size()) {
                Trap trapBody = (Trap)((AgentMindBody)simState.features.values().toArray()[entityNum]).body;
                if (trapBody.alive && trapBody.atRoom.monster != null) {
                    Test13_DD4JVis.makeTrapAttack(trapBody, vis.roomsView.getRoomView(trapBody.atRoom.id), trapBody.atRoom.monster, (MonsterView)vis.monsterViews.get(trapBody.atRoom.monster));
                    simState.monsters.remove(trapBody.atRoom.monster.id);
                    trapBody.atRoom.monster = null;
                }
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    private static void makeTrapAttack(Trap trapBody, RoomView roomView, Monster monster, MonsterView monsterView) {
        final TweenPos tween = roomView.trap.attack(monsterView);
        new BusyWait(new IWaiting(){

            public boolean isWaiting() {
                return tween.isTweening();
            }
        }).busyWait();
        monster.alive = false;
    }

    private static void makeHeroAttackTrap(Hero heroBody, HeroView heroView, RoomView roomView) {
        final TweenPos tween = heroView.attackTrap(roomView);
        new BusyWait(new IWaiting(){

            public boolean isWaiting() {
                return tween.isTweening();
            }
        }).busyWait();
        roomView.room.feature.alive = false;
    }

    private static void makeHeroDropSword(Hero heroBody, HeroView heroView, RoomView roomView) {
        final TweenPos tween = heroView.dropSword(roomView);
        new BusyWait(new IWaiting(){

            public boolean isWaiting() {
                return tween.isTweening();
            }
        }).busyWait();
        roomView.room.item = heroBody.hand;
        heroBody.hand = null;
    }

    private static void makeHeroPickupSword(Hero heroBody, HeroView heroView, RoomView roomView) {
        final TweenPos tween = heroView.pickupSword(roomView);
        new BusyWait(new IWaiting(){

            public boolean isWaiting() {
                return tween.isTweening();
            }
        }).busyWait();
        heroBody.hand = roomView.room.item;
        roomView.room.item = null;
    }

    private static void makeHeroAttack(Hero body, HeroView heroView, Monster monster, MonsterView monsterView) {
        final TweenPos tween = heroView.attack(monsterView);
        new BusyWait(new IWaiting(){

            public boolean isWaiting() {
                return tween.isTweening();
            }
        }).busyWait();
        monster.alive = false;
    }

    private static void makeMonsterMove(Monster body, MonsterView monsterView) {
        Corridor corridor = null;
        int i = 0;
        while (i < 10 && corridor == null) {
            int corridorIndex = random.nextInt(body.atRoom.corridors.size());
            corridor = (Corridor)body.atRoom.corridors.get(corridorIndex);
            if (corridor.monster != null || corridor.getOther((Room)body.atRoom).monster != null) {
                corridor = null;
            }
            ++i;
        }
        if (corridor == null) {
            return;
        }
        Room fromRoom = body.atRoom;
        body.atRoom.monster = null;
        body.atRoom = null;
        body.atCorridor = corridor;
        body.atCorridor.monster = body;
        while (monsterView.movementCtrl.currentCorridor != corridor) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        body.atRoom = corridor.getOther(fromRoom);
        body.atRoom.monster = body;
        body.atCorridor.monster = null;
        body.atCorridor = null;
        while (monsterView.movementCtrl.currentRoom != body.atRoom) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void makeHeroMove(Hero body, HeroView heroView) {
        Corridor corridor = null;
        int i = 0;
        while (i < 10 && corridor == null) {
            int corridorIndex = random.nextInt(body.atRoom.corridors.size());
            corridor = (Corridor)body.atRoom.corridors.get(corridorIndex);
            if (corridor.hero != null || corridor.getOther((Room)body.atRoom).hero != null) {
                corridor = null;
            }
            ++i;
        }
        if (corridor == null) {
            return;
        }
        Room fromRoom = body.atRoom;
        body.atRoom.hero = null;
        body.atRoom = null;
        body.atCorridor = corridor;
        body.atCorridor.hero = body;
        while (heroView.movementCtrl.currentCorridor != corridor) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        body.atRoom = corridor.getOther(fromRoom);
        body.atRoom.hero = body;
        body.atCorridor.hero = null;
        body.atCorridor = null;
        while (heroView.movementCtrl.currentRoom != body.atRoom) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

