/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui;

import cz.cuni.amis.clear2d.engine.C2DPanelStandalone;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DD4JFrame
extends JFrame {
    private FrameComponentListener componentListener = new FrameComponentListener();
    public C2DPanelStandalone dungeon;
    public JTextArea log;
    public int logLines = 0;
    public JScrollPane logScroll;

    public DD4JFrame() {
        this(800, 600);
    }

    public DD4JFrame(int c2dWidth, int c2dHeight) {
        this.setTitle("DarkDungeon4J");
        this.setDefaultCloseOperation(1);
        int frameWidth = c2dWidth;
        if (c2dWidth < 800) {
            frameWidth = 800;
        }
        this.setSize(frameWidth + 16, c2dHeight + 39 + 150);
        this.setLayout(null);
        this.dungeon = new C2DPanelStandalone(c2dWidth, c2dHeight, Color.BLACK);
        this.add((Component)this.dungeon);
        this.log = new JTextArea();
        this.log.setFont(Font.decode("Consolas-10"));
        this.log.setEditable(false);
        this.logScroll = new JScrollPane(this.log);
        this.logScroll.setVerticalScrollBarPolicy(20);
        this.add(this.logScroll);
        this.addComponentListener(this.componentListener);
        this.onResize();
    }

    private void onResize() {
        int w = this.getContentPane().getWidth();
        int h = this.getContentPane().getHeight();
        if (h > 300) {
            this.dungeon.setBounds(0, 0, w, h - 150);
            this.logScroll.setBounds(0, h - 150, w, 150);
        } else {
            int dH = h / 2;
            this.dungeon.setBounds(0, 0, w, dH);
            this.logScroll.setBounds(0, dH, w, h - dH);
        }
    }

    public void log(String msg) {
        String text = String.valueOf(this.log.getText()) + "\n" + msg;
        ++this.logLines;
        while (this.logLines > 100) {
            int index = text.indexOf(10);
            if (index < 0) {
                this.logLines = 0;
                break;
            }
            text = text.substring(index + 1);
            --this.logLines;
        }
        this.log.setText(text);
        this.log.setCaretPosition(this.log.getText().length());
        JScrollBar vertical = this.logScroll.getVerticalScrollBar();
        if (vertical != null) {
            vertical.setValue(vertical.getMaximum());
        }
    }

    public void die() {
        this.dungeon.die();
    }

    private class FrameComponentListener
    extends ComponentAdapter {
        private FrameComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DD4JFrame.this.onResize();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

