/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui.view;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.components.CTick;
import cz.cuni.amis.clear2d.engine.prefabs.Entity;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import java.util.Random;

public class CMovement
extends CTick {
    private static Random random = new Random(System.currentTimeMillis());
    public float targetX;
    public float targetY;
    public boolean animating = false;
    public float speedPerSec = 10.0f;
    private int animatingComponents = 0;

    public CMovement(Entity owner) {
        super((SceneElement)owner);
    }

    public void setTarget(float newTargetX, float newTargetY) {
        this.targetX = newTargetX;
        this.targetY = newTargetY;
        int animatingComponents = 0;
        if (Math.abs(this.owner.pos.x - this.targetX) < 1.0f) {
            this.owner.pos.x = this.targetX;
        } else {
            ++animatingComponents;
        }
        if (Math.abs(this.owner.pos.y - this.targetY) < 1.0f) {
            this.owner.pos.y = this.targetY;
        } else {
            ++animatingComponents;
        }
        this.animating = animatingComponents > 0;
    }

    public void tick(C2DTime time) {
        if (!this.animating) {
            return;
        }
        int animatingComponents = 0;
        if (Math.abs(this.owner.pos.x - this.targetX) < 1.0f) {
            this.owner.pos.x = this.targetX;
        } else {
            this.owner.pos.x += (this.targetX - this.owner.pos.x) * Math.min(1.0f, this.speedPerSec * time.game.delta);
            ++animatingComponents;
        }
        if (Math.abs(this.owner.pos.y - this.targetY) < 1.0f) {
            this.owner.pos.y = this.targetY;
        } else {
            this.owner.pos.y += (this.targetY - this.owner.pos.y) * Math.min(1.0f, this.speedPerSec * time.game.delta);
            ++animatingComponents;
        }
        if (animatingComponents == 0) {
            this.animating = false;
        }
    }
}

