/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui.view;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.components.CSprite;
import cz.cuni.amis.clear2d.engine.components.CTick;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.places.Corridor;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.ui.gui.view.CMovement;
import cz.dd4j.ui.gui.view.RoomView;
import cz.dd4j.ui.gui.view.RoomsView;
import java.util.Random;

public class CMovementCtrl
extends CTick {
    private static Random random = new Random(System.currentTimeMillis());
    private Entity body;
    private RoomsView roomsView;
    public Room currentRoom;
    public Corridor currentCorridor;
    public int roomViewX = 32;
    public int roomViewY = 32;
    public int corridorViewX = 0;
    public int corridorViewY = 0;
    public boolean animating = false;
    private CMovement movement;

    public CMovementCtrl(cz.cuni.amis.clear2d.engine.prefabs.Entity owner, Entity body, RoomsView roomsView, CMovement movement) {
        super((SceneElement)owner);
        this.body = body;
        this.roomsView = roomsView;
        this.movement = movement;
    }

    public void tick(C2DTime time) {
        boolean alive;
        boolean bl = alive = this.body != null && this.body != null && this.body.alive;
        if (!alive) {
            this.movement.animating = false;
            return;
        }
        if (this.currentRoom == null && this.currentCorridor == null) {
            if (this.body.atRoom != null) {
                this.initPosition(this.body.atRoom);
                return;
            }
            if (this.body.atCorridor != null) {
                this.initPosition(this.body.atCorridor);
                return;
            }
        } else if (this.currentRoom != null) {
            if (this.body.atRoom != null && this.currentRoom != this.body.atRoom) {
                this.moveToRoom(this.body.atRoom);
                return;
            }
            if (this.body.atCorridor != null) {
                this.moveToCorridor(this.body.atCorridor);
                return;
            }
        } else {
            if (this.body.atRoom != null) {
                this.moveToRoom(this.body.atRoom);
                return;
            }
            if (this.body.atCorridor != null && this.currentCorridor != this.body.atCorridor) {
                this.moveToCorridor(this.body.atCorridor);
                return;
            }
        }
        this.animating = false;
    }

    private void initPosition(Room atRoom) {
        RoomView atRoomView = this.roomsView.getRoomView(atRoom);
        this.owner.pos.x = atRoomView.pos.x + (float)this.roomViewX + (float)random.nextInt(8) - 4.0f;
        this.owner.pos.y = atRoomView.pos.y + (float)this.roomViewY + (float)random.nextInt(8) - 4.0f;
        this.currentRoom = atRoom;
    }

    private void initPosition(Corridor atCorridor) {
        RoomView roomView1 = this.roomsView.getRoomView(atCorridor.room1);
        RoomView roomView2 = this.roomsView.getRoomView(atCorridor.room2);
        float roomView1CenterX = roomView1.pos.x + 40.0f;
        float roomView1CenterY = roomView1.pos.y + 40.0f;
        float roomView2CenterX = roomView2.pos.x + 40.0f;
        float roomView2CenterY = roomView2.pos.y + 40.0f;
        float spriteCorridorX = (roomView1CenterX + roomView2CenterX) / 2.0f + (float)this.corridorViewX - (float)(((CSprite)this.owner.getComponent(CSprite.class)).texture.getWidth() / 2);
        float spriteCorridorY = (roomView1CenterY + roomView2CenterY) / 2.0f + (float)this.corridorViewY - (float)(((CSprite)this.owner.getComponent(CSprite.class)).texture.getHeight() / 2);
        this.owner.pos.x = spriteCorridorX;
        this.owner.pos.y = spriteCorridorY;
    }

    private void moveToRoom(Room toRoom) {
        RoomView roomView = this.roomsView.getRoomView(toRoom);
        this.movement.setTarget(roomView.pos.x + (float)this.roomViewX, roomView.pos.y + (float)this.roomViewY);
        this.animating = this.movement.animating;
        if (!this.animating) {
            this.currentCorridor = null;
            this.currentRoom = toRoom;
        }
    }

    private void moveToCorridor(Corridor toCorridor) {
        this.animating = true;
        RoomView roomView1 = this.roomsView.getRoomView(toCorridor.room1);
        RoomView roomView2 = this.roomsView.getRoomView(toCorridor.room2);
        float roomView1CenterX = roomView1.pos.x + 40.0f;
        float roomView1CenterY = roomView1.pos.y + 40.0f;
        float roomView2CenterX = roomView2.pos.x + 40.0f;
        float roomView2CenterY = roomView2.pos.y + 40.0f;
        float spriteCorridorX = (roomView1CenterX + roomView2CenterX) / 2.0f + (float)this.corridorViewX - (float)(((CSprite)this.owner.getComponent(CSprite.class)).texture.getWidth() / 2);
        float spriteCorridorY = (roomView1CenterY + roomView2CenterY) / 2.0f + (float)this.corridorViewY - (float)(((CSprite)this.owner.getComponent(CSprite.class)).texture.getHeight() / 2);
        this.movement.setTarget(spriteCorridorX, spriteCorridorY);
        this.animating = this.movement.animating;
        if (!this.animating) {
            this.currentCorridor = toCorridor;
            this.currentRoom = null;
        }
    }
}

