/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui.view;

import cz.cuni.amis.clear2d.engine.Component;
import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.clear2d.engine.components.CAnimation;
import cz.cuni.amis.clear2d.engine.components.CLabel;
import cz.cuni.amis.clear2d.engine.components.CSprite;
import cz.cuni.amis.clear2d.engine.components.CTickCallback;
import cz.cuni.amis.clear2d.engine.fonts.C2DFonts;
import cz.cuni.amis.clear2d.engine.iface.IDrawable;
import cz.cuni.amis.clear2d.engine.iface.ITickable;
import cz.cuni.amis.clear2d.engine.prefabs.Grid;
import cz.cuni.amis.clear2d.engine.time.C2DTime;
import cz.dd4j.agents.IFeatureAgent;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.ui.gui.c2d.Ctx;
import cz.dd4j.ui.gui.c2d.TileIndoor;
import cz.dd4j.ui.gui.view.RoomsView;
import cz.dd4j.ui.gui.view.TrapView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RoomView
extends Grid
implements ITickable {
    private static Random random = new Random(1L);
    private List<Component> decoration;
    private CLabel label;
    public CSprite sword;
    public TrapView trap;
    private CTickCallback tick;
    public Room room;
    public int roomX;
    public int roomY;
    public boolean renderDoors = false;

    public RoomView() {
        this(null, 0, 0);
    }

    public RoomView(Room room, int roomX, int roomY) {
        super(16.0f, 16.0f, 5, 5);
        this.room = room;
        this.roomX = roomX;
        this.roomY = roomY;
        this.cells[0][0].texture = Ctx.tileIndoor(TileIndoor.Wall_NW_png);
        this.cells[1][0].texture = Ctx.tileIndoor(TileIndoor.Wall_N_png);
        this.cells[2][0].texture = Ctx.tileIndoor(TileIndoor.Wall_N_png);
        this.cells[3][0].texture = Ctx.tileIndoor(TileIndoor.Wall_N_png);
        this.cells[4][0].texture = Ctx.tileIndoor(TileIndoor.Wall_NE_png);
        this.cells[0][1].texture = Ctx.tileIndoor(TileIndoor.Wall_W_png);
        this.cells[4][1].texture = Ctx.tileIndoor(TileIndoor.Wall_E_png);
        this.cells[0][2].texture = Ctx.tileIndoor(TileIndoor.Wall_W_png);
        this.cells[4][2].texture = Ctx.tileIndoor(TileIndoor.Wall_E_png);
        this.cells[0][3].texture = Ctx.tileIndoor(TileIndoor.Wall_W_png);
        this.cells[4][3].texture = Ctx.tileIndoor(TileIndoor.Wall_E_png);
        this.cells[0][4].texture = Ctx.tileIndoor(TileIndoor.Wall_SW_png);
        this.cells[1][4].texture = Ctx.tileIndoor(TileIndoor.Wall_S_png);
        this.cells[2][4].texture = Ctx.tileIndoor(TileIndoor.Wall_S_png);
        this.cells[3][4].texture = Ctx.tileIndoor(TileIndoor.Wall_S_png);
        this.cells[4][4].texture = Ctx.tileIndoor(TileIndoor.Wall_SE_png);
        this.setSword(true);
        this.setSword(false);
        this.tick = new CTickCallback((SceneElement)this, (ITickable)this);
    }

    public void setLabel(String text) {
        if (this.label == null) {
            this.label = new CLabel((SceneElement)this);
            this.label.initLabel(C2DFonts.inconcolata_bold_8px_white, text, Color.BLACK, Color.GRAY);
            this.label.cText.pos.x += 3.0f;
            this.label.cText.pos.y += 4.0f;
            this.label.cBackground.pos.x += 3.0f;
            this.label.cBackground.pos.y += 3.0f;
        } else if (text == null || text.length() == 0) {
            this.label.setEnabled(false);
        } else {
            this.label.setEnabled(true);
            this.label.setText(text);
        }
    }

    public void setDoorNorth() {
        this.cells[2][0].texture = this.renderDoors ? Ctx.tileIndoor(TileIndoor.Door_png) : null;
        this.cells[2][0].pos.y -= 8.0f;
    }

    public void setDoorSouth() {
        this.cells[1][4].texture = Ctx.tileIndoor(TileIndoor.Wall_NE_png);
        this.cells[2][4].texture = this.renderDoors ? Ctx.tileIndoor(TileIndoor.Door_png) : null;
        this.cells[2][4].pos.y += 8.0f;
        this.cells[3][4].texture = Ctx.tileIndoor(TileIndoor.Wall_NW_png);
    }

    public void setDoorWest() {
        this.cells[0][1].texture = Ctx.tileIndoor(TileIndoor.Wall_SE_png);
        this.cells[0][1].pos.x -= 12.0f;
        this.cells[0][2].texture = this.renderDoors ? Ctx.tileIndoor(TileIndoor.Door_png) : null;
        this.cells[0][2].pos.x -= 14.0f;
        this.cells[0][3].texture = Ctx.tileIndoor(TileIndoor.Wall_NE_png);
        this.cells[0][3].pos.x -= 12.0f;
    }

    public void setDoorEast() {
        this.cells[4][1].texture = Ctx.tileIndoor(TileIndoor.Wall_SW_png);
        this.cells[4][1].pos.x += 12.0f;
        this.cells[4][2].texture = this.renderDoors ? Ctx.tileIndoor(TileIndoor.Door_png) : null;
        this.cells[4][2].pos.x += 14.0f;
        this.cells[4][3].texture = Ctx.tileIndoor(TileIndoor.Wall_NW_png);
        this.cells[4][3].pos.x += 12.0f;
    }

    public void setOpeningNorth() {
        this.cells[2][0].texture = null;
    }

    public void setOpeningSouth() {
        this.cells[1][4].texture = Ctx.tileIndoor(TileIndoor.Wall_NE_png);
        this.cells[2][4].texture = null;
        this.cells[3][4].texture = Ctx.tileIndoor(TileIndoor.Wall_NW_png);
    }

    public void setOpeningWest() {
        this.cells[0][1].texture = Ctx.tileIndoor(TileIndoor.Wall_SE_png);
        this.cells[0][1].pos.x -= 12.0f;
        this.cells[0][2].texture = null;
        this.cells[0][3].texture = Ctx.tileIndoor(TileIndoor.Wall_NE_png);
        this.cells[0][3].pos.x -= 12.0f;
    }

    public void setOpeningEast() {
        this.cells[4][1].texture = Ctx.tileIndoor(TileIndoor.Wall_SW_png);
        this.cells[4][1].pos.x += 12.0f;
        this.cells[4][2].texture = null;
        this.cells[4][3].texture = Ctx.tileIndoor(TileIndoor.Wall_NW_png);
        this.cells[4][3].pos.x += 12.0f;
    }

    public void setRandomDecoration() {
        int carpet = random.nextInt(10);
        switch (carpet) {
            case 1: {
                this.setCarpet1();
                break;
            }
            case 2: {
                this.setCarpet2();
            }
        }
        if (random.nextBoolean()) {
            int bb = random.nextInt(3);
            switch (bb) {
                case 0: {
                    this.setBookshelf();
                    break;
                }
                case 1: {
                    this.setBed();
                    break;
                }
                case 2: {
                    this.setStatue();
                }
            }
        }
        if (random.nextBoolean()) {
            this.setTorch();
        }
    }

    public void setBookshelf() {
        this.addDecorationSprite(3, 5, TileIndoor.Bookshelf_01_png);
        this.addDecorationSprite(18, 5, TileIndoor.Bookshelf_02_png);
        this.addDecorationSprite(3, 21, TileIndoor.Bookshelf_03_png);
        this.addDecorationSprite(18, 21, TileIndoor.Bookshelf_04_png);
    }

    public void setBed() {
        this.addDecorationSprite(10, 1, TileIndoor.Bed_01_png);
        this.addDecorationSprite(10, 17, TileIndoor.Bed_02_png);
    }

    public void setCarpet1() {
        if (this.sword != null && this.sword.enabled) {
            return;
        }
        if (this.trap != null && this.trap.enabled) {
            return;
        }
        this.addDecorationSprite(16, 24, TileIndoor.Carpet1_01_png);
        this.addDecorationSprite(32, 24, TileIndoor.Carpet1_02_png);
        this.addDecorationSprite(48, 24, TileIndoor.Carpet1_03_png);
        this.addDecorationSprite(16, 40, TileIndoor.Carpet1_04_png);
        this.addDecorationSprite(32, 40, TileIndoor.Carpet1_05_png);
        this.addDecorationSprite(48, 40, TileIndoor.Carpet1_06_png);
    }

    public void setCarpet2() {
        if (this.sword != null && this.sword.enabled) {
            return;
        }
        if (this.trap != null && this.trap.enabled) {
            return;
        }
        this.addDecorationSprite(16, 24, TileIndoor.Carpet2_01_png);
        this.addDecorationSprite(32, 24, TileIndoor.Carpet2_02_png);
        this.addDecorationSprite(48, 24, TileIndoor.Carpet2_03_png);
        this.addDecorationSprite(16, 40, TileIndoor.Carpet2_04_png);
        this.addDecorationSprite(32, 40, TileIndoor.Carpet2_05_png);
        this.addDecorationSprite(48, 40, TileIndoor.Carpet2_06_png);
    }

    public void setStatue() {
        this.addDecorationSprite(8, 0, TileIndoor.Knight_01_png);
        this.addDecorationSprite(8, 16, TileIndoor.Knight_02_png);
    }

    public void setTorch() {
        this.addDecorationAnimation(54, 6, 8.0f, TileIndoor.Torch1_01_png, TileIndoor.Torch1_02_png);
    }

    public void setSword(boolean state) {
        if (state) {
            if (this.sword == null) {
                this.sword = new CSprite((SceneElement)this, (IDrawable)Ctx.texSword);
                this.sword.pos.x = 54.0f;
                this.sword.pos.y = 38.0f;
            }
            this.sword.enabled = true;
        } else if (this.sword != null) {
            this.sword.enabled = false;
        }
    }

    public void initTrap(AgentMindBody<Feature, IFeatureAgent> trap) {
        if (this.trap == null) {
            this.trap = new TrapView(trap, (RoomsView)this.parent);
            this.trap.pos.x = 24.0f;
            this.trap.pos.y = 24.0f;
            this.trap.setEnabled(false);
            this.addChild((SceneElement)this.trap);
        }
    }

    public void setTrap(Boolean alive) {
        if (this.trap == null) {
            return;
        }
        if (alive == null) {
            this.trap.setEnabled(false);
            return;
        }
        this.trap.setEnabled(true);
        this.trap.cSprite.texture = alive != false ? Ctx.texTrap : Ctx.texTrapDestroyed;
    }

    public void setStaircase() {
        this.addDecorationSprite(32, 32, (IDrawable)Ctx.subtexExit);
    }

    private void addDecorationSprite(int x, int y, TileIndoor tile) {
        this.addDecorationSprite(x, y, (IDrawable)Ctx.tileIndoor(tile));
    }

    private void addDecorationSprite(int x, int y, IDrawable tile) {
        if (this.decoration == null) {
            this.decoration = new ArrayList<Component>();
        }
        CSprite sprite = new CSprite((SceneElement)this, tile);
        sprite.pos.x = x;
        sprite.pos.y = y;
        this.decoration.add((Component)sprite);
    }

    private void addDecorationAnimation(int x, int y, float fps, TileIndoor ... tiles) {
        if (this.decoration == null) {
            this.decoration = new ArrayList<Component>();
        }
        CAnimation animation = new CAnimation((SceneElement)this);
        IDrawable[] frames = new IDrawable[tiles.length];
        int i = 0;
        while (i < tiles.length) {
            frames[i] = Ctx.tileIndoor(tiles[i]);
            ++i;
        }
        animation.initAnimation(fps, frames);
        animation.pos.x = x;
        animation.pos.y = y;
        this.decoration.add((Component)animation);
    }

    public void tick(C2DTime time) {
        if (this.room.feature == null) {
            this.setTrap(null);
        }
    }
}

