/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.ui.gui.view;

import cz.cuni.amis.clear2d.engine.SceneElement;
import cz.cuni.amis.utils.eh4j.shortcut.EH;
import cz.dd4j.agents.IFeatureAgent;
import cz.dd4j.domain.EDungeonLabel;
import cz.dd4j.domain.EFeature;
import cz.dd4j.domain.EItem;
import cz.dd4j.domain.ELabel;
import cz.dd4j.domain.ERoomLabel;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.ui.gui.view.RoomView;
import cz.dd4j.utils.Id;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RoomsView
extends SceneElement {
    private SimState state;
    private int width;
    private int height;
    private int roomsCount;
    public Map<Id, RoomView> rooms = new HashMap<Id, RoomView>();
    private String topology;

    public RoomsView(SimState state) {
        this.state = state;
        this.topology = state.dungeon.labels.getString((ELabel)EDungeonLabel.TOPOLOGY_TYPE);
        this.width = state.dungeon.labels.getInt((ELabel)EDungeonLabel.TOPOLOGY_ROOMS_WIDTH);
        this.height = state.dungeon.labels.getInt((ELabel)EDungeonLabel.TOPOLOGY_ROOMS_HEIGHT);
        this.roomsCount = state.dungeon.labels.getInt((ELabel)EDungeonLabel.TOPOLOGY_ROOMS_COUNT);
        if (this.topology == null || this.topology.length() <= 0) {
            throw new RuntimeException("Dungeon does not have the label " + EDungeonLabel.TOPOLOGY_TYPE.id.name + " specified (or incorrect)!");
        }
        if (this.width <= 0) {
            throw new RuntimeException("Dungeon does not have the label " + EDungeonLabel.TOPOLOGY_ROOMS_WIDTH.id.name + " specified (or incorrect)!");
        }
        if (this.height <= 0) {
            throw new RuntimeException("Dungeon does not have the label " + EDungeonLabel.TOPOLOGY_ROOMS_HEIGHT.id.name + " specified (or incorrect)!");
        }
        if (this.roomsCount <= 0) {
            throw new RuntimeException("Dungeon does not have the label " + EDungeonLabel.TOPOLOGY_ROOMS_COUNT.id.name + " specified (or incorrect)!");
        }
        if (!"Grid".equals(this.topology)) {
            throw new RuntimeException("Cannot visualize dungeon with topology " + this.topology + ", " + "Grid" + " only!");
        }
        ArrayList<Id> roomIds = new ArrayList<Id>();
        int i = 1;
        while (i <= this.roomsCount) {
            roomIds.add(Id.get((String)("room" + i)));
            ++i;
        }
        i = 0;
        while (i < roomIds.size()) {
            boolean right;
            Id roomId = (Id)roomIds.get(i);
            Room room = (Room)state.dungeon.rooms.get(roomId);
            int roomX = i % this.width;
            int roomY = i / this.width;
            RoomView roomView = new RoomView(room, roomX, roomY);
            this.rooms.put(roomId, roomView);
            this.addChild((SceneElement)roomView);
            roomView.pos.x = roomX * 92;
            roomView.pos.y = roomY * 80;
            boolean mayUp = roomY > 0;
            boolean mayDown = i + this.width < this.roomsCount;
            boolean mayLeft = roomX > 0;
            boolean mayRight = roomX + 1 < this.width;
            boolean up = mayUp && room.hasCorridorTo((Id)roomIds.get(i - this.width));
            boolean down = mayDown && room.hasCorridorTo((Id)roomIds.get(i + this.width));
            boolean left = mayLeft && room.hasCorridorTo((Id)roomIds.get(i - 1));
            boolean bl = right = mayRight && room.hasCorridorTo((Id)roomIds.get(i + 1));
            if (up) {
                roomView.setOpeningNorth();
            }
            if (down) {
                roomView.setDoorSouth();
            }
            if (left) {
                roomView.setOpeningWest();
            }
            if (right) {
                roomView.setDoorEast();
            }
            if (room.item != null && EH.isA((Object)room.item.type, (Object)EItem.SWORD)) {
                roomView.setSword(true);
            }
            if (room.feature != null && EH.isA((Object)room.feature.type, (Object)EFeature.TRAP)) {
                AgentMindBody trap = (AgentMindBody)state.features.get(room.feature.id);
                roomView.initTrap((AgentMindBody<Feature, IFeatureAgent>)trap);
                roomView.setTrap(true);
            }
            if (room.label == ERoomLabel.GOAL) {
                roomView.setStaircase();
            } else {
                roomView.setRandomDecoration();
            }
            ++i;
        }
    }

    public int getTotalWidth() {
        return this.width * 92;
    }

    public int getTotalHeight() {
        return this.width * 5 * 16;
    }

    public RoomView getRoomView(Id roomId) {
        return this.rooms.get(roomId);
    }

    public RoomView getRoomView(Room room) {
        return this.getRoomView(room.id);
    }
}

