/*
 * Decompiled with CFR 0.152.
 */
package RLpackage;

import RLpackage.Pair;
import RLpackage.TreeIterator;
import java.util.Collections;
import java.util.Vector;

public class TreeNode
implements Comparable<TreeNode> {
    private String label;
    private String word;
    private TreeNode parent;
    private TreeNode[] children;

    public TreeNode(String label, String word) {
        this.label = label;
        this.word = word;
        this.children = new TreeNode[0];
    }

    public TreeNode(String label, TreeNode ... children) {
        this.label = label;
        this.children = children;
        int i = 0;
        while (i < children.length) {
            children[i].setParent(this);
            ++i;
        }
    }

    protected void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public int getNumberOfNodesInTree() {
        int sum = 1;
        int i = 0;
        while (i < this.getChildren().length) {
            sum += this.getChildren()[i].getNumberOfNodesInTree();
            ++i;
        }
        return sum;
    }

    public int getNumberOfAscendants() {
        int sum = this.getChildren().length;
        int i = 0;
        while (i < this.getChildren().length) {
            sum += this.getChildren()[i].getNumberOfAscendants();
            ++i;
        }
        return sum;
    }

    public int getNumOfLeafNodes() {
        if (this.isLeafNode()) {
            return 1;
        }
        int total = 0;
        TreeNode[] treeNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode child = treeNodeArray[n2];
            total += child.getNumOfLeafNodes();
            ++n2;
        }
        return total;
    }

    public Vector<TreeNode> getLeafNodes() {
        Vector<TreeNode> result = new Vector<TreeNode>();
        if (this.isLeafNode()) {
            result.add(this);
        } else {
            TreeNode[] treeNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode child = treeNodeArray[n2];
                result.addAll(child.getLeafNodes());
                ++n2;
            }
        }
        return result;
    }

    private boolean isLeafNode() {
        return this.children.length == 0;
    }

    public int getDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        return this.getParent().getDepth() + 1;
    }

    public int getLength() {
        return this.getNumOfLeafNodes();
    }

    public TreeNode getNodeWithSpan(int start, int end) {
        Pair<Integer, Integer> coords = this.getSpan();
        if (coords.getFirst() == start && coords.getSecond() == end) {
            return this;
        }
        int i = 0;
        while (i < this.children.length) {
            Pair<Integer, Integer> childCo = this.children[i].getSpan();
            if (start >= childCo.getFirst() && end <= childCo.getSecond()) {
                return this.children[i].getNodeWithSpan(start, end);
            }
            ++i;
        }
        throw new IllegalArgumentException("No child found for span " + start + " - " + end);
    }

    public Pair<Integer, Integer> getSpan() {
        if (this.getParent() == null) {
            return new Pair<Integer, Integer>(0, this.getLength());
        }
        int before = this.getParent().getSpan().getFirst();
        TreeNode[] children = this.getParent().getChildren();
        int i = 0;
        while (i < children.length && children[i] != this) {
            before += children[i].getNumOfLeafNodes();
            ++i;
        }
        return new Pair<Integer, Integer>(before, before + this.getLength());
    }

    public TreeNode getNextChild(TreeNode currChild) {
        int index = 0;
        while (index < this.getChildren().length && this.getChildren()[index] != currChild) {
            ++index;
        }
        if (index >= this.getChildren().length - 1) {
            return null;
        }
        return this.getChildren()[index + 1];
    }

    public TreeNode getPrevChild(TreeNode currChild) {
        int index = 0;
        while (index < this.getChildren().length && this.getChildren()[index] != currChild) {
            ++index;
        }
        if (index == 0) {
            return null;
        }
        return this.getChildren()[index - 1];
    }

    public void addChild(int pos, TreeNode child) {
        TreeNode[] newChildren = new TreeNode[this.children.length + 1];
        int i = 0;
        while (i < pos) {
            newChildren[i] = this.children[i];
            ++i;
        }
        newChildren[pos] = child;
        child.setParent(this);
        i = pos + 1;
        while (i < newChildren.length) {
            newChildren[i] = this.children[i - 1];
            ++i;
        }
        this.children = newChildren;
    }

    public void getPath(TreeNode end, Vector<String> parts) {
        TreeNode.getPath(this, end, parts);
    }

    public String getPath(TreeNode end) {
        String result = "";
        Vector<String> parts = new Vector<String>();
        this.getPath(end, parts);
        for (String part : parts) {
            result = String.valueOf(result) + part;
        }
        return result;
    }

    public static void getPath(TreeNode start, TreeNode end, Vector<String> parts) {
        TreeNode commonParent = TreeNode.getCommonParent(start, end);
        TreeNode curr = end;
        while (curr != commonParent) {
            parts.add("\u2193" + curr.getLabel());
            curr = curr.getParent();
        }
        String middle = "\u2191" + commonParent.getLabel() + "\u2193";
        parts.add(middle);
        curr = start;
        while (curr != commonParent) {
            parts.add(String.valueOf(curr.getLabel()) + "\u2191");
            curr = curr.getParent();
        }
        Collections.reverse(parts);
    }

    public String getPath(TreeNode start, TreeNode end, boolean orderInfo) {
        String path = start.getPath(end);
        if (orderInfo) {
            return String.valueOf(this.comesBefore(start, end)) + " " + path;
        }
        return path;
    }

    public boolean hasChild(TreeNode child) {
        int i = 0;
        while (i < this.children.length) {
            TreeNode curr = this.children[i];
            if (curr == child) {
                return true;
            }
            if (curr.hasChild(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TreeNode findMaximumNode(String words) {
        TreeIterator it = new TreeIterator(this);
        while (it.hasNext()) {
            TreeNode curr = it.next();
            if (!curr.getWords().equals(words)) continue;
            return curr;
        }
        System.err.println("Node : " + words);
        System.err.println("Not found in tree : " + this);
        throw new IllegalArgumentException("No node found for string \"" + words + "\"");
    }

    public TreeNode[] getChildren() {
        return this.children;
    }

    public String getLabel() {
        return this.label;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String start) {
        String result = String.valueOf(start) + " + ";
        result = String.valueOf(result) + this.label;
        if (this.getWord() != null) {
            result = String.valueOf(result) + " \"" + this.getWord() + "\"\n";
        } else {
            result = String.valueOf(result) + "\n";
            TreeNode[] treeNodeArray = this.getChildren();
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode child = treeNodeArray[n2];
                result = String.valueOf(result) + child.toString(String.valueOf(start) + " |");
                ++n2;
            }
        }
        return result;
    }

    public Vector<String> getAllWords() {
        Vector<String> result = new Vector<String>();
        if (this.getChildren().length == 0) {
            result.add(this.getWord());
        } else {
            int i = 0;
            while (i < this.getChildren().length) {
                TreeNode child = this.getChildren()[i];
                result.addAll(child.getAllWords());
                ++i;
            }
        }
        return result;
    }

    public String getWords() {
        if (this.getChildren().length == 0) {
            return this.getWord();
        }
        String result = "";
        int i = 0;
        while (i < this.getChildren().length) {
            TreeNode child = this.getChildren()[i];
            result = String.valueOf(result) + child.getWords();
            if (i < this.getChildren().length - 1) {
                result = String.valueOf(result) + " ";
            }
            ++i;
        }
        return result.trim();
    }

    public Vector<TreeNode> getAllNodesOfTree() {
        Vector<TreeNode> result = new Vector<TreeNode>();
        result.add(this);
        int i = 0;
        while (i < this.getChildren().length) {
            result.addAll(this.getChildren()[i].getAllNodesOfTree());
            ++i;
        }
        return result;
    }

    public boolean hasWord() {
        return this.word != null;
    }

    @Override
    public int compareTo(TreeNode o) {
        assert (o != null);
        if (this.label.equals(o.getLabel())) {
            if (this.hasWord() && !o.hasWord()) {
                return 1;
            }
            if (!this.hasWord() && o.hasWord()) {
                return -1;
            }
            int comp = this.getChildren().length - o.getChildren().length;
            if (comp != 0) {
                return comp;
            }
            int i = 0;
            while (i < this.getChildren().length && comp == 0) {
                comp = this.getChildren()[i].compareTo(o.getChildren()[i]);
                ++i;
            }
            return comp;
        }
        return this.label.compareTo(o.getLabel());
    }

    public boolean comesBefore(TreeNode other) {
        return this.getTopOfTree().comesBefore(this, other) > 0;
    }

    public TreeNode getTopOfTree() {
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getTopOfTree();
    }

    public int comesBefore(TreeNode first, TreeNode second) {
        int posFirst = -1;
        int posSecond = -1;
        int i = 0;
        while (i < this.children.length) {
            TreeNode child = this.children[i];
            if (child == first || child.hasChild(first)) {
                posFirst = i;
            }
            if (child == second || child.hasChild(second)) {
                posSecond = i;
            }
            ++i;
        }
        if (posFirst == -1 || posSecond == -1) {
            return 0;
        }
        if (posFirst < posSecond) {
            return 1;
        }
        if (posFirst == posSecond) {
            return this.children[posFirst].comesBefore(first, second);
        }
        return -1;
    }

    public boolean equals(TreeNode other) {
        if (!other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (this.hasWord()) {
            if (!other.hasWord()) {
                return false;
            }
            return this.getWord().equals(other.getWord());
        }
        if (this.getChildren().length != other.getChildren().length) {
            return false;
        }
        int i = 0;
        while (i < this.getChildren().length) {
            if (!this.getChildren()[i].equals(other.getChildren()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasVPAncestor() {
        if (this.getParent() != null) {
            if (this.getParent().label.startsWith("V")) {
                return true;
            }
            return this.getParent().hasVPAncestor();
        }
        return false;
    }

    public boolean hasAncestor(TreeNode ancestor) {
        if (this.getParent() == ancestor) {
            return true;
        }
        if (this.getParent() == null) {
            return false;
        }
        return this.getParent().hasAncestor(ancestor);
    }

    public boolean hasDescendant(TreeNode descendant) {
        TreeNode[] treeNodeArray = this.getChildren();
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode child = treeNodeArray[n2];
            if (child == descendant || child.hasDescendant(descendant)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getCombinedLabel(Vector<TreeNode> nodes) {
        String curr = "";
        int i = 0;
        while (i < nodes.size()) {
            curr = String.valueOf(curr) + nodes.get(i).getLabel();
            if (i != nodes.size() - 1) {
                curr = String.valueOf(curr) + "_";
            }
            ++i;
        }
        return curr;
    }

    public static TreeNode getCommonParent(TreeNode node1, TreeNode node2) {
        TreeNode parent = node1;
        while (parent != null) {
            if (node2 == parent || node2.hasAncestor(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        throw new IllegalStateException("Nodes " + node1 + " and " + node2 + " do not have a common ancestor!");
    }

    public static TreeNode getCommonParent(Vector<TreeNode> nodes) {
        TreeNode parent = nodes.get(0);
        int i = 1;
        while (i < nodes.size() && parent != null) {
            TreeNode node = nodes.get(i);
            while (parent != null && node != parent && !node.hasAncestor(parent)) {
                parent = parent.getParent();
            }
            ++i;
        }
        return parent;
    }

    public static boolean isVerbPhrase(TreeNode node) {
        return node.getLabel().charAt(0) == 'V';
    }

    public static boolean isNounPhrase(TreeNode node) {
        return node.getLabel().charAt(0) == 'N';
    }

    public static void getSequentialPath(TreeNode startNode, TreeNode endNode, Vector<String> path) {
        Vector<TreeNode> allLeafs = startNode.getTopOfTree().getLeafNodes();
        boolean normalOrder = startNode.comesBefore(endNode);
        TreeNode first = normalOrder ? startNode : endNode;
        TreeNode last = normalOrder ? endNode : startNode;
        int i = 0;
        while (i < allLeafs.size()) {
            TreeNode curr = allLeafs.get(i);
            if (!curr.comesBefore(first) && !last.comesBefore(curr)) {
                path.add(curr.getLabel());
            }
            ++i;
        }
        if (!normalOrder) {
            Collections.reverse(path);
        }
    }

    public static int getPathDistance(TreeNode start, TreeNode end) {
        int dist = 0;
        TreeNode commonParent = TreeNode.getCommonParent(start, end);
        TreeNode curr = end;
        while (curr != commonParent) {
            ++dist;
            curr = curr.getParent();
        }
        curr = start;
        while (curr != commonParent) {
            ++dist;
            curr = curr.getParent();
        }
        return dist;
    }
}

