/*
 * Decompiled with CFR 0.152.
 */
package SemEval2013;

import GeneralData_preprocess.PrintParameters;
import GeneralData_preprocess.offsets;
import GeneralData_preprocess.sentence;
import RLpackage.TreeNode;
import SemEval2013.FileFilter;
import SemEval2013.spatialFrame;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kul.cs.liir.spatial.api.SpatialRoleLabellingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util13.XmLExtract;

public class build_RelDB_SbySForSVMstructSemanticWeb {
    private static final Logger staticLogger = Logger.getLogger("SemEval2013-SpRL");
    private final Logger logger = Logger.getLogger("SemEval2013-SpRL");
    public static final String CHARNIAK_FILE_EXTENSION = ".char";
    public static final String LTH_FILE_EXTENSION = ".lth";
    public static final String SENTENCE_FILE_EXTENSION = ".data";
    public static final String LTH_DIR_NAME = "lth_files";
    public static final String CHARNIAK_DIR_NAME = "charniak";
    public static final String SENTENCE_SPLIT_DIR_NAME = "sentence_split";
    static String[] Prepositions = new String[]{"about", "above", "across", "after", "against", "along", "among", "around", "as", "at", "before", "behind", "beneath", "beside", "between", "by", "down", "during", "for", "from", "in", "inside", "into", "like", "of", "off", "on", "onto", "over", "round", "through", "to", "towards", "with"};
    private File preprocessedDataDir;
    private File outputDir;
    private File roleFeaturesDir;
    private File trLabelsDir;
    private File lmLabelsDir;
    private File spLabelsDir;
    private File pairFeaturesDir;
    private File spTrLabelsDir;
    private File spLmLabelsDir;
    private File relationsDir;
    private File ontologyLabelsDir;
    private File inputPredicatesDir;
    private File outputPredicatesDir;
    private File lthdir;
    private File chardir;
    private File txtdir;
    private Node emptyTag;

    public static boolean in_Vector(Vector<Integer> X, int r) {
        int i = 0;
        while (i < X.size()) {
            if (X.elementAt(i).equals(r)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean find_(String[] S, String x) {
        int i = 0;
        while (i < S.length) {
            if (S[i].toLowerCase().equals(x.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void make_svm_struct_header(Vector<Vector<String>> Att, File featuresOutputDirectory) throws IOException {
        XStream xstream = new XStream();
        featuresOutputDirectory.mkdirs();
        FileWriter local_features = new FileWriter(new File(featuresOutputDirectory, "phi.xml"));
        xstream.toXML(Att, (Writer)local_features);
        ((Writer)local_features).close();
    }

    public static Vector<Vector<String>> read_svm_struct_header(File featuresOutputDirectory) throws IOException {
        XStream xstream = new XStream();
        featuresOutputDirectory.mkdirs();
        Vector Att = (Vector)xstream.fromXML(new File(featuresOutputDirectory, "phi.xml"));
        return Att;
    }

    public static void writeAddedSpatialIndicatorLemmas(Set<String> spIndicators, File featuresOutputDirectory) throws IOException {
        XStream xstream = new XStream();
        featuresOutputDirectory.mkdirs();
        FileWriter dataWriter = new FileWriter(new File(featuresOutputDirectory, "spatialIndicators.xml"));
        xstream.toXML(spIndicators, (Writer)dataWriter);
        ((Writer)dataWriter).close();
    }

    public static Set<String> readAddedSpatialIndicatorLemmas(File featuresOutputDirectory) throws IOException {
        XStream xstream = new XStream();
        featuresOutputDirectory.mkdirs();
        Set spIndicators = (Set)xstream.fromXML(new File(featuresOutputDirectory, "spatialIndicators.xml"));
        return spIndicators;
    }

    public static void make_arff_header(Vector<String> arffAtt, PrintWriter p) {
        p.println("@RELATION  RCC_type\n");
        int r = 0;
        while (r < arffAtt.size()) {
            p.println("@ATTRIBUTE " + arffAtt.elementAt(r) + " NUMERIC");
            ++r;
        }
        p.println("@ATTRIBUTE class {DC,TPP,NTPP,EC,EQ,NTPPI,TPPI,PO,NONE}");
        p.println("@DATA");
    }

    static int[] find_tree_indexes(Vector<TreeNode> t, Vector<Vector<String>> M) {
        int[] a = new int[M.size()];
        int n = t.size();
        int j = 0;
        int i = 0;
        while (i < n) {
            if (t.elementAt(i).getNumberOfNodesInTree() == 1 & j < a.length && t.elementAt(i).getWords().equalsIgnoreCase(M.elementAt(j).elementAt(1))) {
                a[j] = i;
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static int Cur_freq(int x, String[] A) {
        int y = 0;
        int i = 0;
        while (i <= x) {
            if (A[i].equals(A[x])) {
                ++y;
            }
            ++i;
        }
        return y;
    }

    public static ArrayList<String> list_of_prepositions_index(String input) {
        input = input.replace("\"", "");
        String[] T = input.split(" ");
        ArrayList<String> a1 = new ArrayList<String>();
        int i = 0;
        while (i < T.length) {
            if (build_RelDB_SbySForSVMstructSemanticWeb.find_(Prepositions, T[i])) {
                a1.add(T[i].toLowerCase());
            }
            ++i;
        }
        return a1;
    }

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static int HeadW_with_index(Integer[] wordindexes, Vector<sentence.ling_features> words) {
        int[][] consarray = new int[wordindexes.length][2];
        int i2 = 0;
        while (i2 < wordindexes.length) {
            consarray[i2][0] = wordindexes[i2];
            consarray[i2][1] = Integer.parseInt(words.elementAt((int)wordindexes[i2].intValue()).words.head) - 1;
            ++i2;
        }
        if (wordindexes.length == 1) {
            return consarray[0][0];
        }
        boolean flag = true;
        int index = 0;
        int i1 = 0;
        while (i1 < consarray.length) {
            flag = true;
            int i22 = 0;
            while (i22 < consarray.length) {
                if (i1 != i22 && consarray[i1][1] == consarray[i22][0]) {
                    flag = false;
                    break;
                }
                ++i22;
            }
            if (flag) {
                index = consarray[i1][0];
                break;
            }
            ++i1;
        }
        return index;
    }

    public static String SRL(int index, Vector<Vector<String>> M) {
        int i = 10;
        while (i < M.elementAt(index).size()) {
            if (!M.elementAt(index).elementAt(i).equals("_")) {
                return M.elementAt(index).elementAt(i);
            }
            ++i;
        }
        return "";
    }

    public static String[] sortIntegerStrings(String[] a) {
        String[] orderedchars = new String[a.length];
        int[] intchars = new int[a.length];
        int u = 0;
        while (u < a.length) {
            intchars[u] = Integer.parseInt(a[u].replaceAll("[^\\d]", ""));
            ++u;
        }
        Arrays.sort(intchars);
        u = 0;
        while (u < intchars.length) {
            int u2 = 0;
            while (u2 < a.length) {
                if (a[u2].replaceAll("[^\\d]", "").equals(Integer.toString(intchars[u]))) {
                    orderedchars[u] = a[u2];
                    staticLogger.log(Level.FINE, Integer.toString(u2));
                    break;
                }
                ++u2;
            }
            ++u;
        }
        return orderedchars;
    }

    public static void sort_check(String[] a, String[] b) {
        if (a.length != b.length) {
            System.out.print("the number of files does not match!!");
        }
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, Exception {
        File outputDir = new File("./data sets/sprl2013-master/ConfluenceProject/Tables");
        File preprocessedDataDir = new File("./data sets/sprl2013-master/ConfluenceProject/Preprocess_train");
        File annotatedXmlDir = new File("./data sets/sprl2013-master/ConfluenceProject/train");
        File featuresOutputDirectory = new File("./data sets/svm_struct/collected-features");
        build_RelDB_SbySForSVMstructSemanticWeb builder = new build_RelDB_SbySForSVMstructSemanticWeb(preprocessedDataDir, outputDir);
        builder.extractFeaturesAndTrainingData(annotatedXmlDir, featuresOutputDirectory, false);
    }

    public build_RelDB_SbySForSVMstructSemanticWeb(File preprocessedDataDir, File outputDir) {
        this.preprocessedDataDir = preprocessedDataDir;
        this.outputDir = outputDir;
        this.lthdir = new File(preprocessedDataDir, LTH_DIR_NAME);
        this.chardir = new File(preprocessedDataDir, CHARNIAK_DIR_NAME);
        this.txtdir = new File(preprocessedDataDir, SENTENCE_SPLIT_DIR_NAME);
        outputDir.mkdirs();
        this.roleFeaturesDir = new File(outputDir, "roleFeatures");
        this.roleFeaturesDir.mkdirs();
        this.trLabelsDir = new File(outputDir, "TrLabels");
        this.trLabelsDir.mkdirs();
        this.lmLabelsDir = new File(outputDir, "LmLabels");
        this.lmLabelsDir.mkdirs();
        this.spLabelsDir = new File(outputDir, "SpLabels");
        this.spLabelsDir.mkdirs();
        this.pairFeaturesDir = new File(outputDir, "pairFeatures");
        this.pairFeaturesDir.mkdirs();
        this.spTrLabelsDir = new File(outputDir, "SpTrLabels");
        this.spTrLabelsDir.mkdirs();
        this.spLmLabelsDir = new File(outputDir, "SpLmLabels");
        this.spLmLabelsDir.mkdirs();
        this.relationsDir = new File(outputDir, "relations");
        this.relationsDir.mkdirs();
        this.ontologyLabelsDir = new File(outputDir, "ontologyLabels");
        this.ontologyLabelsDir.mkdirs();
        this.inputPredicatesDir = new File(outputDir, "inputPredicates");
        this.inputPredicatesDir.mkdirs();
        this.outputPredicatesDir = new File(outputDir, "outputPredicates");
        this.outputPredicatesDir.mkdirs();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            this.emptyTag = doc.createElement("TEXT");
        }
        catch (ParserConfigurationException ex) {
            throw new SpatialRoleLabellingException(ex);
        }
    }

    public void extractFeaturesAndTrainingData(File annotatedXmlDir, File featuresOutputDirectory, boolean testing) throws IOException, ParserConfigurationException, SAXException {
        Set<String> addedSpatialIndicatorLemmas;
        Vector<Vector<String>> arffAttRel;
        File fsource = annotatedXmlDir;
        FileFilter xmlFilter = new FileFilter(".xml", "");
        File[] xmlfiles = fsource.listFiles(xmlFilter);
        if (testing) {
            arffAttRel = build_RelDB_SbySForSVMstructSemanticWeb.read_svm_struct_header(featuresOutputDirectory);
            addedSpatialIndicatorLemmas = build_RelDB_SbySForSVMstructSemanticWeb.readAddedSpatialIndicatorLemmas(featuresOutputDirectory);
        } else {
            arffAttRel = build_RelDB_SbySForSVMstructSemanticWeb.initArffAttRel();
            addedSpatialIndicatorLemmas = new HashSet<String>();
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        int i = 0;
        while (i < xmlfiles.length) {
            String baseName = FilenameUtils.getBaseName((String)xmlfiles[i].getName());
            Document docGth = docBuilder.parse(xmlfiles[i]);
            FileFilter sentencesFilter = new FileFilter(SENTENCE_FILE_EXTENSION, baseName);
            File[] current = this.txtdir.listFiles(sentencesFilter);
            int f_index = 0;
            while (f_index < current.length) {
                String sentenceBaseName = FilenameUtils.getBaseName((String)current[f_index].getName());
                this.logger.log(Level.INFO, "Now parsing: " + sentenceBaseName);
                sentence sentence1 = this.readSentence(sentenceBaseName, arffAttRel, addedSpatialIndicatorLemmas, testing, docGth);
                if (sentence1 != null) {
                    PrintParameters parameters = this.createPrintParameters(sentenceBaseName);
                    sentence1.writeRelationalFeatureSvmStructSemanticWeb(arffAttRel, parameters);
                    this.closePrintParameters(parameters);
                }
                ++f_index;
            }
            ++i;
        }
        if (!testing) {
            build_RelDB_SbySForSVMstructSemanticWeb.make_svm_struct_header(arffAttRel, featuresOutputDirectory);
            build_RelDB_SbySForSVMstructSemanticWeb.writeAddedSpatialIndicatorLemmas(addedSpatialIndicatorLemmas, featuresOutputDirectory);
        }
    }

    public void extractFeatures(File featuresDirectory) throws ParserConfigurationException, SAXException, IOException {
        Vector<Vector<String>> arffAttRel = build_RelDB_SbySForSVMstructSemanticWeb.read_svm_struct_header(featuresDirectory);
        Set<String> addedSpatialIndicatorLemmas = build_RelDB_SbySForSVMstructSemanticWeb.readAddedSpatialIndicatorLemmas(featuresDirectory);
        FileFilter txtFilter = new FileFilter(SENTENCE_FILE_EXTENSION, "");
        FileFilter charFilter = new FileFilter(CHARNIAK_FILE_EXTENSION, "");
        FileFilter lthFilter = new FileFilter(LTH_FILE_EXTENSION, "");
        File[] txtfiles = this.txtdir.listFiles(txtFilter);
        File[] charfiles = this.chardir.listFiles(charFilter);
        File[] lthfiles = this.lthdir.listFiles(lthFilter);
        if (txtfiles == null || charfiles == null || lthfiles == null) {
            throw new IllegalStateException("lth/sentence split/charniak input directory not found.");
        }
        if (lthfiles.length != txtfiles.length || txtfiles.length != charfiles.length) {
            throw new IllegalStateException("Different number of lth/sentence split/charniak input files");
        }
        File[] fileArray = txtfiles;
        int n = txtfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File txtFile = fileArray[n2];
            String baseName = FilenameUtils.getBaseName((String)txtFile.getName());
            sentence sentence1 = this.readSentence(baseName, arffAttRel, addedSpatialIndicatorLemmas, true, null);
            if (sentence1 != null) {
                PrintParameters parameters = this.createPrintParameters(baseName);
                sentence1.writeRelationalFeatureSvmStructSemanticWeb(arffAttRel, parameters);
                this.closePrintParameters(parameters);
            }
            ++n2;
        }
    }

    private PrintWriter createOutputPrintWriter(File baseDir, String baseName) throws IOException {
        return new PrintWriter(new BufferedWriter(new FileWriter(new File(baseDir, String.valueOf(baseName) + SENTENCE_FILE_EXTENSION))));
    }

    private PrintParameters createPrintParameters(String baseName) throws IOException {
        PrintParameters parameters = new PrintParameters();
        parameters.Globality = 1;
        parameters.roleFeatures = this.createOutputPrintWriter(this.roleFeaturesDir, baseName);
        parameters.pairFeatures = this.createOutputPrintWriter(this.pairFeaturesDir, baseName);
        parameters.TrLabels = this.createOutputPrintWriter(this.trLabelsDir, baseName);
        parameters.LmLabels = this.createOutputPrintWriter(this.lmLabelsDir, baseName);
        parameters.SpLabels = this.createOutputPrintWriter(this.spLabelsDir, baseName);
        parameters.inputpredicates = this.createOutputPrintWriter(this.inputPredicatesDir, baseName);
        parameters.outputpredicates = this.createOutputPrintWriter(this.outputPredicatesDir, baseName);
        parameters.relations = this.createOutputPrintWriter(this.relationsDir, baseName);
        parameters.ontologyLables = this.createOutputPrintWriter(this.ontologyLabelsDir, baseName);
        parameters.relationLabelsTr_Sp = this.createOutputPrintWriter(this.spTrLabelsDir, baseName);
        parameters.relationLabelsLm_Sp = this.createOutputPrintWriter(this.spLmLabelsDir, baseName);
        return parameters;
    }

    private void closePrintParameters(PrintParameters parameters) {
        parameters.roleFeatures.close();
        parameters.pairFeatures.close();
        parameters.TrLabels.close();
        parameters.LmLabels.close();
        parameters.SpLabels.close();
        parameters.inputpredicates.close();
        parameters.outputpredicates.close();
        parameters.relations.close();
        parameters.ontologyLables.close();
        parameters.relationLabelsTr_Sp.close();
        parameters.relationLabelsLm_Sp.close();
    }

    private static Vector<Vector<String>> initArffAttRel() {
        Vector<Vector<String>> arffAttRel = new Vector<Vector<String>>();
        arffAttRel.add(0, new Vector());
        arffAttRel.add(1, new Vector());
        arffAttRel.add(2, new Vector());
        arffAttRel.add(3, new Vector());
        arffAttRel.add(4, new Vector());
        return arffAttRel;
    }

    private sentence readSentence(String baseName, Vector<Vector<String>> arffAttRel, Set<String> addedSpatialLemmas, boolean readOnlyFeatures, Document annotationXml) throws IOException {
        File txtFile = new File(this.txtdir, String.valueOf(baseName) + SENTENCE_FILE_EXTENSION);
        File associatedLthFile = new File(this.lthdir, String.valueOf(baseName) + LTH_FILE_EXTENSION);
        File associatedCharFile = new File(this.chardir, String.valueOf(baseName) + CHARNIAK_FILE_EXTENSION);
        if (!associatedLthFile.exists() || !associatedCharFile.exists()) {
            throw new IllegalStateException("Associated .lth/.char file does not exist for file " + txtFile.getAbsolutePath());
        }
        BufferedReader brlth = new BufferedReader(new FileReader(associatedLthFile));
        BufferedReader brchar = new BufferedReader(new FileReader(associatedCharFile));
        try {
            sentence sentence1 = new sentence(baseName);
            sentence1.content = FileUtils.readFileToString((File)txtFile);
            if (!sentence1.content.matches(".*[a-zA-Z].*")) {
                return null;
            }
            sentence1.fetch_ling_features(brlth, brchar);
            if (annotationXml != null) {
                NodeList Tags = annotationXml.getElementsByTagName("TAGS");
                Node Tag = Tags.item(0);
                Vector<spatialFrame> AllRelations = XmLExtract.rel_annotations(Tag);
                annotationXml.getDocumentElement().normalize();
                offsets ind = sentence1.txtIndex(annotationXml, sentence1.content);
                sentence1.fetch_relXml(Tag, sentence1.content, ind, AllRelations);
            } else {
                sentence1.fetch_relXml(this.emptyTag, sentence1.content, new offsets(), new Vector<spatialFrame>());
            }
            sentence1.build_all_candidates(addedSpatialLemmas, !readOnlyFeatures);
            sentence sentence2 = sentence1;
            return sentence2;
        }
        finally {
            brlth.close();
            brchar.close();
        }
    }
}

