package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import java.util.ArrayList;
import java.util.List;

import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShootingParameters;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.WeaponShootingTestController;

import org.junit.Ignore;
import org.junit.Test;

import cz.cuni.amis.pogamut.ut2004.bot.UT2004BotTest;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;

@Ignore
public abstract class UT2004Test_AbstractWeaponShootingTest extends UT2004BotTest {

	/**
	 * A list of navpoint ids that form a circular path around the center of the
	 * CTF-Chrome map. This path will be run by the players on the blue team.
	 */
	public static final String[] PATH_TEAM_BLUE = new String[] { "CTF-Chrome.PathNode131", "CTF-Chrome.PathNode128",
			"CTF-Chrome.PathNode67", "CTF-Chrome.PathNode64" };

	/**
	 * A list of navpoint ids that form a star shaped path around the center of
	 * the CTF-Chrome map. This path will be run by the layers on the red team.
	 */
	public static final String[] PATH_TEAM_RED = new String[] { "CTF-Chrome.PathNode209", "CTF-Chrome.PathNode38",
			"CTF-Chrome.PathNode55", "CTF-Chrome.PathNode69", "CTF-Chrome.PathNode195", "CTF-Chrome.PathNode203" };

	protected List<UT2004BotParameters> createTeamBlue(boolean primary, int n) {
		List<UT2004BotParameters> target = new ArrayList<UT2004BotParameters>(n);
		for (int i = 0; i < n; i++)
			target.add(createTeamBlueBot(primary));

		return target;
	}

	/**
	 * Creates parameters for a bot on the blue team using the weapon and ammo
	 * specified in the subclass.
	 * 
	 * @return
	 */
	protected UT2004BotParameters createTeamBlueBot(boolean primary) {
		return new WeaponShootingParameters(getWeapon(), getAmmo(), primary, getPathBlue()).setTestDurationMinutes(getTestDurationMinutes()).setTeam(1);
	}

	/**
	 * Calls {@link UT2004Test_AbstractWeaponShootingTest#createTeamRedBot()} n
	 * times.
	 * 
	 * @param n
	 * @return
	 */
	protected List<UT2004BotParameters> createTeamRed(int n) {
		List<UT2004BotParameters> target = new ArrayList<UT2004BotParameters>(n);
		for (int i = 0; i < n; i++)
			target.add(createTeamRedBot());

		return target;
	}

	/**
	 * Creates parameters for a bot using the shield gun in secondary mode.
	 * These make good targets. The bot will be placed on the red team and
	 * follow the path given in {@link UT2004Test_AbstractWeaponShootingTest#getPathRed()}.
	 * 
	 * @return
	 */
	protected UT2004BotParameters createTeamRedBot() {
		return new WeaponShootingParameters(ItemType.SHIELD_GUN, ItemType.SHIELD_GUN_AMMO, false, getPathRed()).setTestDurationMinutes(getTestDurationMinutes());
	}

	protected abstract ItemType getAmmo();

	/**
	 * Default game is BotCTFGame.
	 */
	@Override
	protected String getGameType() {
		return "BotCTFGame";
	}

	/**
	 * Default map is CTF-Chrome.
	 */
	@Override
	protected String getMapName() {
		return CTF_MAPS[5]; // CTF-Chrome
	}

	protected String[] getPathBlue() {
		return PATH_TEAM_BLUE;
	}


	protected String[] getPathRed() {
		return PATH_TEAM_RED;
	}

	protected int getTeamSizeBlue() {
		return 1;
	}
	
	protected int getTeamSizeRed() {
		return 2;
	}

	protected int getTestDurationMinutes(){
		return 10;
	}

	protected abstract ItemType getWeapon();


	protected boolean shouldTestPrimary() {
		return true;
	}

	protected boolean shouldTestSecondary() {
		return true;
	}

	/**
	 * Tests primary against a number of shielded targets.
	 */
	@Test
	public void testPrimary() {
		if (!shouldTestPrimary()) {
			return;
		}

		List<UT2004BotParameters> params = new ArrayList<UT2004BotParameters>();
		params.addAll(createTeamRed(getTeamSizeRed()));
		params.addAll(createTeamBlue(true, getTeamSizeBlue()));

		startTest(WeaponShootingTestController.class, 20, params.toArray(new UT2004BotParameters[0]));
	}

	/**
	 * Tests secondary against a number of shielded targets.
	 */
	@Test
	public void testSecondary() {
		if (!shouldTestSecondary()) {
			return;
		}

		List<UT2004BotParameters> params = new ArrayList<UT2004BotParameters>();
		params.addAll(createTeamRed(getTeamSizeRed()));
		params.addAll(createTeamBlue(false, getTeamSizeBlue()));

		startTest(WeaponShootingTestController.class, 20, params.toArray(new UT2004BotParameters[0]));
	}

}