package nl.tudelft.pogamut.ut2004.agent.module.shooting;

import java.util.List;

import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;

public class LinkGunSecondaryWeaponShootingTestController extends WeaponShootingTestController {

	/**
	 * True iff this bot will assist another player
	 */

	public void logicTestWeapon() {

		// Get ammo
		addAmmo();

		// Get weapon.
		addWeapon();

		// Wait for navigation to be done.
		if (navigation.isNavigating()) {
			return;
		}

		// Assist?
		List<Player> linkGunPlayers = MyCollections.getFiltered(players.getFriends().values(), new IFilter<Player>() {

			@Override
			public boolean isAccepted(Player object) {
				return object.getWeapon() != null && object.getWeapon().contains("LinkGun")
						&& object.getName().compareTo(info.getName()) < 0;
			}
		});

		Player closestLinkGunPlayer = DistanceUtils.getNearest(linkGunPlayers, bot);
		Player closestEnemy = players.getNearestVisibleEnemy();
		if (closestLinkGunPlayer != null && closestLinkGunPlayer.isVisible()) {
			// Set assist so we don't need to kill
			setNeedsKills(false);
			// Assists
			weaponShooting.shoot(closestLinkGunPlayer);
			// Follow
			navigation.navigate(closestLinkGunPlayer);
			return;

		} else if (closestEnemy != null) {
			weaponShooting.shoot(closestEnemy);
			navigation.navigate(closestEnemy);
			return;
		}
		
		weaponShooting.shoot(closestEnemy);

		// Move from point to point
		if (!info.atLocation(currentStation)) {
			navigation.navigate(currentStation);
			waitAtLocation.heat();
			return;
		}

		// Done waiting.
		if (waitAtLocation.isCool()) {
			visited.add(currentStation);
			currentStation = DistanceUtils.getNearest(visited.filter(firingRange), bot);
			if (currentStation == null) {
				visited.clear();
				currentStation = DistanceUtils.getNearest(visited.filter(firingRange), bot);
			}
			return;
		}

		// Look at target with nothing else to do.
		if (closestLinkGunPlayer != null) {
			move.turnTo(closestLinkGunPlayer);
		}  else if (closestEnemy != null) {
			move.turnTo(closestEnemy);
		} else {
			move.turnHorizontal(30);
		}

	}
	

}
