/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transport.PropertyScope;
import org.mule.session.DefaultMuleSession;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.NullPayload;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMuleMessageTestCase
extends AbstractMuleTestCase {
    public void testConstructorWithNoMuleContext() {
        try {
            new DefaultMuleMessage((Object)"Test Message", null);
            DefaultMuleMessageTestCase.fail((String)"DefaultMuleMessage must fail when created with null MuleContext");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorWithNullPayload() {
        DefaultMuleMessage message = new DefaultMuleMessage(null, muleContext);
        DefaultMuleMessageTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)message.getPayload());
    }

    public void testOneArgConstructor() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DefaultMuleMessageTestCase.assertEquals((Object)"Test Message", (Object)message.getPayload());
    }

    public void testOneArgConstructorWithMuleMessageAsPayload() {
        MuleMessage oldMessage = this.createMuleMessage();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)oldMessage, muleContext);
        DefaultMuleMessageTestCase.assertEquals((Object)"MULE_MESSAGE", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
    }

    public void testMessagePropertiesConstructor() {
        Map<String, Object> properties = this.createMessageProperties();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", properties, muleContext);
        DefaultMuleMessageTestCase.assertEquals((Object)"Test Message", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MessageProperties", (MuleMessage)message);
    }

    public void testMessagePropertiesAccessors() {
        Map<String, Object> properties = this.createMessageProperties();
        properties.put("number", "24");
        properties.put("decimal", "24.3");
        properties.put("boolean", "true");
        Apple apple = new Apple(true);
        properties.put("apple", apple);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", properties, muleContext);
        DefaultMuleMessageTestCase.assertTrue((boolean)((Boolean)message.getOutboundProperty("boolean", (Object)false)));
        DefaultMuleMessageTestCase.assertEquals((Object)new Integer(24), (Object)message.getOutboundProperty("number", (Object)0));
        DefaultMuleMessageTestCase.assertEquals((Object)new Byte(24), (Object)message.getOutboundProperty("number", (Object)0));
        DefaultMuleMessageTestCase.assertEquals((Object)new Long(24L), (Object)message.getOutboundProperty("number", (Object)0L));
        DefaultMuleMessageTestCase.assertEquals((Object)new Float(24.3), (Object)message.getOutboundProperty("decimal", (Object)Float.valueOf(0.0f)));
        Double d = (Double)message.getOutboundProperty("decimal", (Object)0.0);
        DefaultMuleMessageTestCase.assertEquals((Object)new Double(24.3), (Object)d);
        DefaultMuleMessageTestCase.assertEquals((String)"true", (String)((String)message.getOutboundProperty("boolean", (Object)"")));
        DefaultMuleMessageTestCase.assertEquals((Object)apple, (Object)message.getOutboundProperty("apple"));
        try {
            message.getOutboundProperty("apple", (Object)new Orange());
            DefaultMuleMessageTestCase.fail((String)"Orange is not assignable to Apple");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        DefaultMuleMessageTestCase.assertNull((Object)message.getOutboundProperty("banana"));
        DefaultMuleMessageTestCase.assertNull((Object)message.getOutboundProperty("blah"));
        DefaultMuleMessageTestCase.assertEquals((Object)new Float(24.3), (Object)message.getOutboundProperty("blah", (Object)Float.valueOf(24.3f)));
    }

    public void testMessagePropertiesConstructorWithMuleMessageAsPayload() {
        Map<String, Object> properties = this.createMessageProperties();
        MuleMessage previousMessage = this.createMuleMessage();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)previousMessage, properties, muleContext);
        DefaultMuleMessageTestCase.assertEquals((Object)"MULE_MESSAGE", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MessageProperties", (MuleMessage)message);
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
    }

    public void testPreviousMessageConstructorWithRegularPayloadAndMuleMessageAsPrevious() {
        MuleMessage previous = this.createMuleMessage();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", previous, muleContext);
        DefaultMuleMessageTestCase.assertEquals((Object)"Test Message", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
        DefaultMuleMessageTestCase.assertEquals((String)previous.getUniqueId(), (String)message.getUniqueId());
    }

    public void testPreviousMessageConstructorWithMuleMessageAsPayloadAndMuleMessageAsPrevious() {
        MuleMessage payload = this.createMuleMessage();
        payload.setOutboundProperty("payload", (Object)"payload");
        MuleMessage previous = this.createMuleMessage();
        previous.setOutboundProperty("previous", (Object)"previous");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)payload, previous, muleContext);
        DefaultMuleMessageTestCase.assertEquals((Object)"MULE_MESSAGE", (Object)message.getPayload());
        this.assertOutboundMessageProperty("MuleMessage", (MuleMessage)message);
        this.assertOutboundMessageProperty("payload", (MuleMessage)message);
        DefaultMuleMessageTestCase.assertEquals((String)previous.getUniqueId(), (String)message.getUniqueId());
    }

    public void testClearProperties() {
        MuleMessage payload = this.createMuleMessage();
        payload.setOutboundProperty("foo", (Object)"fooValue");
        payload.setInvocationProperty("bar", (Object)"barValue");
        DefaultMuleMessageTestCase.assertEquals((int)1, (int)payload.getInvocationPropertyNames().size());
        DefaultMuleMessageTestCase.assertEquals((int)2, (int)payload.getOutboundPropertyNames().size());
        DefaultMuleMessageTestCase.assertEquals((int)0, (int)payload.getInboundPropertyNames().size());
        payload.clearProperties(PropertyScope.INVOCATION);
        DefaultMuleMessageTestCase.assertEquals((int)0, (int)payload.getInvocationPropertyNames().size());
        payload.clearProperties(PropertyScope.OUTBOUND);
        DefaultMuleMessageTestCase.assertEquals((int)0, (int)payload.getOutboundPropertyNames().size());
    }

    public void testCopyConstructor() throws Exception {
        DefaultMuleMessage original = (DefaultMuleMessage)this.createMuleMessage();
        Map<String, Object> properties = this.createMessageProperties();
        original.addInboundProperties(properties);
        this.assertInboundAndOutboundMessageProperties((MuleMessage)original);
        DefaultMuleMessage copy = new DefaultMuleMessage((MuleMessage)original);
        this.assertInboundAndOutboundMessageProperties((MuleMessage)copy);
    }

    private void assertInboundAndOutboundMessageProperties(MuleMessage original) {
        this.assertOutboundMessageProperty("MuleMessage", original);
        DefaultMuleMessageTestCase.assertEquals((Object)"MessageProperties", (Object)original.getInboundProperty("MessageProperties"));
    }

    public void testLegacyAddingAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DataHandler handler = new DataHandler((Object)"this is the attachment", "text/plain");
        message.addOutboundAttachment("attachment", handler);
        DefaultMuleMessageTestCase.assertTrue((boolean)message.getOutboundAttachmentNames().contains("attachment"));
        DefaultMuleMessageTestCase.assertEquals((Object)handler, (Object)message.getOutboundAttachment("attachment"));
    }

    public void testAddingOutboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DataHandler handler = new DataHandler((Object)"this is the attachment", "text/plain");
        message.addOutboundAttachment("attachment", handler);
        DefaultMuleMessageTestCase.assertTrue((boolean)message.getOutboundAttachmentNames().contains("attachment"));
        DefaultMuleMessageTestCase.assertEquals((Object)handler, (Object)message.getOutboundAttachment("attachment"));
        DefaultMuleMessageTestCase.assertEquals((int)0, (int)message.getInboundAttachmentNames().size());
        message.removeOutboundAttachment("attachment");
        DefaultMuleMessageTestCase.assertEquals((int)0, (int)message.getOutboundAttachmentNames().size());
        message.addOutboundAttachment("spi-props", (Object)IOUtils.getResourceAsUrl((String)"test-spi.properties", this.getClass()), "text/plain");
        DefaultMuleMessageTestCase.assertTrue((boolean)message.getOutboundAttachmentNames().contains("spi-props"));
        handler = message.getOutboundAttachment("spi-props");
        DefaultMuleMessageTestCase.assertEquals((String)"text/plain", (String)handler.getContentType());
        DefaultMuleMessageTestCase.assertEquals((int)1, (int)message.getOutboundAttachmentNames().size());
        message.addOutboundAttachment("dummy", (Object)IOUtils.getResourceAsUrl((String)"dummy.xml", this.getClass()), null);
        handler = message.getOutboundAttachment("dummy");
        DefaultMuleMessageTestCase.assertEquals((String)"application/xml", (String)handler.getContentType());
        DefaultMuleMessageTestCase.assertEquals((int)2, (int)message.getOutboundAttachmentNames().size());
    }

    public void testAddingInboundAttachment() throws Exception {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        DataHandler dh = new DataHandler((Object)"this is the attachment", "text/plain");
        attachments.put("attachment", dh);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", null, attachments, muleContext);
        DefaultMuleMessageTestCase.assertTrue((boolean)message.getInboundAttachmentNames().contains("attachment"));
        DefaultMuleMessageTestCase.assertEquals((Object)dh, (Object)message.getInboundAttachment("attachment"));
        DefaultMuleMessageTestCase.assertEquals((int)0, (int)message.getOutboundAttachmentNames().size());
    }

    public void testNewMuleMessageFromMuleMessageWithAttachment() throws Exception {
        MuleMessage previous = this.createMuleMessage();
        DataHandler handler = new DataHandler((Object)"this is the attachment", "text/plain");
        previous.addOutboundAttachment("attachment", handler);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", previous, muleContext);
        DefaultMuleMessageTestCase.assertTrue((boolean)message.getOutboundAttachmentNames().contains("attachment"));
        DefaultMuleMessageTestCase.assertEquals((Object)handler, (Object)message.getOutboundAttachment("attachment"));
    }

    public void testFindPropertiesInAnyScope() throws Exception {
        MuleMessage message = this.createMuleMessage();
        message.removeProperty("MuleMessage", PropertyScope.OUTBOUND);
        RequestContext.setEvent((MuleEvent)new DefaultMuleEvent(message, (ImmutableEndpoint)DefaultMuleMessageTestCase.getTestInboundEndpoint("foo"), (MuleSession)new DefaultMuleSession(muleContext)));
        message.setOutboundProperty("foo", (Object)"fooOutbound");
        message.setInvocationProperty("bar", (Object)"barInvocation");
        message.setInvocationProperty("foo", (Object)"fooInvocation");
        message.setProperty("foo", (Object)"fooInbound", PropertyScope.INBOUND);
        message.setSessionProperty("foo", (Object)"fooSession");
        DefaultMuleMessageTestCase.assertEquals((int)2, (int)message.getInvocationPropertyNames().size());
        DefaultMuleMessageTestCase.assertEquals((int)1, (int)message.getOutboundPropertyNames().size());
        DefaultMuleMessageTestCase.assertEquals((int)1, (int)message.getInboundPropertyNames().size());
        DefaultMuleMessageTestCase.assertEquals((int)1, (int)message.getSessionPropertyNames().size());
        String value = (String)message.findPropertyInAnyScope("foo", null);
        DefaultMuleMessageTestCase.assertEquals((String)"fooOutbound", (String)value);
        message.removeProperty("foo", PropertyScope.OUTBOUND);
        value = (String)message.findPropertyInAnyScope("foo", null);
        DefaultMuleMessageTestCase.assertEquals((String)"fooInvocation", (String)value);
        message.removeProperty("foo", PropertyScope.INVOCATION);
        value = (String)message.findPropertyInAnyScope("foo", null);
        DefaultMuleMessageTestCase.assertEquals((String)"fooSession", (String)value);
        message.removeProperty("foo", PropertyScope.SESSION);
        value = (String)message.findPropertyInAnyScope("foo", null);
        DefaultMuleMessageTestCase.assertEquals((String)"fooInbound", (String)value);
        value = (String)message.findPropertyInAnyScope("bar", null);
        DefaultMuleMessageTestCase.assertEquals((String)"barInvocation", (String)value);
    }

    private Map<String, Object> createMessageProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MessageProperties", "MessageProperties");
        return map;
    }

    private MuleMessage createMuleMessage() {
        DefaultMuleMessage previousMessage = new DefaultMuleMessage((Object)"MULE_MESSAGE", muleContext);
        previousMessage.setOutboundProperty("MuleMessage", (Object)"MuleMessage");
        return previousMessage;
    }

    private void assertOutboundMessageProperty(String key, MuleMessage message) {
        DefaultMuleMessageTestCase.assertEquals((Object)key, (Object)message.getOutboundProperty(key));
    }
}

