/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import javax.net.ssl.SSLSocketFactory;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.tck.AbstractMuleTestCase;

public class TlsConfigurationTestCase
extends AbstractMuleTestCase {
    public void testEmptyConfiguration() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        try {
            configuration.initialise(false, "javax.net");
            TlsConfigurationTestCase.fail((String)"no key password");
        }
        catch (IllegalArgumentException e) {
            TlsConfigurationTestCase.assertNotNull((String)"expected", (Object)e);
        }
        configuration.setKeyPassword("mulepassword");
        try {
            configuration.initialise(false, "javax.net");
            TlsConfigurationTestCase.fail((String)"no store password");
        }
        catch (IllegalArgumentException e) {
            TlsConfigurationTestCase.assertNotNull((String)"expected", (Object)e);
        }
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("");
        try {
            configuration.initialise(false, "javax.net");
            TlsConfigurationTestCase.fail((String)"no keystore");
        }
        catch (Exception e) {
            TlsConfigurationTestCase.assertNotNull((String)"expected", (Object)e);
        }
    }

    public void testSimpleSocket() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        configuration.setKeyPassword("mulepassword");
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("clientKeystore");
        configuration.initialise(false, "javax.net");
        SSLSocketFactory socketFactory = configuration.getSocketFactory();
        TlsConfigurationTestCase.assertTrue((String)"socket is useless", (socketFactory.getSupportedCipherSuites().length > 0 ? 1 : 0) != 0);
    }
}

