/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Properties;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.AbstractMuleTestCase;

public class MuleEndpointURITestCase
extends AbstractMuleTestCase {
    public void testEquality() throws Exception {
        MuleEndpointURI u1 = new MuleEndpointURI("test://mule:secret@jabber.org:6666/ross@jabber.org", muleContext);
        MuleEndpointURI u2 = new MuleEndpointURI("test://mule:secret@jabber.org:6666/ross@jabber.org", muleContext);
        MuleEndpointURITestCase.assertEquals((Object)u1, (Object)u2);
        MuleEndpointURITestCase.assertEquals((Object)u2, (Object)u1);
        MuleEndpointURITestCase.assertEquals((int)u1.hashCode(), (int)u2.hashCode());
        MuleEndpointURITestCase.assertEquals((int)u2.hashCode(), (int)u1.hashCode());
        MuleEndpointURI u3 = new MuleEndpointURI((EndpointURI)u1);
        MuleEndpointURITestCase.assertEquals((Object)u1, (Object)u3);
        MuleEndpointURITestCase.assertEquals((Object)u2, (Object)u3);
        MuleEndpointURITestCase.assertEquals((Object)u3, (Object)u1);
        MuleEndpointURITestCase.assertEquals((Object)u3, (Object)u2);
        MuleEndpointURITestCase.assertEquals((int)u1.hashCode(), (int)u3.hashCode());
        MuleEndpointURITestCase.assertEquals((int)u2.hashCode(), (int)u3.hashCode());
    }

    public void testUriWithHostOnly() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((int)0, (int)uri.getParams().size());
    }

    public void testUriWithHostAndPort() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost:9999");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)9999, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((int)0, (int)uri.getParams().size());
    }

    public void testUriWithUsername() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"theUser", (String)uri.getUser());
        MuleEndpointURITestCase.assertEquals((int)0, (int)uri.getParams().size());
    }

    public void testUriWithUsernameAndPassword() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser:secret@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"theUser", (String)uri.getUser());
        MuleEndpointURITestCase.assertEquals((String)"secret", (String)uri.getPassword());
        MuleEndpointURITestCase.assertEquals((String)"theUser:secret", (String)uri.getUserInfo());
        MuleEndpointURITestCase.assertEquals((int)0, (int)uri.getParams().size());
    }

    public void testUriWithUsernameContainingAtSignAndPassword() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser%40theEmailHost:secret@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"theUser@theEmailHost", (String)uri.getUser());
        MuleEndpointURITestCase.assertEquals((String)"secret", (String)uri.getPassword());
        MuleEndpointURITestCase.assertEquals((int)0, (int)uri.getParams().size());
    }

    public void testUriWithUsernameAndPasswordContainingAtSign() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theUser:secret%40secret@theHost");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"theUser", (String)uri.getUser());
        MuleEndpointURITestCase.assertEquals((String)"secret@secret", (String)uri.getPassword());
        MuleEndpointURITestCase.assertEquals((int)0, (int)uri.getParams().size());
    }

    public void testUriWithPath() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost/thePath");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"/thePath", (String)uri.getPath());
        MuleEndpointURITestCase.assertEquals((int)0, (int)uri.getParams().size());
    }

    public void testUriWithQuery() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost?query=xxx");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"query=xxx", (String)uri.getQuery());
        Properties params = uri.getParams();
        MuleEndpointURITestCase.assertEquals((int)1, (int)params.size());
        MuleEndpointURITestCase.assertEquals((String)"xxx", (String)params.getProperty("query"));
    }

    public void testUriWithQueryContainingAtSign() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost?query=xxx@yyy");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"query=xxx@yyy", (String)uri.getQuery());
        Properties params = uri.getParams();
        MuleEndpointURITestCase.assertEquals((int)1, (int)params.size());
        MuleEndpointURITestCase.assertEquals((String)"xxx@yyy", (String)params.getProperty("query"));
    }

    public void testUriWithPathAndQuery() throws Exception {
        MuleEndpointURI uri = this.buildEndpointUri("test://theHost/thePath?query=xxx");
        this.assertSchemeAndHostAndEnpointName(uri);
        MuleEndpointURITestCase.assertEquals((int)-1, (int)uri.getPort());
        MuleEndpointURITestCase.assertEquals((String)"/thePath", (String)uri.getPath());
        MuleEndpointURITestCase.assertEquals((String)"query=xxx", (String)uri.getQuery());
        Properties params = uri.getParams();
        MuleEndpointURITestCase.assertEquals((int)1, (int)params.size());
        MuleEndpointURITestCase.assertEquals((String)"xxx", (String)params.getProperty("query"));
    }

    public void testPasswordMasking() throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI("test://theUser:password@theHost", muleContext);
        MuleEndpointURITestCase.assertEquals((String)"test://theUser:****@theHost", (String)uri.toString());
    }

    public void testPasswordMaskingWithUsernameContainingAtSign() throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI("test://theUser%40theEmailHost:password@theHost", muleContext);
        MuleEndpointURITestCase.assertEquals((String)"test://theUser%40theEmailHost:****@theHost", (String)uri.toString());
    }

    private MuleEndpointURI buildEndpointUri(String uriString) throws MuleException {
        MuleEndpointURI uri = new MuleEndpointURI(uriString, muleContext);
        uri.initialise();
        return uri;
    }

    private void assertSchemeAndHostAndEnpointName(MuleEndpointURI uri) {
        MuleEndpointURITestCase.assertEquals((String)"test", (String)uri.getScheme());
        MuleEndpointURITestCase.assertEquals((String)"theHost", (String)uri.getHost());
        MuleEndpointURITestCase.assertNull((Object)uri.getEndpointName());
    }
}

