/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.dynamic.NullConnector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;

public class DynamicEndpointParsingTestCase
extends AbstractMuleTestCase {
    public DynamicEndpointParsingTestCase() {
        this.setStartContext(true);
    }

    public void testSingleExpression() throws Exception {
        OutboundEndpoint endpoint = this.createEndpoint("test://localhost:#[header:port]");
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof NullConnector));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        endpoint.process(event);
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof TestConnector));
    }

    public void testSingleMultiExpression() throws Exception {
        OutboundEndpoint endpoint = this.createEndpoint("test://#[header:host]:#[header:port]");
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof NullConnector));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        event.getMessage().setOutboundProperty("host", (Object)"localhost");
        endpoint.process(event);
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof TestConnector));
    }

    public void testMissingExpressionResult() throws Exception {
        OutboundEndpoint endpoint = this.createEndpoint("test://#[header:host]:#[header:port]");
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof NullConnector));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        try {
            endpoint.process(event);
            DynamicEndpointParsingTestCase.fail((String)"A required header is missing on the message");
        }
        catch (DispatchException e) {
            DynamicEndpointParsingTestCase.assertTrue((boolean)(e.getCause() instanceof RequiredValueException));
        }
    }

    public void testExpressionInScheme() throws Exception {
        try {
            this.createEndpoint("#[header:scheme]://#[header:host]:#[header:port]");
            DynamicEndpointParsingTestCase.fail((String)"The scheme part of a dynamic endpoint cannot be an expression");
        }
        catch (MalformedEndpointException malformedEndpointException) {
            // empty catch block
        }
    }

    public void testMalformedEndpoint() throws Exception {
        try {
            this.createEndpoint("test://#[header:host:#[header:port]");
            DynamicEndpointParsingTestCase.fail((String)"The endpoint expressions are malformed");
        }
        catch (MalformedEndpointException malformedEndpointException) {
            // empty catch block
        }
    }

    public void testInboundEndpoint() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://#[header:host]:#[header:port]", muleContext);
        try {
            endpointBuilder.buildInboundEndpoint();
            DynamicEndpointParsingTestCase.fail((String)"Dynamic inbound endpoints not allowed");
        }
        catch (MalformedEndpointException malformedEndpointException) {
            // empty catch block
        }
    }

    public void testConnectorURIParam() throws Exception {
        TestConnector tc = new TestConnector(muleContext);
        tc.setName("myTestConnector");
        muleContext.getRegistry().registerConnector((Connector)tc);
        OutboundEndpoint endpoint = this.createEndpoint("test://#[header:host]:#[header:port]?connectorName=myTestConnector");
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof NullConnector));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        event.getMessage().setOutboundProperty("host", (Object)"localhost");
        endpoint.process(event);
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof TestConnector));
        DynamicEndpointParsingTestCase.assertEquals((String)"myTestConnector", (String)endpoint.getConnector().getName());
    }

    public void testMEPURIParam() throws Exception {
        OutboundEndpoint endpoint = this.createEndpoint("test://#[header:host]:#[header:port]");
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof NullConnector));
        MuleEvent event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        event.getMessage().setOutboundProperty("host", (Object)"localhost");
        endpoint.process(event);
        DynamicEndpointParsingTestCase.assertEquals((Object)MessageExchangePattern.ONE_WAY, (Object)endpoint.getExchangePattern());
        endpoint = this.createEndpoint("test://#[header:host]:#[header:port]?exchangePattern=REQUEST_RESPONSE");
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        DynamicEndpointParsingTestCase.assertTrue((boolean)(endpoint.getConnector() instanceof NullConnector));
        event = DynamicEndpointParsingTestCase.getTestEvent("test");
        event.getMessage().setOutboundProperty("port", (Object)12345);
        event.getMessage().setOutboundProperty("host", (Object)"localhost");
        endpoint.process(event);
        DynamicEndpointParsingTestCase.assertEquals((Object)MessageExchangePattern.REQUEST_RESPONSE, (Object)endpoint.getExchangePattern());
    }

    protected OutboundEndpoint createEndpoint(String uri) throws EndpointException, InitialisationException {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        return endpointBuilder.buildOutboundEndpoint();
    }
}

