/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.expression.MessageExpressionEvaluator;
import org.mule.message.DefaultExceptionPayload;
import org.mule.tck.AbstractMuleTestCase;

public class MessageExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    public void testUsingEvaluatorDirectly() throws Exception {
        MessageExpressionEvaluator eval = new MessageExpressionEvaluator();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        Object result = eval.evaluate(null, (MuleMessage)message);
        MessageExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MessageExpressionEvaluatorTestCase.assertEquals((Object)message, (Object)result);
        result = eval.evaluate(null, null);
        MessageExpressionEvaluatorTestCase.assertNull((Object)result);
        MessageExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("id", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("correlationId", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)new Integer(1), (Object)eval.evaluate("correlationSequence", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)new Integer(2), (Object)eval.evaluate("correlationGroupSize", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)"foo", (Object)eval.evaluate("replyTo", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)e, (Object)eval.evaluate("exception", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)"UTF-8", (Object)eval.evaluate("encoding", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)"test", (Object)eval.evaluate("payload", (MuleMessage)message));
        try {
            eval.evaluate("xxx", (MuleMessage)message);
            MessageExpressionEvaluatorTestCase.fail((String)"xxx is not a supported expresion");
        }
        catch (Exception e1) {
            // empty catch block
        }
    }

    public void testUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[message:id]", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[message:correlationId]", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)new Integer(1), (Object)muleContext.getExpressionManager().evaluate("#[message:correlationSequence]", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)new Integer(2), (Object)muleContext.getExpressionManager().evaluate("#[message:correlationGroupSize]", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)"foo", (Object)muleContext.getExpressionManager().evaluate("#[message:replyTo]", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)e, (Object)muleContext.getExpressionManager().evaluate("#[message:exception]", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)"UTF-8", (Object)muleContext.getExpressionManager().evaluate("#[message:encoding]", (MuleMessage)message));
        MessageExpressionEvaluatorTestCase.assertEquals((Object)"test", (Object)muleContext.getExpressionManager().evaluate("#[message:payload]", (MuleMessage)message));
        try {
            muleContext.getExpressionManager().evaluate("#[message:xxx]", (MuleMessage)message, true);
            MessageExpressionEvaluatorTestCase.fail((String)"xxx is not a supported expresion");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

